/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.BossBar;

import java.util.HashMap;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossBarManager {
    private HashMap<String, BossBar> barMap = new HashMap();

    public void createBossBar(String id, BossBar b) {
        if (this.barMap.containsKey(id)) {
            this.barMap.get(id).removeAll();
            this.barMap.remove(id);
        }
        this.barMap.put(id, b);
    }

    public void addFlag(String id, BarFlag f) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.addFlag(f);
            this.barMap.put(id, bar);
        }
    }

    public void removeFlag(String id, BarFlag f) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.removeFlag(f);
            this.barMap.put(id, bar);
        }
    }

    public void addPlayers(String id, Player[] f) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            Player[] playerArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                bar.addPlayer(p);
                ++n2;
            }
            this.barMap.put(id, bar);
        }
    }

    public void removePlayers(String id, Player[] f) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            Player[] playerArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                bar.removePlayer(p);
                ++n2;
            }
            this.barMap.put(id, bar);
        }
    }

    public void removeBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.removeAll();
            this.barMap.remove(id);
        }
    }

    public void changeTitle(String id, String title) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setTitle(title);
            this.barMap.put(id, bar);
        }
    }

    public void changeValue(String id, double d) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            if (d > 100.0) {
                d = 100.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            bar.setProgress(d / 100.0);
            this.barMap.put(id, bar);
        }
    }

    public void changeColor(String id, BarColor c) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setColor(c);
            this.barMap.put(id, bar);
        }
    }

    public void changeStyle(String id, BarStyle s) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setStyle(s);
            this.barMap.put(id, bar);
        }
    }

    public void hideBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setVisible(false);
            this.barMap.put(id, bar);
        }
    }

    public void showBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setVisible(true);
            this.barMap.put(id, bar);
        }
    }

    public String getBarTitle(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            return bar.getTitle();
        }
        return null;
    }

    public Number getBarProgres(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            return bar.getProgress();
        }
        return null;
    }

    public void dumpData() {
        this.barMap.clear();
    }
}

