/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.ParticleEffect;
import net.rayfall.eyesniper2.skrayfall.SyntaxManagerInterface;
import net.rayfall.eyesniper2.skrayfall.bossbar.RayFallBarColor;
import net.rayfall.eyesniper2.skrayfall.bossbar.RayFallBarFlag;
import net.rayfall.eyesniper2.skrayfall.bossbar.RayFallBarStyle;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;
import org.eclipse.jdt.annotation.Nullable;

public class TypeManager
implements SyntaxManagerInterface {
    private JavaPlugin plugin;

    TypeManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void registerSyntax() {
        if (Skript.isAcceptRegistrations()) {
            this.registerTypes();
            if (Skript.isRunningMinecraft((int)1, (int)9)) {
                this.registerV1_9Elements();
                if (!Bukkit.getVersion().contains("(MC: 1.9)") && !Bukkit.getVersion().contains("(MC: 1.9.1)")) {
                    this.registerV1_9_2Elements();
                } else {
                    this.registerNon1_9_2TeamElements();
                }
            } else if (Skript.isRunningMinecraft((int)1, (int)8)) {
                this.registerNon1_9_2TeamElements();
            }
        } else {
            this.plugin.getLogger().info("skRayFall was unable to register some extra types.");
        }
    }

    private void registerTypes() {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            this.plugin.getLogger().warning("EffectLib 6.0 for 1.13 is not supported as of right now since it has backwards breaking changes for users below 1.10");
            return;
        }
        Classes.registerClass((ClassInfo)new ClassInfo(ParticleEffect.class, "effectlibparticle").parser((Parser)new Parser<ParticleEffect>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public ParticleEffect parse(String value, ParseContext cont) {
                try {
                    return ParticleEffect.valueOf(value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(ParticleEffect eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(ParticleEffect eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }).name("EffectLib Particle").description(new String[]{"Particles that are to be used in EffectLib based effects. Full list can be found here!"}).usage(new String[]{"Lava, Mob, Note, Portal, Redstone, Slime, etc."}));
    }

    private void registerNon1_9_2TeamElements() {
        Classes.registerClass((ClassInfo)new ClassInfo(NameTagVisibility.class, "nametagvisibility").parser((Parser)new Parser<NameTagVisibility>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public NameTagVisibility parse(String value, ParseContext cont) {
                try {
                    return NameTagVisibility.valueOf((String)value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(NameTagVisibility name, int in) {
                return name.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(NameTagVisibility name) {
                return name.name().replace("_", " ").toLowerCase();
            }
        }));
    }

    private void registerV1_9Elements() {
        Classes.registerClass((ClassInfo)new ClassInfo(RayFallBarColor.class, "bossbarcolor").parser((Parser)new Parser<RayFallBarColor>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public RayFallBarColor parse(String value, ParseContext cont) {
                try {
                    return RayFallBarColor.valueOf(value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(RayFallBarColor eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(RayFallBarColor eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }).name("Bossbar Color").description(new String[]{"A data type to call the colors for the new 1.9 bossbars."}).usage(new String[]{"blue, green, pink, purple, red, white or yellow"}));
        Classes.registerClass((ClassInfo)new ClassInfo(RayFallBarFlag.class, "bossbarflag").parser((Parser)new Parser<RayFallBarFlag>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public RayFallBarFlag parse(String value, ParseContext cont) {
                try {
                    return RayFallBarFlag.valueOf(value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(RayFallBarFlag eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(RayFallBarFlag eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }).name("Bossbar Flag").description(new String[]{"Bar Flags to support the new 1.9 bossbars."}).usage(new String[]{"create fog, darken sky or play boss music"}));
        Classes.registerClass((ClassInfo)new ClassInfo(RayFallBarStyle.class, "bossbarstyle").parser((Parser)new Parser<RayFallBarStyle>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public RayFallBarStyle parse(String value, ParseContext cont) {
                try {
                    return RayFallBarStyle.valueOf(value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(RayFallBarStyle eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(RayFallBarStyle eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }).name("Bossbar Style").description(new String[]{"Bossbar styles to support the new 1.9 BossBar."}).usage(new String[]{"segmented 10, segmented 12, segmented 20, segmented 6 and solid"}));
    }

    private void registerV1_9_2Elements() {
        Classes.registerClass((ClassInfo)new ClassInfo(Team.OptionStatus.class, "teamoptionstatus").parser((Parser)new Parser<Team.OptionStatus>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public Team.OptionStatus parse(String value, ParseContext cont) {
                try {
                    return Team.OptionStatus.valueOf((String)value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(Team.OptionStatus eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(Team.OptionStatus eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }));
    }
}

