/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.bossbar;

import java.util.HashMap;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossBarManager {
    private HashMap<String, BossBar> barMap = new HashMap();

    void createBossBar(String id, BossBar bossbar) {
        if (this.barMap.containsKey(id)) {
            this.barMap.get(id).removeAll();
            this.barMap.remove(id);
        }
        this.barMap.put(id, bossbar);
    }

    void addFlag(String id, BarFlag flag) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.addFlag(flag);
            this.barMap.put(id, bar);
        }
    }

    void removeFlag(String id, BarFlag flag) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.removeFlag(flag);
            this.barMap.put(id, bar);
        }
    }

    void addPlayers(String id, Player[] players) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            for (Player p : players) {
                bar.addPlayer(p);
            }
            this.barMap.put(id, bar);
        }
    }

    void removePlayers(String id, Player[] players) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            for (Player p : players) {
                bar.removePlayer(p);
            }
            this.barMap.put(id, bar);
        }
    }

    void removeBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.removeAll();
            this.barMap.remove(id);
        }
    }

    void changeTitle(String id, String title) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setTitle(title);
            this.barMap.put(id, bar);
        }
    }

    void changeValue(String id, double progress) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            if (progress > 100.0) {
                progress = 100.0;
            } else if (progress < 0.0) {
                progress = 0.0;
            }
            bar.setProgress(progress / 100.0);
            this.barMap.put(id, bar);
        }
    }

    void changeColor(String id, BarColor color) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setColor(color);
            this.barMap.put(id, bar);
        }
    }

    void changeStyle(String id, BarStyle style) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setStyle(style);
            this.barMap.put(id, bar);
        }
    }

    void hideBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setVisible(false);
            this.barMap.put(id, bar);
        }
    }

    void showBar(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            bar.setVisible(true);
            this.barMap.put(id, bar);
        }
    }

    String getBarTitle(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            return bar.getTitle();
        }
        return null;
    }

    Number getBarProgress(String id) {
        BossBar bar = this.barMap.get(id);
        if (bar != null) {
            return bar.getProgress();
        }
        return null;
    }

    public void dumpData() {
        this.barMap.clear();
    }
}

