/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.math;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.rayfall.eyesniper2.skRayFall.effectlib.math.EquationTransform;

public class EquationStore {
    private static EquationStore instance;
    private Map<String, EquationTransform> transforms = new HashMap<String, EquationTransform>();
    public static final String DEFAULT_VARIABLE = "x";

    public EquationTransform getTransform(String equation) {
        return this.getTransform(equation, DEFAULT_VARIABLE);
    }

    public EquationTransform getTransform(String equation, String variable) {
        EquationTransform transform = this.transforms.get(equation);
        if (transform == null) {
            transform = new EquationTransform(equation, variable);
            this.transforms.put(equation, transform);
        }
        return transform;
    }

    public EquationTransform getTransform(String equation, String ... variables) {
        EquationTransform transform = this.transforms.get(equation);
        if (transform == null) {
            transform = new EquationTransform(equation, variables);
            this.transforms.put(equation, transform);
        }
        return transform;
    }

    public EquationTransform getTransform(String equation, Set<String> variables) {
        EquationTransform transform = this.transforms.get(equation);
        if (transform == null) {
            transform = new EquationTransform(equation, variables);
            this.transforms.put(equation, transform);
        }
        return transform;
    }

    public static EquationStore getInstance() {
        if (instance == null) {
            instance = new EquationStore();
        }
        return instance;
    }
}

