/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.scoreboard;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Set Below Name Score")
@Description(value={"Set score of a sidebar by:", "* Name", "* Value", "* Player", "* Target", "This will change the name and score below a player's name"})
public class EffSetScoreBelowName
extends Effect {
    private Expression<Player> player;
    private Expression<Player> targets;
    private Expression<String> name;
    private Expression<Number> num;

    public boolean init(Expression<?>[] exp, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.player = exp[1];
        this.name = exp[0];
        this.num = exp[2];
        this.targets = exp[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    protected void execute(Event evt) {
        if (!((Player)this.player.getSingle(evt)).isOnline()) {
            Skript.error((String)"[SetScoreBelowName] The player is not online!");
        } else if (this.num.getSingle(evt) == null) {
            Skript.error((String)"[SetScoreBelowName] The scoreboard value is not set!");
        } else if (this.name.getSingle(evt) == null) {
            Skript.error((String)"[SetScoreBelowName] The scoreboard name is not set!");
        } else {
            int value = ((Number)this.num.getSingle(evt)).intValue();
            String displayName = ((String)this.name.getSingle(evt)).replace("\"", "");
            for (Player target : (Player[])this.targets.getAll(evt)) {
                Score score;
                if (target.getScoreboard().getObjective("bottomHold") != null) {
                    Objective objective = target.getScoreboard().getObjective(DisplaySlot.BELOW_NAME);
                    objective.setDisplayName(displayName);
                    score = objective.getScore(((Player)this.player.getSingle(evt)).getName());
                    score.setScore(value);
                    continue;
                }
                Objective objectiveh = target.getScoreboard().registerNewObjective("bottomHold", "dummy");
                objectiveh.setDisplaySlot(DisplaySlot.BELOW_NAME);
                objectiveh.setDisplayName(displayName);
                score = objectiveh.getScore(((Player)this.player.getSingle(evt)).getName());
                score.setScore(value);
            }
        }
    }
}

