/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.scoreboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.rayfall.eyesniper2.skrayfall.scoreboard.GroupScore;
import net.rayfall.eyesniper2.skrayfall.scoreboard.SingleScore;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

public class IdScoreBoardManager
implements Listener {
    private HashMap<String, SingleScore> singleScoreMap = new HashMap();
    private HashMap<String, ArrayList<Player>> groupMap = new HashMap();
    private HashMap<String, GroupScore> groupScoreMap = new HashMap();

    public IdScoreBoardManager(Plugin core) {
        core.getServer().getPluginManager().registerEvents((Listener)this, core);
    }

    public void dumpData() {
        this.singleScoreMap.clear();
        this.groupMap.clear();
        this.groupScoreMap.clear();
    }

    void setScoreId(String id, Score score, Player player) {
        this.singleScoreMap.put(id, new SingleScore(score, player));
    }

    void adjustGroupIdScore(String id, String text, int value) {
        this.groupScoreMap.put(id, new GroupScore(text, value));
        this.groupMap.put(id, new ArrayList());
    }

    void addPlayerToGroupId(String id, Player player) {
        if (this.groupScoreMap.containsKey(id) && player != null) {
            this.groupMap.get(id).add(player);
            GroupScore score = this.groupScoreMap.get(id);
            Score newScore = player.getScoreboard().getObjective(DisplaySlot.SIDEBAR).getScore(score.getName());
            newScore.setScore(score.getValue());
        }
    }

    void removePlayerFromGroupScore(String id, Player player) {
        if (this.groupScoreMap.containsKey(id) && this.groupMap.get(id).contains(player)) {
            GroupScore score = this.groupScoreMap.get(id);
            player.getScoreboard().resetScores(score.getName());
            this.groupMap.get(id).remove(player);
        }
    }

    void groupUpdateScore(String id, String newName, int newValue) {
        if (this.groupScoreMap.containsKey(id) && this.groupMap.get(id) != null) {
            ArrayList<Player> ls = this.groupMap.get(id);
            GroupScore old = this.groupScoreMap.get(id);
            for (Player p : ls) {
                Objective obj = p.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
                obj.getScoreboard().resetScores(old.getName());
                Score newScore = obj.getScore(newName);
                newScore.setScore(newValue);
            }
            this.groupScoreMap.put(id, new GroupScore(newName, newValue));
        }
    }

    void updateSingleScore(String id, String newName, int newValue) {
        if (this.singleScoreMap.containsKey(id)) {
            SingleScore old = this.singleScoreMap.get(id);
            Player player = old.getPlayer();
            Objective obj = player.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
            Score newScore = obj.getScore(newName);
            obj.getScoreboard().resetScores(old.getScore().getEntry());
            newScore.setScore(newValue);
            this.singleScoreMap.put(id, new SingleScore(newScore, player));
        }
    }

    public boolean isIdSet(String id) {
        return this.singleScoreMap.containsKey(id);
    }

    Score getScore(String id) {
        if (this.singleScoreMap.containsKey(id)) {
            return this.singleScoreMap.get(id).getScore();
        }
        return null;
    }

    void deleteScoreId(String id) {
        this.singleScoreMap.remove(id);
    }

    void removeSingleScoresFromPlayer(Player player) {
        Iterator<String> iterator2 = this.singleScoreMap.keySet().iterator();
        while (iterator2.hasNext()) {
            String id = iterator2.next();
            if (this.singleScoreMap.get(id).getPlayer() != player) continue;
            iterator2.remove();
        }
    }

    void removeGroupScoresFromPlayer(Player player) {
        for (String id : this.groupMap.keySet()) {
            if (!this.groupMap.get(id).contains(player)) continue;
            this.groupMap.get(id).remove(player);
        }
    }

    void deleteGroupScore(String id) {
        if (this.groupScoreMap.containsKey(id)) {
            ArrayList<Player> ls = this.groupMap.get(id);
            GroupScore old = this.groupScoreMap.get(id);
            for (Player p : ls) {
                p.getScoreboard().resetScores(old.getName());
            }
        }
    }

    String getNameOfSingleScore(String id) {
        SingleScore score = this.singleScoreMap.get(id);
        if (score != null) {
            return score.getScore().getEntry();
        }
        return null;
    }

    int getValueOfSingleScore(String id) {
        SingleScore score = this.singleScoreMap.get(id);
        if (score != null) {
            return score.getScore().getScore();
        }
        return 0;
    }

    String getNameOfGroupScore(String id) {
        GroupScore score = this.groupScoreMap.get(id);
        if (score != null) {
            return score.getName();
        }
        return null;
    }

    int getValueOfGroupScore(String id) {
        GroupScore score = this.groupScoreMap.get(id);
        if (score != null) {
            return score.getValue();
        }
        return 0;
    }

    @EventHandler
    public void autoRemovePlayersScores(PlayerQuitEvent evt) {
        this.removeSingleScoresFromPlayer(evt.getPlayer());
        this.removeGroupScoresFromPlayer(evt.getPlayer());
    }
}

