/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.general.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shiny Item")
@Description(value={"Show Items by:", "* Glow", "Makes an item glow as an enchanted item but without the lore"})
@Examples(value={"give player shiny diamond"})
public class ExprShinyItem
extends SimplePropertyExpression<ItemStack, ItemStack> {
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Nullable
    public ItemStack convert(ItemStack itemStack) {
        if (itemStack.getType() == Material.BOW) {
            itemStack.addUnsafeEnchantment(Enchantment.DIG_SPEED, 1);
        } else {
            itemStack.addUnsafeEnchantment(Enchantment.ARROW_DAMAGE, 1);
        }
        ItemMeta meta = itemStack.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    protected String getPropertyName() {
        return "Shiny";
    }
}

