/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.citizens.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.rayfall.eyesniper2.skrayfall.citizens.expressions.ExprLastCitizen;
import net.rayfall.eyesniper2.skrayfall.utli.ScrubEntityType;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;

@Name(value="Create Citizen")
@Description(value={"Create citizens with:", "* Name", "* Direction", "* Location", "* Entity Type", "This will place an NPC in your world that can be modified"})
@RequiredPlugins(value={"Citizens"})
public class EffCreateCitizen
extends Effect {
    private Expression<Location> location;
    private Expression<String> name;
    private Expression<EntityType> type;

    public boolean init(Expression<?>[] exprs, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.name = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        this.type = exprs[3];
        return true;
    }

    public String toString(Event evt, boolean arg1) {
        return "Created NPC named: " + this.name.toString(evt, arg1) + " Loaction: " + this.location.toString(evt, arg1) + " Type:" + this.type.toString();
    }

    public void execute(Event evt) {
        NPCRegistry registry = CitizensAPI.getNPCRegistry();
        EntityType citizenType = ScrubEntityType.getType(this.type.toString());
        NPC npc = registry.createNPC(citizenType, ((String)this.name.getSingle(evt)).toString().replace("\"", ""));
        Location spawnto = (Location)this.location.getSingle(evt);
        npc.spawn(spawnto);
        ExprLastCitizen.lastNPC = npc;
    }
}

