/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.math;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import net.rayfall.eyesniper2.skRayFall.effectlib.math.Transform;
import net.rayfall.eyesniper2.skRayFall.exp4j.Expression;
import net.rayfall.eyesniper2.skRayFall.exp4j.ExpressionBuilder;
import net.rayfall.eyesniper2.skRayFall.exp4j.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class EquationTransform
implements Transform {
    private Expression expression;
    private static Function randFunction;
    private final Set<String> inputVariables = new HashSet<String>();

    @Override
    public void load(ConfigurationSection parameters) {
        this.setEquation(parameters.getString("equation", ""));
    }

    public EquationTransform(String equation) {
        this(equation, "t");
    }

    public EquationTransform(String equation, String inputVariable) {
        this.inputVariables.add(inputVariable);
        this.setEquation(equation);
    }

    public EquationTransform(String equation, String ... inputVariables) {
        for (String inputVariable : inputVariables) {
            this.inputVariables.add(inputVariable);
        }
        this.setEquation(equation);
    }

    public void setEquation(String equation) {
        try {
            if (randFunction == null) {
                randFunction = new Function("rand", 2){
                    private Random random;
                    {
                        this.random = new Random();
                    }

                    @Override
                    public double apply(double ... args) {
                        return this.random.nextDouble() * (args[1] - args[0]) + args[0];
                    }
                };
            }
            this.expression = new ExpressionBuilder(equation).function(randFunction).variables(this.inputVariables).build();
        }
        catch (Exception ex) {
            this.expression = null;
            Bukkit.getLogger().log(Level.WARNING, "Error parsing equation " + equation, ex);
        }
    }

    @Override
    public double get(double t) {
        if (this.expression == null) {
            return 0.0;
        }
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t);
        }
        return this.expression.evaluate();
    }

    public double get(double ... t) {
        if (this.expression == null) {
            return 0.0;
        }
        int index = 0;
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t[index]);
            if (index >= t.length - 1) continue;
            ++index;
        }
        return this.expression.evaluate();
    }
}

