/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import redis.clients.util.JedisClusterHashTagUtil;
import redis.clients.util.SafeEncoder;

public final class JedisClusterCRC16 {
    private static final int[] LOOKUP_TABLE;

    static {
        int[] nArray = new int[256];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        nArray[16] = 4657;
        nArray[17] = 528;
        nArray[18] = 12915;
        nArray[19] = 8786;
        nArray[20] = 21173;
        nArray[21] = 17044;
        nArray[22] = 29431;
        nArray[23] = 25302;
        nArray[24] = 37689;
        nArray[25] = 33560;
        nArray[26] = 45947;
        nArray[27] = 41818;
        nArray[28] = 54205;
        nArray[29] = 50076;
        nArray[30] = 62463;
        nArray[31] = 58334;
        nArray[32] = 9314;
        nArray[33] = 13379;
        nArray[34] = 1056;
        nArray[35] = 5121;
        nArray[36] = 25830;
        nArray[37] = 29895;
        nArray[38] = 17572;
        nArray[39] = 21637;
        nArray[40] = 42346;
        nArray[41] = 46411;
        nArray[42] = 34088;
        nArray[43] = 38153;
        nArray[44] = 58862;
        nArray[45] = 62927;
        nArray[46] = 50604;
        nArray[47] = 54669;
        nArray[48] = 13907;
        nArray[49] = 9842;
        nArray[50] = 5649;
        nArray[51] = 1584;
        nArray[52] = 30423;
        nArray[53] = 26358;
        nArray[54] = 22165;
        nArray[55] = 18100;
        nArray[56] = 46939;
        nArray[57] = 42874;
        nArray[58] = 38681;
        nArray[59] = 34616;
        nArray[60] = 63455;
        nArray[61] = 59390;
        nArray[62] = 55197;
        nArray[63] = 51132;
        nArray[64] = 18628;
        nArray[65] = 22757;
        nArray[66] = 26758;
        nArray[67] = 30887;
        nArray[68] = 2112;
        nArray[69] = 6241;
        nArray[70] = 10242;
        nArray[71] = 14371;
        nArray[72] = 51660;
        nArray[73] = 55789;
        nArray[74] = 59790;
        nArray[75] = 63919;
        nArray[76] = 35144;
        nArray[77] = 39273;
        nArray[78] = 43274;
        nArray[79] = 47403;
        nArray[80] = 23285;
        nArray[81] = 19156;
        nArray[82] = 31415;
        nArray[83] = 27286;
        nArray[84] = 6769;
        nArray[85] = 2640;
        nArray[86] = 14899;
        nArray[87] = 10770;
        nArray[88] = 56317;
        nArray[89] = 52188;
        nArray[90] = 64447;
        nArray[91] = 60318;
        nArray[92] = 39801;
        nArray[93] = 35672;
        nArray[94] = 47931;
        nArray[95] = 43802;
        nArray[96] = 27814;
        nArray[97] = 31879;
        nArray[98] = 19684;
        nArray[99] = 23749;
        nArray[100] = 11298;
        nArray[101] = 15363;
        nArray[102] = 3168;
        nArray[103] = 7233;
        nArray[104] = 60846;
        nArray[105] = 64911;
        nArray[106] = 52716;
        nArray[107] = 56781;
        nArray[108] = 44330;
        nArray[109] = 48395;
        nArray[110] = 36200;
        nArray[111] = 40265;
        nArray[112] = 32407;
        nArray[113] = 28342;
        nArray[114] = 24277;
        nArray[115] = 20212;
        nArray[116] = 15891;
        nArray[117] = 11826;
        nArray[118] = 7761;
        nArray[119] = 3696;
        nArray[120] = 65439;
        nArray[121] = 61374;
        nArray[122] = 57309;
        nArray[123] = 53244;
        nArray[124] = 48923;
        nArray[125] = 44858;
        nArray[126] = 40793;
        nArray[127] = 36728;
        nArray[128] = 37256;
        nArray[129] = 33193;
        nArray[130] = 45514;
        nArray[131] = 41451;
        nArray[132] = 53516;
        nArray[133] = 49453;
        nArray[134] = 61774;
        nArray[135] = 57711;
        nArray[136] = 4224;
        nArray[137] = 161;
        nArray[138] = 12482;
        nArray[139] = 8419;
        nArray[140] = 20484;
        nArray[141] = 16421;
        nArray[142] = 28742;
        nArray[143] = 24679;
        nArray[144] = 33721;
        nArray[145] = 37784;
        nArray[146] = 41979;
        nArray[147] = 46042;
        nArray[148] = 49981;
        nArray[149] = 54044;
        nArray[150] = 58239;
        nArray[151] = 62302;
        nArray[152] = 689;
        nArray[153] = 4752;
        nArray[154] = 8947;
        nArray[155] = 13010;
        nArray[156] = 16949;
        nArray[157] = 21012;
        nArray[158] = 25207;
        nArray[159] = 29270;
        nArray[160] = 46570;
        nArray[161] = 42443;
        nArray[162] = 38312;
        nArray[163] = 34185;
        nArray[164] = 62830;
        nArray[165] = 58703;
        nArray[166] = 54572;
        nArray[167] = 50445;
        nArray[168] = 13538;
        nArray[169] = 9411;
        nArray[170] = 5280;
        nArray[171] = 1153;
        nArray[172] = 29798;
        nArray[173] = 25671;
        nArray[174] = 21540;
        nArray[175] = 17413;
        nArray[176] = 42971;
        nArray[177] = 47098;
        nArray[178] = 34713;
        nArray[179] = 38840;
        nArray[180] = 59231;
        nArray[181] = 63358;
        nArray[182] = 50973;
        nArray[183] = 55100;
        nArray[184] = 9939;
        nArray[185] = 14066;
        nArray[186] = 1681;
        nArray[187] = 5808;
        nArray[188] = 26199;
        nArray[189] = 30326;
        nArray[190] = 17941;
        nArray[191] = 22068;
        nArray[192] = 55628;
        nArray[193] = 51565;
        nArray[194] = 63758;
        nArray[195] = 59695;
        nArray[196] = 39368;
        nArray[197] = 35305;
        nArray[198] = 47498;
        nArray[199] = 43435;
        nArray[200] = 22596;
        nArray[201] = 18533;
        nArray[202] = 30726;
        nArray[203] = 26663;
        nArray[204] = 6336;
        nArray[205] = 2273;
        nArray[206] = 14466;
        nArray[207] = 10403;
        nArray[208] = 52093;
        nArray[209] = 56156;
        nArray[210] = 60223;
        nArray[211] = 64286;
        nArray[212] = 35833;
        nArray[213] = 39896;
        nArray[214] = 43963;
        nArray[215] = 48026;
        nArray[216] = 19061;
        nArray[217] = 23124;
        nArray[218] = 27191;
        nArray[219] = 31254;
        nArray[220] = 2801;
        nArray[221] = 6864;
        nArray[222] = 10931;
        nArray[223] = 14994;
        nArray[224] = 64814;
        nArray[225] = 60687;
        nArray[226] = 56684;
        nArray[227] = 52557;
        nArray[228] = 48554;
        nArray[229] = 44427;
        nArray[230] = 40424;
        nArray[231] = 36297;
        nArray[232] = 31782;
        nArray[233] = 27655;
        nArray[234] = 23652;
        nArray[235] = 19525;
        nArray[236] = 15522;
        nArray[237] = 11395;
        nArray[238] = 7392;
        nArray[239] = 3265;
        nArray[240] = 61215;
        nArray[241] = 65342;
        nArray[242] = 53085;
        nArray[243] = 57212;
        nArray[244] = 44955;
        nArray[245] = 49082;
        nArray[246] = 36825;
        nArray[247] = 40952;
        nArray[248] = 28183;
        nArray[249] = 32310;
        nArray[250] = 20053;
        nArray[251] = 24180;
        nArray[252] = 11923;
        nArray[253] = 16050;
        nArray[254] = 3793;
        nArray[255] = 7920;
        LOOKUP_TABLE = nArray;
    }

    private JedisClusterCRC16() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static int getSlot(String key) {
        key = JedisClusterHashTagUtil.getHashTag(key);
        return JedisClusterCRC16.getCRC16(key) & 0x3FFF;
    }

    public static int getSlot(byte[] key) {
        int s = -1;
        int e = -1;
        boolean sFound = false;
        int i = 0;
        while (i < key.length) {
            if (key[i] == 123 && !sFound) {
                s = i;
                sFound = true;
            }
            if (key[i] == 125 && sFound) {
                e = i;
                break;
            }
            ++i;
        }
        if (s > -1 && e > -1 && e != s + 1) {
            return JedisClusterCRC16.getCRC16(key, s + 1, e) & 0x3FFF;
        }
        return JedisClusterCRC16.getCRC16(key) & 0x3FFF;
    }

    public static int getCRC16(byte[] bytes, int s, int e) {
        int crc = 0;
        int i = s;
        while (i < e) {
            crc = crc << 8 ^ LOOKUP_TABLE[(crc >>> 8 ^ bytes[i] & 0xFF) & 0xFF];
            ++i;
        }
        return crc & 0xFFFF;
    }

    public static int getCRC16(byte[] bytes) {
        return JedisClusterCRC16.getCRC16(bytes, 0, bytes.length);
    }

    public static int getCRC16(String key) {
        byte[] bytesKey = SafeEncoder.encode(key);
        return JedisClusterCRC16.getCRC16(bytesKey, 0, bytesKey.length);
    }
}

