/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params.set;

import java.util.ArrayList;
import redis.clients.jedis.params.Params;
import redis.clients.util.SafeEncoder;

public class SetParams
extends Params {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";

    private SetParams() {
    }

    public static SetParams setParams() {
        return new SetParams();
    }

    public SetParams ex(int secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public SetParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public SetParams nx() {
        this.addParam(NX);
        return this;
    }

    public SetParams xx() {
        this.addParam(XX);
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byte[][] byArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arg = byArray[n2];
            byteParams.add(arg);
            ++n2;
        }
        if (this.contains(NX)) {
            byteParams.add(SafeEncoder.encode(NX));
        }
        if (this.contains(XX)) {
            byteParams.add(SafeEncoder.encode(XX));
        }
        if (this.contains(EX)) {
            byteParams.add(SafeEncoder.encode(EX));
            byteParams.add(SafeEncoder.encode(String.valueOf((char[])this.getParam(EX))));
        }
        if (this.contains(PX)) {
            byteParams.add(SafeEncoder.encode(PX));
            byteParams.add(SafeEncoder.encode(String.valueOf((char[])this.getParam(PX))));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

