/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.util.SafeEncoder;

public class ZParams {
    private List<byte[]> params = new ArrayList<byte[]>();

    public ZParams weights(double ... weights) {
        this.params.add(Protocol.Keyword.WEIGHTS.raw);
        double[] dArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            double weight = dArray[n2];
            this.params.add(Protocol.toByteArray(weight));
            ++n2;
        }
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public ZParams aggregate(Aggregate aggregate) {
        this.params.add(Protocol.Keyword.AGGREGATE.raw);
        this.params.add(aggregate.raw);
        return this;
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

