/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Module;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.AdvancedJedisCommands;
import redis.clients.jedis.commands.BasicCommands;
import redis.clients.jedis.commands.ClusterCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ModuleCommands;
import redis.clients.jedis.commands.MultiKeyCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.commands.SentinelCommands;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.set.SetParams;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Slowlog;

public class Jedis
extends BinaryJedis
implements JedisCommands,
MultiKeyCommands,
AdvancedJedisCommands,
ScriptingCommands,
BasicCommands,
ClusterCommands,
SentinelCommands,
ModuleCommands {
    protected JedisPoolAbstract dataSource = null;

    public Jedis() {
    }

    public Jedis(String host) {
        super(host);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public Jedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(String host, int port, int timeout, boolean ssl) {
        super(host, port, timeout, ssl);
    }

    public Jedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout) {
        super(host, port, connectionTimeout, soTimeout);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        super(host, port, connectionTimeout, soTimeout, ssl);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, connectionTimeout, soTimeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    public Jedis(URI uri) {
        super(uri);
    }

    public Jedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int timeout) {
        super(uri, timeout);
    }

    public Jedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout) {
        super(uri, connectionTimeout, soTimeout);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    @Override
    public String set(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value, SetParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.sendCommand((ProtocolCommand)Protocol.Command.GET, key);
        return this.client.getBulkReply();
    }

    @Override
    public Long exists(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(key);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Long del(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(String key) {
        this.client.del(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<String> keys(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public String randomKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    @Override
    public String rename(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, int seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long move(String key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> mget(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, int seconds, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, long integer) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, long integer) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(String key, double value) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(String key, String field, double value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, long index) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, long index, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, long count, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long srem(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    @Override
    public Set<String> spop(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long smove(String srckey, String dstkey, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Set<String> sinter(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sunion(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> srandmember(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, double score, String member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long zrem(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, score, member, params);
        String newscore = this.client.getBulkReply();
        if (newscore == null) {
            return null;
        }
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start, end);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start, end);
        return this.getTupledSet();
    }

    @Override
    public Long zcard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    @Override
    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> blpop(int timeout, String ... keys) {
        return this.blpop(this.getArgsAddTimeout(timeout, keys));
    }

    private String[] getArgsAddTimeout(int timeout, String[] keys) {
        int keyCount = keys.length;
        String[] args = new String[keyCount + 1];
        int at = 0;
        while (at != keyCount) {
            args[at] = keys[at];
            ++at;
        }
        args[keyCount] = String.valueOf(timeout);
        return args;
    }

    @Override
    public List<String> blpop(String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> brpop(String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(String key, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> brpop(int timeout, String ... keys) {
        return this.brpop(this.getArgsAddTimeout(timeout, keys));
    }

    @Override
    public Long zcount(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    private Set<Tuple> getTupledSet() {
        this.checkIsInMultiOrPipeline();
        List<String> membersWithScores = this.client.getMultiBulkReply();
        if (membersWithScores == null) {
            return Collections.emptySet();
        }
        if (membersWithScores.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>(membersWithScores.size() / 2, 1.0f);
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(iterator.next())));
        }
        return set;
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return Collections.emptySet();
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpushx(String key, String ... string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(String key, String ... string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            String string = this.client.getBulkReply();
            return string;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean setbit(String key, long offset, String value) {
        this.client.setbit(key, offset, value);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean getbit(String key, long offset) {
        this.client.getbit(key, offset);
        if (this.client.getIntegerReply() == 1L) {
            return true;
        }
        return false;
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    @Override
    public Long bitpos(String key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    @Override
    public Long bitpos(String key, boolean value, BitPosParams params) {
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        this.client.setTimeoutInfinite();
        try {
            this.client.eval(script, keyCount, params);
            Object object = this.getEvalResult();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long publish(String channel, String message) {
        this.checkIsInMultiOrPipeline();
        this.connect();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.checkIsInMultiOrPipeline();
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected static String[] getParams(List<String> keys, List<String> args) {
        int keyCount = keys.size();
        int argCount = args.size();
        String[] params = new String[keyCount + args.size()];
        int i = 0;
        while (i < keyCount) {
            params[i] = keys.get(i);
            ++i;
        }
        i = 0;
        while (i < argCount) {
            params[keyCount + i] = args.get(i);
            ++i;
        }
        return params;
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        return this.eval(script, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalsha(String sha1) {
        return this.evalsha(sha1, 0, new String[0]);
    }

    private Object getEvalResult() {
        return this.evalResult(this.client.getOne());
    }

    private Object evalResult(Object result) {
        if (result instanceof byte[]) {
            return SafeEncoder.encode((byte[])result);
        }
        if (result instanceof List) {
            List list = (List)result;
            ArrayList<Object> listResult = new ArrayList<Object>(list.size());
            for (Object bin : list) {
                listResult.add(this.evalResult(bin));
            }
            return listResult;
        }
        return result;
    }

    @Override
    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.evalsha(sha1, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params) {
        this.checkIsInMultiOrPipeline();
        this.client.evalsha(sha1, keyCount, params);
        return this.getEvalResult();
    }

    @Override
    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        this.client.scriptExists(sha1);
        List<Long> result = this.client.getIntegerMultiBulkReply();
        ArrayList<Boolean> exists = new ArrayList<Boolean>();
        for (Long value : result) {
            exists.add(value == 1L);
        }
        return exists;
    }

    @Override
    public String scriptLoad(String script) {
        this.client.scriptLoad(script);
        return this.client.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.client.slowlogGet();
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long entries) {
        this.client.slowlogGet(entries);
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String string) {
        this.client.objectRefcount(string);
        return this.client.getIntegerReply();
    }

    @Override
    public String objectEncoding(String string) {
        this.client.objectEncoding(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long objectIdletime(String string) {
        this.client.objectIdletime(string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key) {
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key, long start, long end) {
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.client.sentinel("masters");
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> masters = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            masters.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return masters;
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.client.sentinel("get-master-addr-by-name", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        return BuilderFactory.STRING_LIST.build(reply);
    }

    @Override
    public Long sentinelReset(String pattern) {
        this.client.sentinel("reset", pattern);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.client.sentinel("slaves", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> slaves = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            slaves.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return slaves;
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.client.sentinel("failover", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        this.client.sentinel("monitor", masterName, ip, String.valueOf(port), String.valueOf(quorum));
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.client.sentinel("remove", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        int index = 0;
        int paramsLength = parameterMap.size() * 2 + 2;
        String[] params = new String[paramsLength];
        params[index++] = "set";
        params[index++] = masterName;
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.client.sentinel(params);
        return this.client.getStatusCodeReply();
    }

    public byte[] dump(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    public String clientKill(String client) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(client);
        return this.client.getStatusCodeReply();
    }

    public String clientSetname(String name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getStatusCodeReply();
    }

    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.scan(cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
        }
        return new ScanResult<Map.Entry<String, String>>(newcursor, results);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple(SafeEncoder.encode((byte[])iterator.next()), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterNodes();
        return this.client.getBulkReply();
    }

    @Override
    public String readonly() {
        this.client.readonly();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterMeet(String ip, int port) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterMeet(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReset(JedisCluster.Reset resetType) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReset(resetType);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterAddSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterDelSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterInfo();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterGetKeysInSlot(slot, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotStable(slot);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterForget(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFlushSlots();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clusterKeySlot(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterKeySlot(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterCountKeysInSlot(slot);
        return this.client.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSaveConfig();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReplicate(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReplicate(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterSlaves(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlaves(nodeId);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterFailover() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFailover();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> clusterSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlots();
        return this.client.getObjectMultiBulkReply();
    }

    public String asking() {
        this.checkIsInMultiOrPipeline();
        this.client.asking();
        return this.client.getStatusCodeReply();
    }

    public List<String> pubsubChannels(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubChannels(pattern);
        return this.client.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumPat();
        return this.client.getIntegerReply();
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumSub(channels);
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            if (this.client.isBroken()) {
                this.dataSource.returnBrokenResource(this);
            } else {
                this.dataSource.returnResource(this);
            }
        } else {
            this.client.close();
        }
    }

    public void setDataSource(JedisPoolAbstract jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public Long pfadd(String key, String ... elements) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        return this.blpop(key, String.valueOf(timeout));
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        return this.brpop(key, String.valueOf(timeout));
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public List<String> geohash(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String moduleLoad(String path) {
        this.client.moduleLoad(path);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String moduleUnload(String name) {
        this.client.moduleUnload(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Module> moduleList() {
        this.client.moduleList();
        return BuilderFactory.MODULE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public Long hstrlen(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hstrlen(key, field);
        return this.client.getIntegerReply();
    }
}

