/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Serializable;
import java.net.InetAddress;

public class HostAndPort
implements Serializable {
    private static final long serialVersionUID = -519876229978427751L;
    public static String localhost;
    private String host;
    private int port;

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HostAndPort) {
            HostAndPort hp = (HostAndPort)obj;
            String thisHost = HostAndPort.convertHost(this.host);
            String hpHost = HostAndPort.convertHost(hp.host);
            return this.port == hp.port && thisHost.equals(hpHost);
        }
        return false;
    }

    public int hashCode() {
        return 31 * HostAndPort.convertHost(this.host).hashCode() + this.port;
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public static String[] extractParts(String from) {
        int idx = from.lastIndexOf(":");
        String host = idx != -1 ? from.substring(0, idx) : from;
        String port = idx != -1 ? from.substring(idx + 1) : "";
        return new String[]{host, port};
    }

    public static HostAndPort parseString(String from) {
        try {
            String[] parts = HostAndPort.extractParts(from);
            String host = parts[0];
            int port = Integer.valueOf(parts[1]);
            return new HostAndPort(HostAndPort.convertHost(host), port);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String convertHost(String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            if (inetAddress.isLoopbackAddress() || host.equals("0.0.0.0") || host.startsWith("169.254")) {
                return HostAndPort.getLocalhost();
            }
            return host;
        }
        catch (Exception e) {
            System.out.println(String.valueOf(host) + " is not a valid IP address. ");
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocalhost(String localhost) {
        Class<HostAndPort> clazz = HostAndPort.class;
        synchronized (HostAndPort.class) {
            HostAndPort.localhost = localhost;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalhost() {
        if (localhost != null) return localhost;
        Class<HostAndPort> clazz = HostAndPort.class;
        synchronized (HostAndPort.class) {
            if (localhost != null) return localhost;
            localhost = HostAndPort.getLocalHostQuietly();
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhost;
        }
    }

    public static String getLocalHostQuietly() {
        String localAddress;
        try {
            localAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            System.out.println("{}.getLocalHostQuietly : cant resolve localhost address");
            localAddress = "localhost";
        }
        return localAddress;
    }
}

