/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skLib.skript;

import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import me.wheezygold.skLib.common.JsonReader;
import org.bukkit.entity.Player;
import org.json.JSONException;
import org.json.JSONObject;

public class ExprFormatDateOfPlayer
extends SimplePropertyExpression<Player, String> {
    static {
        PropertyExpression.register(ExprFormatDateOfPlayer.class, String.class, (String)"formatted date", (String)"players");
    }

    protected String getPropertyName() {
        return "formatted date";
    }

    public String convert(Player o) {
        InetAddress rawIp = o.getAddress().getAddress();
        String ip = rawIp.toString().replaceAll("/", "");
        JSONObject jsonParsed = null;
        try {
            jsonParsed = JsonReader.readJsonFromUrl("http://freegeoip.net/json/" + ip);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        String jsonValue = (String)jsonParsed.get("time_zone");
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        df.setTimeZone(TimeZone.getTimeZone(jsonValue));
        return df.format(date);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

