/*
 * Decompiled with CFR 0.152.
 */
package me.nrubin29.pastebinapi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import me.nrubin29.pastebinapi.Format;
import me.nrubin29.pastebinapi.PastebinAPI;
import me.nrubin29.pastebinapi.PastebinException;
import me.nrubin29.pastebinapi.Poster;
import me.nrubin29.pastebinapi.PrivacyLevel;

public class Paste {
    private PastebinAPI api;
    private String key;
    private String name;
    private int size;
    private int hits;
    private Date date;
    private Date expiredate;
    private PrivacyLevel level;
    private Format format;
    private URL url;

    protected Paste(PastebinAPI api, ArrayList<String> args) throws PastebinException {
        this.api = api;
        for (String arg : args) {
            if ((arg = arg.substring(arg.indexOf("_") + 1, arg.lastIndexOf("<"))).startsWith("key")) {
                this.key = this.sub(arg);
                continue;
            }
            if (arg.startsWith("date")) {
                this.date = new Date(Long.valueOf(this.sub(arg)));
                continue;
            }
            if (arg.startsWith("title")) {
                this.name = this.sub(arg);
                continue;
            }
            if (arg.startsWith("size")) {
                this.size = Integer.valueOf(this.sub(arg));
                continue;
            }
            if (arg.startsWith("expire_date")) {
                this.expiredate = new Date(Long.valueOf(this.sub(arg)));
                continue;
            }
            if (arg.startsWith("private")) {
                this.level = PrivacyLevel.valueOf(Integer.parseInt(this.sub(arg)));
                continue;
            }
            if (arg.startsWith("format_long")) {
                this.format = Format.valueOf(this.sub(arg));
                continue;
            }
            if (arg.startsWith("url")) {
                try {
                    this.url = new URL(this.sub(arg));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new PastebinException("Invalid URL returned!");
                }
            }
            if (!arg.startsWith("hits")) continue;
            this.hits = Integer.valueOf(this.sub(arg));
        }
    }

    private String sub(String str) {
        return str.substring(str.indexOf(">") + 1);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getHits() {
        return this.hits;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public Date getExpireDate() {
        return new Date(this.expiredate.getTime());
    }

    public PrivacyLevel getLevel() {
        return this.level;
    }

    public Format getFormat() {
        return this.format;
    }

    public URL getURL() {
        return this.url;
    }

    public String[] getText() throws PastebinException {
        Poster p = this.api.getNewPoster();
        try {
            return p.withURL(new URL("http://pastebin.com/raw.php?i=" + this.key)).post();
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }

    public String getText(String lineSeparator) throws PastebinException {
        StringBuffer result = new StringBuffer();
        String[] stringArray = this.getText();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            result.append(String.valueOf(str) + lineSeparator);
            ++n2;
        }
        return result.toString();
    }
}

