/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.set.SetParams;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.SafeEncoder;

public class BinaryClient
extends Connection {
    private boolean isInMulti;
    private String password;
    private int db;
    private boolean isInWatch;

    public BinaryClient() {
    }

    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    public BinaryClient(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public BinaryClient(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public boolean isInWatch() {
        return this.isInWatch;
    }

    private byte[][] joinParameters(byte[] first, byte[][] rest) {
        byte[][] result = new byte[rest.length + 1][];
        result[0] = first;
        System.arraycopy(rest, 0, result, 1, rest.length);
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(int db) {
        this.db = db;
    }

    @Override
    public void connect() {
        if (!this.isConnected()) {
            super.connect();
            if (this.password != null) {
                this.auth(this.password);
                this.getStatusCodeReply();
            }
            if (this.db > 0) {
                this.select(Long.valueOf(this.db).intValue());
                this.getStatusCodeReply();
            }
        }
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
    }

    public void set(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, key, value);
    }

    public void set(byte[] key, byte[] value, SetParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, params.getByteParams(key, value));
    }

    public void get(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GET, new byte[][]{key});
    }

    public void quit() {
        this.db = 0;
        this.sendCommand(Protocol.Command.QUIT);
    }

    public void exists(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXISTS, keys);
    }

    public void exists(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXISTS, new byte[][]{key});
    }

    public void del(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEL, keys);
    }

    public void type(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand(Protocol.Command.FLUSHDB);
    }

    public void keys(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand(Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAME, oldkey, newkey);
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand(Protocol.Command.DBSIZE);
    }

    public void expire(byte[] key, int seconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, key, Protocol.toByteArray(seconds));
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIREAT, key, Protocol.toByteArray(unixTime));
    }

    public void ttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TTL, new byte[][]{key});
    }

    public void select(int index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MOVE, key, Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.sendCommand(Protocol.Command.FLUSHALL);
    }

    public void getSet(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETSET, key, value);
    }

    public void mget(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETNX, key, value);
    }

    public void setex(byte[] key, int seconds, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETEX, key, Protocol.toByteArray(seconds), value);
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long integer) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECRBY, key, Protocol.toByteArray(integer));
    }

    public void decr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long integer) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBY, key, Protocol.toByteArray(integer));
    }

    public void incrByFloat(byte[] key, double value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBYFLOAT, key, Protocol.toByteArray(value));
    }

    public void incr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.APPEND, key, value);
    }

    public void substr(byte[] key, int start, int end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSTR, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSET, key, field, value);
    }

    public void hget(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGET, key, field);
    }

    public void hsetnx(byte[] key, byte[] field, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSETNX, key, field, value);
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.HMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        byte[][] params = new byte[fields.length + 1][];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.HMGET, params);
    }

    public void hincrBy(byte[] key, byte[] field, long value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBY, key, field, Protocol.toByteArray(value));
    }

    public void hexists(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HEXISTS, key, field);
    }

    public void hdel(byte[] key, byte[] ... fields) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HDEL, this.joinParameters(key, fields));
    }

    public void hlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void rpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSH, this.joinParameters(key, strings));
    }

    public void lpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSH, this.joinParameters(key, strings));
    }

    public void llen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void ltrim(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LTRIM, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void lindex(byte[] key, long index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINDEX, key, Protocol.toByteArray(index));
    }

    public void lset(byte[] key, long index, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LSET, key, Protocol.toByteArray(index), value);
    }

    public void lrem(byte[] key, long count, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LREM, key, Protocol.toByteArray(count), value);
    }

    public void lpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOP, new byte[][]{key});
    }

    public void rpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    public void sadd(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SADD, this.joinParameters(key, members));
    }

    public void smembers(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SREM, this.joinParameters(key, members));
    }

    public void spop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, new byte[][]{key});
    }

    public void spop(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, key, Protocol.toByteArray(count));
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    public void scard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SISMEMBER, key, member);
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTERSTORE, params);
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNIONSTORE, params);
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFFSTORE, params);
    }

    public void srandmember(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, key, Protocol.toByteArray(score), member);
    }

    public void zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, Protocol.toByteArray(score), member));
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2 + 1);
        args.add(key);
        args.addAll(this.convertScoreMembersToByteArrays(scoreMembers));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, argsArray);
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        ArrayList<byte[]> args = this.convertScoreMembersToByteArrays(scoreMembers);
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, argsArray));
    }

    public void zrange(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrem(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREM, this.joinParameters(key, members));
    }

    public void zincrby(byte[] key, double score, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINCRBY, key, Protocol.toByteArray(score), member);
    }

    public void zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, Protocol.toByteArray(score), member));
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANK, key, member);
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANK, key, member);
    }

    public void zrevrange(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrangeWithScores(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeWithScores(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zcard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCORE, key, member);
    }

    public void multi() {
        this.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void exec() {
        this.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WATCH, keys);
        this.isInWatch = true;
    }

    public void unwatch() {
        this.sendCommand(Protocol.Command.UNWATCH);
        this.isInWatch = false;
    }

    public void sort(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void blpop(byte[][] args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BLPOP, args);
    }

    public void blpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        byte[][] byArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arg = byArray[n2];
            args.add(arg);
            ++n2;
        }
        args.add(Protocol.toByteArray(timeout));
        this.blpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.raw);
        args.add(dstkey);
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, key, Protocol.Keyword.STORE.raw, dstkey);
    }

    public void brpop(byte[][] args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOP, args);
    }

    public void brpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        byte[][] byArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arg = byArray[n2];
            args.add(arg);
            ++n2;
        }
        args.add(Protocol.toByteArray(timeout));
        this.brpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void auth(String password) {
        this.setPassword(password);
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, password);
    }

    public void subscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(byte[] channel, byte[] message) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(byte[] ... patterns) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, patterns);
    }

    public void punsubscribe() {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(byte[] ... patterns) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public void pubsub(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, args);
    }

    public void zcount(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, key, min, max);
    }

    public void zcount(byte[] key, String min, String max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, key, min.getBytes(), max.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min, max);
    }

    public void zrangeByScore(byte[] key, String min, String max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes());
    }

    public void zrevrangeByScore(byte[] key, double max, double min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max, min);
    }

    public void zrevrangeByScore(byte[] key, String max, String min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScore(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zremrangeByRank(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYRANK, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, key, start, end);
    }

    public void zremrangeByScore(byte[] key, String start, String end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, key, start.getBytes(), end.getBytes());
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, params);
    }

    public void zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        byte[][] byArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] set = byArray[n2];
            args.add(set);
            ++n2;
        }
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, params);
    }

    public void zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        byte[][] byArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] set = byArray[n2];
            args.add(set);
            ++n2;
        }
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zlexcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZLEXCOUNT, key, min, max);
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, key, min, max);
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, key, max, min);
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYLEX, key, min, max);
    }

    public void save() {
        this.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.sendCommand(Protocol.Command.INFO);
    }

    public void info(String section) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INFO, section);
    }

    public void monitor() {
        this.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, Protocol.Keyword.NO.raw, Protocol.Keyword.ONE.raw);
    }

    public void configGet(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.raw, pattern);
    }

    public void configSet(byte[] parameter, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.raw, parameter, value);
    }

    public void strlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void sync() {
        this.sendCommand(Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] ... string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSHX, this.joinParameters(key, string));
    }

    public void persist(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] ... string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSHX, this.joinParameters(key, string));
    }

    public void echo(byte[] string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ECHO, new byte[][]{string});
    }

    public void linsert(byte[] key, LIST_POSITION where, byte[] pivot, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINSERT, key, where.raw, pivot, value);
    }

    public void debug(DebugParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEBUG, params.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOPLPUSH, source, destination, Protocol.toByteArray(timeout));
    }

    public void configResetStat() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT.name());
    }

    public void setbit(byte[] key, long offset, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), value);
    }

    public void setbit(byte[] key, long offset, boolean value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), Protocol.toByteArray(value));
    }

    public void getbit(byte[] key, long offset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETBIT, key, Protocol.toByteArray(offset));
    }

    public void bitpos(byte[] key, boolean value, BitPosParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(value));
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.BITPOS, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void setrange(byte[] key, long offset, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETRANGE, key, Protocol.toByteArray(offset), value);
    }

    public void getrange(byte[] key, long startOffset, long endOffset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETRANGE, key, Protocol.toByteArray(startOffset), Protocol.toByteArray(endOffset));
    }

    public int getDB() {
        return this.db;
    }

    @Override
    public void disconnect() {
        this.db = 0;
        super.disconnect();
    }

    @Override
    public void close() {
        this.db = 0;
        super.close();
    }

    public void resetState() {
        if (this.isInWatch()) {
            this.unwatch();
        }
    }

    private void sendEvalCommand(Protocol.Command command, byte[] script, byte[] keyCount, byte[][] params) {
        byte[][] allArgs = new byte[params.length + 2][];
        allArgs[0] = script;
        allArgs[1] = keyCount;
        int i = 0;
        while (i < params.length) {
            allArgs[i + 2] = params[i];
            ++i;
        }
        this.sendCommand((ProtocolCommand)command, allArgs);
    }

    public void eval(byte[] script, byte[] keyCount, byte[][] params) {
        this.sendEvalCommand(Protocol.Command.EVAL, script, keyCount, params);
    }

    public void eval(byte[] script, int keyCount, byte[] ... params) {
        this.eval(script, Protocol.toByteArray(keyCount), params);
    }

    public void evalsha(byte[] sha1, byte[] keyCount, byte[] ... params) {
        this.sendEvalCommand(Protocol.Command.EVALSHA, sha1, keyCount, params);
    }

    public void evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.sendEvalCommand(Protocol.Command.EVALSHA, sha1, Protocol.toByteArray(keyCount), params);
    }

    public void scriptFlush() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.raw});
    }

    public void scriptExists(byte[] ... sha1) {
        byte[][] args = new byte[sha1.length + 1][];
        args[0] = Protocol.Keyword.EXISTS.raw;
        int i = 0;
        while (i < sha1.length) {
            args[i + 1] = sha1[i];
            ++i;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, args);
    }

    public void scriptLoad(byte[] script) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.raw, script);
    }

    public void scriptKill() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.KILL.raw});
    }

    public void slowlogGet() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.raw});
    }

    public void slowlogGet(long entries) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.raw, Protocol.toByteArray(entries));
    }

    public void slowlogReset() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.RESET.raw});
    }

    public void slowlogLen() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.LEN.raw});
    }

    public void objectRefcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.raw, key);
    }

    public void objectIdletime(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.raw, key);
    }

    public void objectEncoding(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.raw, key);
    }

    public void bitcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, new byte[][]{key});
    }

    public void bitcount(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        Protocol.Keyword kw = Protocol.Keyword.AND;
        int len = srcKeys.length;
        switch (op) {
            case AND: {
                kw = Protocol.Keyword.AND;
                break;
            }
            case OR: {
                kw = Protocol.Keyword.OR;
                break;
            }
            case XOR: {
                kw = Protocol.Keyword.XOR;
                break;
            }
            case NOT: {
                kw = Protocol.Keyword.NOT;
                len = Math.min(1, len);
            }
        }
        byte[][] bargs = new byte[len + 2][];
        bargs[0] = kw.raw;
        bargs[1] = destKey;
        int i = 0;
        while (i < len) {
            bargs[i + 2] = srcKeys[i];
            ++i;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.BITOP, bargs);
    }

    public void sentinel(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, args);
    }

    public void dump(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DUMP, new byte[][]{key});
    }

    public void restore(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue);
    }

    public void pexpire(byte[] key, long milliseconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIRE, key, Protocol.toByteArray(milliseconds));
    }

    public void pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIREAT, key, Protocol.toByteArray(millisecondsTimestamp));
    }

    public void pttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PTTL, new byte[][]{key});
    }

    public void psetex(byte[] key, long milliseconds, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSETEX, key, Protocol.toByteArray(milliseconds), value);
    }

    public void srandmember(byte[] key, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, key, Protocol.toByteArray(count));
    }

    public void clientKill(byte[] client) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.raw, client);
    }

    public void clientGetname() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.GETNAME.raw});
    }

    public void clientList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void clientSetname(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.raw, name);
    }

    public void time() {
        this.sendCommand(Protocol.Command.TIME);
    }

    public void migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MIGRATE, host, Protocol.toByteArray(port), key, Protocol.toByteArray(destinationDb), Protocol.toByteArray(timeout));
    }

    public void hincrByFloat(byte[] key, byte[] field, double increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBYFLOAT, key, field, Protocol.toByteArray(increment));
    }

    public void scan(byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void hscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void waitReplicas(int replicas, long timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WAIT, Protocol.toByteArray(replicas), Protocol.toByteArray(timeout));
    }

    public void cluster(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, args);
    }

    public void asking() {
        this.sendCommand(Protocol.Command.ASKING);
    }

    public void pfadd(byte[] key, byte[] ... elements) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFADD, this.joinParameters(key, elements));
    }

    public void pfcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, new byte[][]{key});
    }

    public void pfcount(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, keys);
    }

    public void pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFMERGE, this.joinParameters(destkey, sourcekeys));
    }

    public void readonly() {
        this.sendCommand(Protocol.Command.READONLY);
    }

    public void geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), member);
    }

    public void geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3 + 1);
        args.add(key);
        args.addAll(this.convertGeoCoordinateMapToByteArrays(memberCoordinateMap));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, argsArray);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, key, member1, member2);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, key, member1, member2, unit.raw);
    }

    public void geohash(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOHASH, this.joinParameters(key, members));
    }

    public void geopos(byte[] key, byte[][] members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOPOS, this.joinParameters(key, members));
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw);
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, param.getByteParams(key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw));
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, key, member, Protocol.toByteArray(radius), unit.raw);
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, param.getByteParams(key, member, Protocol.toByteArray(radius), unit.raw));
    }

    public void moduleLoad(byte[] path) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LOAD.raw, path);
    }

    public void moduleList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void moduleUnload(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.UNLOAD.raw, name);
    }

    private ArrayList<byte[]> convertScoreMembersToByteArrays(Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2);
        for (Map.Entry<byte[], Double> entry : scoreMembers.entrySet()) {
            args.add(Protocol.toByteArray(entry.getValue()));
            args.add(entry.getKey());
        }
        return args;
    }

    private List<byte[]> convertGeoCoordinateMapToByteArrays(Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3);
        for (Map.Entry<byte[], GeoCoordinate> entry : memberCoordinateMap.entrySet()) {
            GeoCoordinate coordinate = entry.getValue();
            args.add(Protocol.toByteArray(coordinate.getLongitude()));
            args.add(Protocol.toByteArray(coordinate.getLatitude()));
            args.add(entry.getKey());
        }
        return args;
    }

    public void bitfield(byte[] key, byte[] ... value) {
        int argsLength = value.length;
        byte[][] bitfieldArgs = new byte[argsLength + 1][];
        bitfieldArgs[0] = key;
        System.arraycopy(value, 0, bitfieldArgs, 1, argsLength);
        this.sendCommand((ProtocolCommand)Protocol.Command.BITFIELD, bitfieldArgs);
    }

    public void hstrlen(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSTRLEN, key, field);
    }

    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

