/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;

public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String desc) {
        this(327680, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    AnnotationNode(List<Object> values) {
        super(327680);
        this.values = values;
    }

    @Override
    public void visit(String name, Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            ArrayList<Byte> l = new ArrayList<Byte>(v.length);
            byte[] byArray = v;
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                l.add(b);
                ++n2;
            }
            this.values.add(l);
        } else if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v.length);
            boolean[] blArray = v;
            int n = v.length;
            int n3 = 0;
            while (n3 < n) {
                boolean b = blArray[n3];
                l.add(b);
                ++n3;
            }
            this.values.add(l);
        } else if (value instanceof short[]) {
            short[] v = (short[])value;
            ArrayList<Short> l = new ArrayList<Short>(v.length);
            short[] sArray = v;
            int n = v.length;
            int n4 = 0;
            while (n4 < n) {
                short s = sArray[n4];
                l.add(s);
                ++n4;
            }
            this.values.add(l);
        } else if (value instanceof char[]) {
            char[] v = (char[])value;
            ArrayList<Character> l = new ArrayList<Character>(v.length);
            char[] cArray = v;
            int n = v.length;
            int n5 = 0;
            while (n5 < n) {
                char c = cArray[n5];
                l.add(Character.valueOf(c));
                ++n5;
            }
            this.values.add(l);
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            ArrayList<Integer> l = new ArrayList<Integer>(v.length);
            int[] nArray = v;
            int n = v.length;
            int n6 = 0;
            while (n6 < n) {
                int i = nArray[n6];
                l.add(i);
                ++n6;
            }
            this.values.add(l);
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            ArrayList<Long> l = new ArrayList<Long>(v.length);
            long[] lArray = v;
            int n = v.length;
            int n7 = 0;
            while (n7 < n) {
                long lng = lArray[n7];
                l.add(lng);
                ++n7;
            }
            this.values.add(l);
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            ArrayList<Float> l = new ArrayList<Float>(v.length);
            float[] fArray = v;
            int n = v.length;
            int n8 = 0;
            while (n8 < n) {
                float f = fArray[n8];
                l.add(Float.valueOf(f));
                ++n8;
            }
            this.values.add(l);
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            ArrayList<Double> l = new ArrayList<Double>(v.length);
            double[] dArray = v;
            int n = v.length;
            int n9 = 0;
            while (n9 < n) {
                double d = dArray[n9];
                l.add(d);
                ++n9;
            }
            this.values.add(l);
        } else {
            this.values.add(value);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        this.values.add(new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        AnnotationNode annotation = new AnnotationNode(desc);
        this.values.add(annotation);
        return annotation;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api) {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                int i = 0;
                while (i < this.values.size()) {
                    String name = (String)this.values.get(i);
                    Object value = this.values.get(i + 1);
                    AnnotationNode.accept(av, name, value);
                    i += 2;
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v = av.visitArray(name);
                if (v != null) {
                    List array = (List)value;
                    int j = 0;
                    while (j < array.size()) {
                        AnnotationNode.accept(v, null, array.get(j));
                        ++j;
                    }
                    v.visitEnd();
                }
            } else {
                av.visit(name, value);
            }
        }
    }
}

