/*
 * Decompiled with CFR 0.152.
 */
package me.wheezygold.skLib.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import me.wheezygold.skLib.common.JsonReader;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class ExprFormatDateOfPlayer
extends SimpleExpression<String> {
    private Expression<Player> player;

    static {
        Skript.registerExpression(ExprFormatDateOfPlayer.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] formatted date (of|for) [player] %player%"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.player = arg0[0];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "the formatted date for player %player%";
    }

    protected @Nullable String[] get(Event arg0) {
        InetAddress rawip = ((Player)this.player.getSingle(arg0)).getAddress().getAddress();
        String ip = rawip.toString().replaceAll("/", "");
        JSONObject jsonparsed = null;
        try {
            jsonparsed = JsonReader.readJsonFromUrl("http://freegeoip.net/json/" + ip);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        String jsonvalue = (String)jsonparsed.get("time_zone");
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        df.setTimeZone(TimeZone.getTimeZone(jsonvalue));
        return new String[]{df.format(date)};
    }
}

