/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects.spawns;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Spawn material particles")
@Description(value={"Specifically spawns material particles such as items or blocks(falling dust is a special case where it displays a color based on the block type used)"})
@Syntaxes(value={"draw %number% (blockcrack|blockdust|itemcrack|fallingdust)[ material]  particle[s] made of %itemstack% at %objects%[, speed %-number%][, offset %-number%, %-number%, %-number%][, id %-string%][, visibleTo %-players%][, visibleRange %-number%][, pulseDelay %-number%][, keepFor %-timespan%]"})
@Examples(value={"draw 1 itemcrack particle made of diamond sword at location of player", "draw 5 blockcrack particle made of redstone block at location of player"})
public class EffSpawnParticleMaterial
extends Effect {
    private Expression<Number> partCount;
    private Expression<ItemStack> inputParticleData;
    private Expression<Number> inputParticleSpeed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<?> entLoc;
    private Expression<String> inputIdName;
    private Expression<Player> inputPlayers;
    private Expression<Number> inputRange;
    private Expression<Number> inputPulseDelay;
    private Expression<Timespan> inputKeepDelay;
    private String parsedSyntax;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.partCount = exprs[0];
        this.inputParticleData = exprs[1];
        this.entLoc = exprs[2];
        this.inputParticleSpeed = exprs[3];
        this.offX = exprs[4];
        this.offY = exprs[5];
        this.offZ = exprs[6];
        this.inputIdName = exprs[7];
        this.inputPlayers = exprs[8];
        this.inputRange = exprs[9];
        this.inputPulseDelay = exprs[10];
        this.inputKeepDelay = exprs[11];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Material Based Particles";
    }

    protected void execute(@Nullable Event e) {
        int count = SkriptHandler.inputParticleCount(e, this.partCount);
        final Object[] center = this.entLoc.getAll(e);
        final List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        float finalSpeed = SkriptHandler.inputParticleSpeed(e, this.inputParticleSpeed);
        float offsetX = SkriptHandler.inputParticleOffset(e, this.offX);
        float offsetY = SkriptHandler.inputParticleOffset(e, this.offY);
        float offsetZ = SkriptHandler.inputParticleOffset(e, this.offZ);
        Material dataMat = SkriptHandler.inputParticleDataMat(e, this.inputParticleData);
        byte dataID = SkriptHandler.inputParticleDataID(e, this.inputParticleData);
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseDelay);
        long finalKeepDelay = SkriptHandler.inputKeepDelay(e, this.inputKeepDelay);
        double range = SkriptHandler.inputDouble(32.0, e, this.inputRange);
        final String idName = this.inputIdName != null ? (String)this.inputIdName.getSingle(e) : "&dot-" + Math.random() + "-&dot";
        if (this.inputKeepDelay != null && finalPulseTick > finalKeepDelay) {
            finalPulseTick = finalKeepDelay;
        }
        ParticleEffect inputParticle = ParticleEffect.blockcrack;
        if (this.parsedSyntax.contains("blockcrack")) {
            inputParticle = ParticleEffect.blockcrack;
        } else if (this.parsedSyntax.contains("blockdust")) {
            inputParticle = ParticleEffect.blockdust;
        } else if (this.parsedSyntax.contains("itemcrack")) {
            inputParticle = ParticleEffect.itemcrack;
        } else if (this.parsedSyntax.contains("fallingdust")) {
            inputParticle = ParticleEffect.fallingdust;
        }
        final DragonParticle particle = new DragonParticle(inputParticle, range, count, dataMat, dataID, offsetX, offsetY, offsetZ, finalSpeed);
        if (!EffectsLib.arraylist.containsKey(idName)) {
            int dotGo = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = center;
                    int n = center.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object loc = objectArray[n2];
                        Location location = EffSpawnParticleMaterial.getLocation(loc);
                        particle.displayMaterials(idName, players, location);
                        ++n2;
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            EffectsLib.arraylist.put(idName, dotGo);
            if (this.inputIdName == null) {
                EffectsLib.stopEffectDelayed(finalKeepDelay, idName);
            }
        }
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        return null;
    }
}

