/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects.spawns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.effects.DragonEffect;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Spawn material based directional particles")
@Description(value={"Unlike normal directional particles this syntax allows input for the 2 compatible material type particles", "These particles require a marterial input ie. 'diamond sword' or 'redstone block' depending on the type used"})
@Syntaxes(value={"draw %number% directional (blockdust|itemcrack) particle[s] made of %itemstack% at %objects% with direction %vector% and speed %number%[, offset %-number%, %-number%, %-number%][, id %-string%][, visibleTo %-players%][, visibleRange %-number%][, pulseDelay %-number%][, keepFor %-timespan%]"})
@Examples(value={"draw 2 directional blockdust particles made of redstone block at location of player with direction {_v2} and speed .6", "draw 2 directional itemcrack particles made of diamond sword at location of player with direction {_v2} and speed .6"})
public class EffSpawnParticleDirectionMat
extends DragonEffect {
    private Expression<Number> partCount;
    private Expression<ItemStack> inputParticleData;
    private Expression<?> entLoc;
    private Expression<Vector> inputDirection;
    private Expression<Number> inputSpeed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<String> inputIdName;
    private Expression<Player> inputPlayers;
    private Expression<Number> inputRange;
    private Expression<Number> inputPulseDelay;
    private Expression<Timespan> inputKeepDelay;
    private String parsedSyntax = "";

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.partCount = exprs[0];
        this.inputParticleData = exprs[1];
        this.entLoc = exprs[2];
        this.inputDirection = exprs[3];
        this.inputSpeed = exprs[4];
        this.offX = exprs[5];
        this.offY = exprs[6];
        this.offZ = exprs[7];
        this.inputIdName = exprs[8];
        this.inputPlayers = exprs[9];
        this.inputRange = exprs[10];
        this.inputPulseDelay = exprs[11];
        this.inputKeepDelay = exprs[12];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Material Based Directional Particles";
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        return null;
    }

    @Override
    protected void exec(@Nullable Event e) {
        final int count = SkriptHandler.inputParticleCount(e, this.partCount);
        ParticleEffect inputParticle = ParticleEffect.happyvillager;
        Material dataMat = Material.DIRT;
        byte dataID = 0;
        if (this.parsedSyntax.contains("blockdust")) {
            inputParticle = ParticleEffect.blockdust;
        } else if (this.parsedSyntax.contains("itemcrack")) {
            inputParticle = ParticleEffect.itemcrack;
        }
        dataMat = SkriptHandler.inputParticleDataMat(e, this.inputParticleData);
        dataID = SkriptHandler.inputParticleDataID(e, this.inputParticleData);
        final Object[] center = this.entLoc.getAll(e);
        final List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        final float offsetX = SkriptHandler.inputParticleOffset(e, this.offX);
        final float offsetY = SkriptHandler.inputParticleOffset(e, this.offY);
        final float offsetZ = SkriptHandler.inputParticleOffset(e, this.offZ);
        Vector direction = SkriptHandler.inputVector(e, this.inputDirection);
        float speed = SkriptHandler.inputFloat(0.0f, e, this.inputSpeed);
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseDelay);
        long finalKeepDelay = SkriptHandler.inputKeepDelay(e, this.inputKeepDelay);
        double range = SkriptHandler.inputDouble(32.0, e, this.inputRange);
        final String idName = this.inputIdName != null ? (String)this.inputIdName.getSingle(e) : "&dot-" + Math.random() + "-&dot";
        final DragonParticle particle = new DragonParticle();
        particle.setRange(range);
        particle.setDirection(direction);
        particle.setSpeed(speed);
        particle.setParticle(inputParticle);
        particle.setMaterial(dataMat);
        particle.setMaterialId(dataID);
        if (this.inputKeepDelay != null && finalPulseTick > finalKeepDelay) {
            finalPulseTick = finalKeepDelay;
        }
        if (!EffectsLib.arraylist.containsKey(idName)) {
            int dotGo = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float finalOffsetX;
                float finalOffsetY;
                float finalOffsetZ;
                {
                    this.finalOffsetX = f;
                    this.finalOffsetY = f2;
                    this.finalOffsetZ = f3;
                }

                @Override
                public void run() {
                    Object[] objectArray = center;
                    int n = center.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object loc = objectArray[n2];
                        Location location = EffSpawnParticleDirectionMat.getLocation(loc);
                        int i = 0;
                        while (i < count) {
                            if (offsetX > 0.0f) {
                                this.finalOffsetX = RandomUtils.randomRangeFloat(-offsetX, offsetX);
                            }
                            if (offsetY > 0.0f) {
                                this.finalOffsetY = RandomUtils.randomRangeFloat(-offsetY, offsetY);
                            }
                            if (offsetZ > 0.0f) {
                                this.finalOffsetZ = RandomUtils.randomRangeFloat(-offsetZ, offsetZ);
                            }
                            location.add((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            particle.displayDirectional(idName, players, location);
                            location.subtract((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            ++i;
                        }
                        ++n2;
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            EffectsLib.arraylist.put(idName, dotGo);
            if (this.inputIdName == null) {
                EffectsLib.stopEffectDelayed(finalKeepDelay, dotGo, idName);
            }
        }
    }
}

