/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.maths.ColorImage2;
import ud.skript.sashie.skDragon.particleEngine.utils.DynamicLocation;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.particleEngine.utils.enums.PlaneEnum;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="drawImage2")
@Description(value={"Draws a image effect that follows the player or plays at a location. Image files go in the skDragon plugin folder. New Syntax as of v0.06.0-BETA"})
@Syntaxes(value={"drawImage2 file %string%, center %object%, id %string%[, isSingle %-boolean%, %-player%][, randomRotation %-boolean%,[ plane] %-string%], pixelStepX %number%, pixelStepY %number%, scale %number%, visibleRange %number%[, xR[otation] %-number%, yR[otation] %-number%, zR[otation] %-number%][, dis[placement]X %-number%, dis[placement]Y %-number%, dis[placement]Z %-number%][, tps %-number%, second %-number%]"})
@Examples(value={"drawImage2 file \"\\dancing mario.gif\", center location of player, id \"%player%\", randomRotation true, \"x\", pixelStepX 1, pixelStepY 1, scale 10, visibleRange 300, tps 0, second 2", "drawImage2 file \"batman.png\", center location of player, id \"%player%\", randomRotation true, \"y\", pixelStepX 5, pixelStepY 5, scale 20, visibleRange 300, tps 0, second 2"})
public class EffColorImage2
extends Effect {
    private Expression<String> fileName;
    private Expression<Object> entLoc;
    private Expression<String> inputIdName;
    private Expression<Player> inputPlayers;
    private Expression<Boolean> inputAutoFace;
    private Expression<PlaneEnum> inputPlane;
    private Expression<Number> xSpeed;
    private Expression<Number> ySpeed;
    private Expression<Number> zSpeed;
    private Expression<Number> pixelX;
    private Expression<Number> pixelY;
    private Expression<Number> scale;
    private Expression<Number> xRot;
    private Expression<Number> yRot;
    private Expression<Number> zRot;
    private Expression<Number> displaceX;
    private Expression<Number> displaceY;
    private Expression<Number> displaceZ;
    private Expression<Number> range;
    private Expression<Number> inputPulseTick;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileName = exprs[0];
        this.entLoc = exprs[1];
        this.inputIdName = exprs[2];
        this.inputPlayers = exprs[3];
        this.inputAutoFace = exprs[4];
        this.inputPlane = exprs[5];
        this.xSpeed = exprs[6];
        this.ySpeed = exprs[7];
        this.zSpeed = exprs[8];
        this.pixelX = exprs[9];
        this.pixelY = exprs[10];
        this.scale = exprs[11];
        this.range = exprs[12];
        this.xRot = exprs[13];
        this.yRot = exprs[14];
        this.zRot = exprs[15];
        this.displaceX = exprs[16];
        this.displaceY = exprs[17];
        this.displaceZ = exprs[18];
        this.inputPulseTick = exprs[19];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "drawImage file %string%, center %entity/location%, id %string%[, onlyFor, %-players%][, autoFace %-boolean%][, autoRotation %-plane%, xyzVelocity %-number%, %-number%, %-number%], pixelStepXY %number%, %number%, scale %number%, visibleRange %number%[, Rot[ation]XYZ %-number%, %-number%, %-number%][, dis[placement]XYZ %-number%, %-number%, %-number%][, pulseDelay %-number%]";
    }

    protected void execute(@Nullable Event e) {
        DynamicLocation center;
        String finalFileName = null;
        File file = null;
        if (this.fileName != null) {
            finalFileName = (String)this.fileName.getSingle(e);
            file = !finalFileName.startsWith(File.pathSeparator) ? new File(skDragonCore.skdragoncore.getDataFolder().getAbsolutePath(), finalFileName) : new File(finalFileName);
        }
        try {
            center = DynamicLocation.init(this.entLoc.getSingle(e));
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        String idName = (String)this.inputIdName.getSingle(e);
        List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        boolean autoFace = SkriptHandler.inputBoolean(false, e, this.inputAutoFace);
        Vector displacement = SkriptHandler.inputLocDisplacement(e, this.displaceX, this.displaceY, this.displaceZ);
        boolean enableRotation = false;
        PlaneEnum plane = null;
        Vector xyzSpeed = null;
        if (!autoFace && this.inputPlane != null && this.xSpeed != null && this.ySpeed != null && this.zSpeed != null) {
            plane = SkriptHandler.inputPlane(PlaneEnum.XYZ, e, this.inputPlane);
            xyzSpeed = SkriptHandler.inputThreeValues(e, this.xSpeed, this.ySpeed, this.zSpeed);
            System.out.println("rotate");
            enableRotation = true;
        }
        int pixelStepX = SkriptHandler.inputInt(10, e, this.pixelX);
        int pixelStepY = SkriptHandler.inputInt(10, e, this.pixelY);
        int scaleSize = SkriptHandler.inputInt(7, e, this.scale);
        Vector axis = SkriptHandler.inputEffectRotationOld(e, this.xRot, this.yRot, this.zRot);
        double visibleRange = ((Number)this.range.getSingle(e)).doubleValue();
        int finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseTick);
        ColorImage2.drawEffect(file, idName, center, players, autoFace, enableRotation, plane, xyzSpeed, pixelStepX, pixelStepY, scaleSize, visibleRange, axis, displacement, 0L, finalPulseTick);
    }
}

