/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.maths;

import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class SimpleShapes {
    public static ArrayList<Location> getStar(Location center, double radius, int points, int amount) {
        World world = center.getWorld();
        ArrayList<Location> locations = new ArrayList<Location>();
        double math1 = (double)(360 / points) * (Math.PI / 180);
        double math2 = (double)(360 / (points / 2)) * (Math.PI / 180);
        double rcos = Math.cos(math2);
        double rsin = Math.sin(math2);
        int i = 1;
        while (i < points + 1) {
            double x = center.getX() + Math.cos((double)i * math1) * radius;
            double z = center.getZ() + Math.sin((double)i * math1) * radius;
            double rx = x * rcos + z * rsin;
            double rz = x * -rsin + z * rcos;
            double lx = rx - x;
            double lz = rz - z;
            double length = Math.sqrt(lx * lx + lz * lz);
            lx /= length;
            lz /= length;
            double ratio = length / (double)amount;
            x = center.getX() - (lx *= ratio);
            z = center.getZ() - (lz *= ratio);
            int i2 = 0;
            while (i2 < amount) {
                locations.add(new Location(world, x += lx, center.getY(), z += lz));
                ++i2;
            }
            ++i;
        }
        return locations;
    }

    public static ArrayList<Location> getStar4(Location center, double radius, float points, int lineDensity) {
        World world = center.getWorld();
        ArrayList<Location> locations = new ArrayList<Location>();
        int pts = (int)(points + 1.0f);
        float hpts = points / 2.0f;
        double math1 = 360.0f / points;
        double math2 = 360.0f / hpts;
        int i = 1;
        while (i < pts) {
            Vector v = new Vector(Math.cos((double)i * (math1 * Math.PI / 180.0)) * radius, 0.0, Math.sin((double)i * (math1 * Math.PI / 180.0)) * radius);
            Vector star = v.clone();
            double rcos = Math.cos(math2 * Math.PI / 180.0);
            double rsin = Math.sin(math2 * Math.PI / 180.0);
            double rx = star.getX() * rcos + star.getZ() * rsin;
            double rz = star.getX() * -rsin + star.getZ() * rcos;
            star.setX(rx).setZ(rz);
            center.add(v);
            Vector link = star.clone().subtract(v.clone());
            float length = (float)link.length();
            link.normalize();
            float ratio = length / (float)lineDensity;
            Vector v2 = link.multiply(ratio);
            Location loc = center.clone().subtract(v2);
            int i2 = 0;
            while (i2 < lineDensity) {
                loc.add(v2);
                locations.add(new Location(world, loc.getX(), center.getY(), loc.getZ()));
                ++i2;
            }
            center.subtract(v);
            ++i;
        }
        return locations;
    }

    public static ArrayList<Location> getCircle(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    public static ArrayList<Location> getCircleReverse(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() - radius * Math.cos(angle);
            double z = center.getZ() - radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    public static ArrayList<Location> getLine(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    public static ArrayList<Location> circle(Location loc, Integer r, Integer h, Boolean hollow, Boolean sphere, int plus_y) {
        ArrayList<Location> circleblocks = new ArrayList<Location>();
        int cx = loc.getBlockX();
        int cy = loc.getBlockY();
        int cz = loc.getBlockZ();
        int x = cx - r;
        while (x <= cx + r) {
            int z = cz - r;
            while (z <= cz + r) {
                int y = sphere != false ? cy - r : cy;
                while (y < (sphere != false ? cy + r : cy + h)) {
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (sphere != false ? (cy - y) * (cy - y) : 0);
                    if (!(!(dist < (double)(r * r)) || hollow.booleanValue() && dist < (double)((r - 1) * (r - 1)))) {
                        Location l = new Location(loc.getWorld(), (double)x, (double)(y + plus_y), (double)z);
                        circleblocks.add(l);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return circleblocks;
    }
}

