/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.maths;

import ch.njol.skript.Skript;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.DynamicLocation;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.VectorUtils;
import ud.skript.sashie.skDragonCore;

public class Cape2
extends EffectsLib {
    boolean initialize = false;
    boolean initImage = false;
    BufferedImage image = null;
    float hue;
    Player p;
    double capeHeight;
    boolean isGliding = false;
    float floatDown = 0.523599f;
    int imgHeight;
    int imgWidth;
    HashMap<Vector, Vector> vectorMap = new HashMap();
    File file;
    float size;
    DynamicLocation center;
    String idName;

    public Cape2(File file, DynamicLocation center, String idName, int scale) {
        this.file = file;
        this.center = center;
        this.idName = idName;
        this.size = 1.0f / (float)scale;
        this.init();
        this.imageInit();
    }

    private void init() {
        if (!this.initialize) {
            if (this.image == null && this.file != null) {
                try {
                    this.image = ImageIO.read(this.file);
                }
                catch (Exception ex) {
                    Skript.warning((String)"[skDragon] Error: Invalid file type or make sure the image is in /plugins/skDragon/capes");
                    this.image = null;
                }
            }
            if (this.image == null) {
                EffectsLib.stopEffect(this.idName);
                Skript.warning((String)"[skDragon] Error: The image failed to load, try another? :c");
                return;
            }
            this.imgHeight = this.image.getHeight();
            this.imgWidth = this.image.getWidth();
            if (this.center.getEntity() instanceof Player) {
                this.p = (Player)this.center.getEntity();
            }
            this.initialize = true;
        }
    }

    private void imageInit() {
        int y = 0;
        while (y < this.imgHeight) {
            int x = 0;
            while (x < this.imgWidth) {
                int filter = this.image.getRGB(x, y);
                if (filter != 0 && filter >> 24 != 0 && filter != 0xFFFFFF) {
                    Color color = new Color(filter);
                    this.vectorMap.put(new Vector((double)(this.imgWidth / 2 - x) - 0.5, (double)(-y), 0.0).multiply(this.size), new Vector(color.getRed(), color.getGreen(), color.getBlue()));
                }
                ++x;
            }
            ++y;
        }
        this.image.flush();
    }

    public void drawEffect(final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean dynamicCape, final float backSet, final float gravity, final double visibleRange, long delayStart, long delayPulse) {
        if (!EffectsLib.arraylist.containsKey(this.idName)) {
            int cape = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){

                @Override
                public void run() {
                    try {
                        Cape2.this.center.update();
                        if (Cape2.this.p != null) {
                            if (skDragonCore.serverVersion >= 9) {
                                Cape2.this.isGliding = Cape2.this.p.isGliding();
                            }
                            if (rainbowMode) {
                                Cape2.this.hue = ParticleEffect.simpleRainbowHelper(Cape2.this.hue, "redstone");
                            }
                            Cape2.this.capeHeight = Cape2.this.p.isSneaking() ? 1.2 / (double)Cape2.this.imgHeight : (Cape2.this.isGliding ? 0.5 / (double)Cape2.this.imgHeight : 1.4 / (double)Cape2.this.imgHeight);
                            Cape2.this.center.add(0.0, (double)Cape2.this.imgHeight * Cape2.this.capeHeight, 0.0);
                            if (dynamicCape) {
                                Cape2.this.center.movementCheck();
                                Cape2.this.floatDown = Cape2.this.center.isFalling() ? 2.9f : (Cape2.this.center.isMoving() && !Cape2.this.center.isFalling() ? (!(Cape2.this.floatDown > 1.3f) ? 1.3f : (Cape2.this.floatDown -= 0.1f + gravity)) : (Cape2.this.floatDown > 0.523599f ? (Cape2.this.floatDown -= 0.1f + gravity) : 0.523599f));
                            }
                        }
                        for (Map.Entry<Vector, Vector> entry : Cape2.this.vectorMap.entrySet()) {
                            Vector v = entry.getKey().clone();
                            Vector color = entry.getValue();
                            double yaw = Math.toRadians(-1.0f * Cape2.this.center.getYaw() + 180.0f);
                            double pitch = -Cape2.this.floatDown;
                            double cosYaw = Math.cos(yaw);
                            double cosPitch = Math.cos(pitch);
                            double sinYaw = Math.sin(yaw);
                            double sinPitch = Math.sin(pitch);
                            double initialY = v.getY();
                            double initialZ = v.getZ();
                            double z = initialY * sinPitch - initialZ * cosPitch;
                            double y = initialY * cosPitch + initialZ * sinPitch;
                            initialZ = z;
                            double initialX = v.getX();
                            z = initialZ * cosYaw - initialX * sinYaw;
                            double x = initialZ * sinYaw + initialX * cosYaw;
                            v.setX(x).setY(y).setZ(z);
                            Vector v2 = VectorUtils.getBackVector(Cape2.this.center);
                            if (Cape2.this.isGliding) {
                                v2.setY(0).multiply(1.1 + (double)backSet);
                            } else {
                                v2.setY(0).multiply(-0.3 + (double)backSet);
                            }
                            double r = color.getX();
                            double g = color.getY();
                            double b = color.getZ();
                            ParticleEffect.redstone.display(Cape2.this.center.add(v).add(v2), visibleRange, isSinglePlayer, player, rainbowMode, Cape2.this.hue, (int)r, (int)g, (int)b);
                            Cape2.this.center.subtract(v2).subtract(v);
                        }
                    }
                    catch (NullPointerException ex) {
                        Cape2.foundNull(Cape2.this.center, Cape2.this.idName, ex);
                        Cape2.stopEffect(Cape2.this.idName);
                    }
                }
            }, delayStart, delayPulse).getTaskId();
            EffectsLib.arraylist.put(this.idName, cape);
        }
    }

    public boolean getRange(float low, float high, float x) {
        return x - low <= high - low;
    }
}

