/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects.spawns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import ud.skript.sashie.skDragon.particleEngine.effects.DragonEffect;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Spawn colored particles")
@Description(value={"Spawns specifically colored particles with options for them including offset like regular particles"})
@Syntaxes(value={"draw %number% colo[u]red (redstone|mobspell|mobspellambient) particle[s] at %objects% with RGB %number%, %number%, %number%[, offset %-number%, %-number%, %-number%][, id %-string%][, r[ainbow]M[ode] %-boolean%][, randomColor %-boolean%][, visibleTo %-players%][, visibleRange %-number%][, pulseDelay %-number%][, keepFor %-timespan%]"})
@Examples(value={"draw 1 colored redstone particle at player with RGB 50, 80, 120, keepFor 5 seconds"})
public class EffSpawnParticleColor
extends DragonEffect {
    private Expression<Number> partCount;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<Number> coffX;
    private Expression<Number> coffY;
    private Expression<Number> coffZ;
    private Expression<?> entLoc;
    private Expression<String> inputIdName;
    private Expression<Boolean> isRainbowTrue;
    private Expression<Boolean> inputRandomColor;
    private Expression<Player> inputPlayers;
    private Expression<Number> inputRange;
    private Expression<Number> inputPulseDelay;
    private Expression<Timespan> inputKeepDelay;
    private String parsedSyntax;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.partCount = exprs[0];
        this.entLoc = exprs[1];
        this.offX = exprs[2];
        this.offY = exprs[3];
        this.offZ = exprs[4];
        this.coffX = exprs[5];
        this.coffY = exprs[6];
        this.coffZ = exprs[7];
        this.inputIdName = exprs[8];
        this.isRainbowTrue = exprs[9];
        this.inputRandomColor = exprs[10];
        this.inputPlayers = exprs[11];
        this.inputRange = exprs[12];
        this.inputPulseDelay = exprs[13];
        this.inputKeepDelay = exprs[14];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Colored Particles";
    }

    @Override
    protected void exec(@Nullable Event e) {
        final int count = SkriptHandler.inputParticleCount(e, this.partCount);
        final Object[] center = this.entLoc.getAll(e);
        final List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        final boolean rainbowMode = SkriptHandler.inputRainbowMode(e, this.isRainbowTrue);
        final boolean randomColor = SkriptHandler.inputBoolean(false, e, this.inputRandomColor);
        float offsetX = SkriptHandler.inputParticleOffset(e, this.offX);
        final float offsetY = SkriptHandler.inputParticleOffset(e, this.offY);
        final float offsetZ = SkriptHandler.inputParticleOffset(e, this.offZ);
        final float coffsetX = SkriptHandler.inputFloat(0.0f, e, this.coffX);
        final float coffsetY = SkriptHandler.inputFloat(0.0f, e, this.coffY);
        final float coffsetZ = SkriptHandler.inputFloat(0.0f, e, this.coffZ);
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseDelay);
        long finalKeepDelay = SkriptHandler.inputKeepDelay(e, this.inputKeepDelay);
        double range = SkriptHandler.inputDouble(32.0, e, this.inputRange);
        final String idName = this.inputIdName != null ? (String)this.inputIdName.getSingle(e) : "&dot-" + Math.random() + "-&dot";
        ParticleEffect inputParticle = ParticleEffect.redstone;
        if (this.parsedSyntax.contains("redstone")) {
            inputParticle = ParticleEffect.redstone;
        } else if (this.parsedSyntax.contains("mobspell")) {
            inputParticle = ParticleEffect.mobspell;
        } else if (this.parsedSyntax.contains("mobspellambient")) {
            inputParticle = ParticleEffect.mobspellambient;
        }
        final DragonParticle particle = new DragonParticle(inputParticle, range, count, offsetX, offsetY, offsetZ, 0.0f);
        if (this.inputKeepDelay != null && finalPulseTick > finalKeepDelay) {
            finalPulseTick = finalKeepDelay;
        }
        if (!EffectsLib.arraylist.containsKey(idName)) {
            int dotGo = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float finalOffsetX;
                float finalOffsetY;
                float finalOffsetZ;
                float finalColorOffsetX;
                float finalColorOffsetY;
                float finalColorOffsetZ;
                {
                    this.finalOffsetX = dragonParticle.getOffsetX();
                    this.finalOffsetY = dragonParticle.getOffsetY();
                    this.finalOffsetZ = dragonParticle.getOffsetZ();
                    this.finalColorOffsetX = f;
                    this.finalColorOffsetY = f2;
                    this.finalColorOffsetZ = f3;
                }

                @Override
                public void run() {
                    Object[] objectArray = center;
                    int n = center.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object loc = objectArray[n2];
                        Location location = EffSpawnParticleColor.getLocation(loc);
                        if (randomColor) {
                            if (rainbowMode) {
                                this.finalOffsetY = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalOffsetZ = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                            } else {
                                this.finalOffsetX = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalOffsetY = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalOffsetZ = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                            }
                        }
                        if (rainbowMode) {
                            if (randomColor) {
                                this.finalOffsetX = ParticleEffect.simpleRainbowHelper(this.finalOffsetX, particle.getParticle());
                                if (offsetY == 0.0f) {
                                    this.finalOffsetY = 1.0f;
                                }
                                if (offsetZ == 0.0f) {
                                    this.finalOffsetZ = 1.0f;
                                }
                            } else {
                                this.finalOffsetX = ParticleEffect.simpleRainbowHelper(this.finalOffsetX, particle.getParticle());
                            }
                        }
                        particle.setOffsetXYZ(this.finalOffsetX, this.finalOffsetY, this.finalOffsetZ);
                        int i = 0;
                        while (i < count) {
                            if (coffsetX > 0.0f) {
                                this.finalColorOffsetX = RandomUtils.randomRangeFloat(-coffsetX, coffsetX);
                            }
                            if (coffsetY > 0.0f) {
                                this.finalColorOffsetY = RandomUtils.randomRangeFloat(-coffsetY, coffsetY);
                            }
                            if (coffsetZ > 0.0f) {
                                this.finalColorOffsetZ = RandomUtils.randomRangeFloat(-coffsetZ, coffsetZ);
                            }
                            location.add((double)this.finalColorOffsetX, (double)this.finalColorOffsetY, (double)this.finalColorOffsetZ);
                            particle.displayColor(idName, players, location, rainbowMode);
                            location.subtract((double)this.finalColorOffsetX, (double)this.finalColorOffsetY, (double)this.finalColorOffsetZ);
                            ++i;
                        }
                        ++n2;
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            EffectsLib.arraylist.put(idName, dotGo);
            if (this.inputIdName == null) {
                EffectsLib.stopEffectDelayed(finalKeepDelay, idName);
            }
        }
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        return null;
    }
}

