/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;

@Name(value="drawCylinder ")
@Description(value={"Draws a cylinder that follows the player or plays at a location. New as of v0.07.0-Beta"})
@Syntaxes(value={"drawCylinder particle %string%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %object%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], randomRotation %boolean%, isSolid %boolean%, radius %number%, density %number%, height %number%, sideRatio %number%, visibleRange %number%[, xR[otation] %-number%, yR[otation] %-number%, zR[otation] %-number%][, dis[placement]X %-number%, dis[placement]Y %-number%, dis[placement]Z %-number%][, tps %-number%, second %-number%]"})
@Examples(value={"drawCylinder particle \"redstone\", RGB 102, 204, 255, center location of player, id \"%player%\", randomRotation false, isSolid false, radius 3, density 200, height 6, sideRatio 0, visibleRange 30", "drawCylinder particle \"flame\", center location of player, id \"%player%\", randomRotation false, isSolid true, radius 1, density 100, height 3, sideRatio 0, visibleRange 30"})
public class EffCylinder
extends Effect {
    private Expression<String> particleString;
    private Expression<ItemStack> data;
    private Expression<Number> speed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<?> entLoc;
    private Expression<String> idName;
    private Expression<Boolean> singlePlayer;
    private Expression<?> player;
    private Expression<Boolean> rainbMode;
    private Expression<Boolean> rotation;
    private Expression<Boolean> solid;
    private Expression<Number> radius;
    private Expression<Number> pDensity;
    private Expression<Number> height;
    private Expression<Number> sideRatio;
    private Expression<Number> range;
    private Expression<Number> xRot;
    private Expression<Number> yRot;
    private Expression<Number> zRot;
    private Expression<Number> displaceX;
    private Expression<Number> displaceY;
    private Expression<Number> displaceZ;
    private Expression<Long> ticks;
    private Expression<Long> seconds;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.particleString = exprs[0];
        this.data = exprs[1];
        this.speed = exprs[2];
        this.offX = exprs[3];
        this.offY = exprs[4];
        this.offZ = exprs[5];
        this.entLoc = exprs[6];
        this.idName = exprs[7];
        this.singlePlayer = exprs[8];
        this.player = exprs[9];
        this.rainbMode = exprs[10];
        this.rotation = exprs[11];
        this.solid = exprs[12];
        this.radius = exprs[13];
        this.pDensity = exprs[14];
        this.height = exprs[15];
        this.sideRatio = exprs[16];
        this.range = exprs[17];
        this.xRot = exprs[18];
        this.yRot = exprs[19];
        this.zRot = exprs[20];
        this.displaceX = exprs[21];
        this.displaceY = exprs[22];
        this.displaceZ = exprs[23];
        this.ticks = exprs[24];
        this.seconds = exprs[25];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "drawCylinder particle %string%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %entity/location%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], randomRotation %boolean%, isSolid %boolean%, radius %number%, density %number%, height %number%, sideRatio %number%, visibleRange %number%[, xR[otation] %-number%, yR[otation] %-number%, zR[otation] %-number%][, dis[placement]X %-number%, dis[placement]Y %-number%, dis[placement]Z %-number%][, tps %-number%, second %-number%]";
    }

    protected void execute(@Nullable Event e) {
        String particle = "happyvillager";
        float finalSpeed = 0.0f;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        double xRotation = 0.0;
        double yRotation = 0.0;
        double zRotation = 0.0;
        double disX = 0.0;
        double disY = 0.0;
        double disZ = 0.0;
        Long finalDelayTicks = 0L;
        Long finalDelayBySec = 0L;
        if (this.particleString != null && ParticleEffect.NAME_MAP.containsKey(((String)this.particleString.getSingle(e)).toLowerCase())) {
            particle = ((String)this.particleString.getSingle(e)).toLowerCase();
        }
        Object center = this.entLoc.getSingle(e);
        String idName = (String)this.idName.getSingle(e);
        double visibleRange = ((Number)this.range.getSingle(e)).doubleValue();
        Player p = null;
        boolean isSinglePlayer = false;
        if (this.singlePlayer != null && this.singlePlayer.getSingle(e) != null && this.player != null && this.player.getSingle(e) != null) {
            isSinglePlayer = (Boolean)this.singlePlayer.getSingle(e);
            p = (Player)this.player.getSingle(e);
        }
        boolean rainbowMode = false;
        if (this.rainbMode != null && this.rainbMode.getSingle(e) != null) {
            rainbowMode = (Boolean)this.rainbMode.getSingle(e);
        }
        boolean enableRotation = (Boolean)this.rotation.getSingle(e);
        boolean isSolid = (Boolean)this.solid.getSingle(e);
        float finalRadius = ((Number)this.radius.getSingle(e)).floatValue();
        int finalParticleCount = ((Number)this.pDensity.getSingle(e)).intValue();
        float finalHeight = ((Number)this.height.getSingle(e)).floatValue();
        float finalSideRatio = ((Number)this.sideRatio.getSingle(e)).floatValue();
        if (this.speed != null) {
            finalSpeed = ((Number)this.speed.getSingle(e)).floatValue();
        }
        if (this.offX != null && this.offY != null && this.offZ != null) {
            offsetX = ((Number)this.offX.getSingle(e)).intValue();
            offsetY = ((Number)this.offY.getSingle(e)).intValue();
            offsetZ = ((Number)this.offZ.getSingle(e)).intValue();
        }
        if (this.displaceX != null && this.displaceY != null && this.displaceZ != null) {
            disX = ((Number)this.displaceX.getSingle(e)).doubleValue();
            disY = ((Number)this.displaceY.getSingle(e)).doubleValue();
            disZ = ((Number)this.displaceZ.getSingle(e)).doubleValue();
        }
        if (this.xRot != null && this.yRot != null && this.zRot != null) {
            xRotation = ((Number)this.xRot.getSingle(e)).doubleValue();
            yRotation = ((Number)this.yRot.getSingle(e)).doubleValue();
            zRotation = ((Number)this.zRot.getSingle(e)).doubleValue();
        }
        if (this.ticks != null) {
            finalDelayTicks = (Long)this.ticks.getSingle(e);
        }
        if (this.seconds != null) {
            finalDelayBySec = (Long)this.seconds.getSingle(e);
        }
        try {
            Material dataMat = ((ItemStack)this.data.getSingle(e)).getType();
            byte dataID = ((ItemStack)this.data.getSingle(e)).getData().getData();
            EffectsLib.drawCylinder(particle, dataMat, dataID, finalSpeed, offsetX, offsetY, offsetZ, center, idName, isSinglePlayer, p, rainbowMode, enableRotation, isSolid, finalRadius, finalParticleCount, finalHeight, finalSideRatio, visibleRange, xRotation, yRotation, zRotation, disX, disY, disZ, finalDelayTicks, finalDelayBySec);
        }
        catch (Exception ex) {
            Material dataMatNull = Material.DIRT;
            byte dataIDNull = 0;
            EffectsLib.drawCylinder(particle, dataMatNull, dataIDNull, finalSpeed, offsetX, offsetY, offsetZ, center, idName, isSinglePlayer, p, rainbowMode, enableRotation, isSolid, finalRadius, finalParticleCount, finalHeight, finalSideRatio, visibleRange, xRotation, yRotation, zRotation, disX, disY, disZ, finalDelayTicks, finalDelayBySec);
        }
    }
}

