/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import ud.skript.sashie.skDragon.particleEngine.maths.Cape;
import ud.skript.sashie.skDragon.particleEngine.utils.DynamicLocation;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="drawCape")
@Description(value={"Draws a cape on a players back using approx. 8x12 pixel images"})
@Syntaxes(value={"drawCape file %string%, center %object%, id %string%[, isClientside %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%][, dyn[amic]Mode %-boolean%][, scale %-number%][, backDis[tance] %-number%][, gravity %-number%], visibleRange %number%[, pulseDelay %-number%]"})
@Examples(value={"drawCape file \"superman.png\", center player, id \"%player%\", rainbowMode false, dynamicMode true, visibleRange 32, pulseDelay 1"})
public class EffCape
extends Effect {
    private Expression<String> fileName;
    private Expression<?> entLoc;
    private Expression<String> idName;
    private Expression<Boolean> singlePlayer;
    private Expression<Player> player;
    private Expression<Boolean> rainbMode;
    private Expression<Boolean> dynMode;
    private Expression<Number> inputScale;
    private Expression<Number> inputBack;
    private Expression<Number> inputGrav;
    private Expression<Number> range;
    private Expression<Number> ticks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileName = exprs[0];
        this.entLoc = exprs[1];
        this.idName = exprs[2];
        this.singlePlayer = exprs[3];
        this.player = exprs[4];
        this.rainbMode = exprs[5];
        this.dynMode = exprs[6];
        this.inputScale = exprs[7];
        this.inputBack = exprs[8];
        this.inputGrav = exprs[9];
        this.range = exprs[10];
        this.ticks = exprs[11];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "drawCape file %string%, center %entity/location%, id %string%[, isClientside %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%][, dyn[amic]Mode %-boolean%][, scale %-number%][, backDis[tance] %-number%][, gravity %-number%], visibleRange %number%[, pulseDelay %-number%]";
    }

    protected void execute(@Nullable Event e) {
        DynamicLocation center;
        String finalFileName = null;
        File file = null;
        if (this.fileName != null) {
            finalFileName = (String)this.fileName.getSingle(e);
            file = !finalFileName.startsWith(File.pathSeparator) ? new File(skDragonCore.skdragoncore.getDataFolder() + File.separator + "capes", finalFileName) : new File(finalFileName);
        }
        String idName = (String)this.idName.getSingle(e);
        Player p = SkriptHandler.inputPlayer(e, this.player);
        boolean isSinglePlayer = SkriptHandler.inputBoolean(false, e, this.singlePlayer);
        boolean rainbowMode = SkriptHandler.inputBoolean(false, e, this.rainbMode);
        boolean dynamicCape = SkriptHandler.inputBoolean(false, e, this.dynMode);
        int scale = SkriptHandler.inputInt(8, e, this.inputScale);
        float back = SkriptHandler.inputFloat(0.0f, e, this.inputBack);
        float gravity = SkriptHandler.inputFloat(0.0f, e, this.inputGrav);
        double visibleRange = SkriptHandler.inputDouble(32.0, e, this.range);
        long finalDelayPulse = SkriptHandler.inputLong(0, e, this.ticks);
        try {
            center = DynamicLocation.init(this.entLoc.getSingle(e));
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Cape cape = new Cape(file, center, idName, scale);
        cape.drawEffect(isSinglePlayer, p, rainbowMode, dynamicCape, back, gravity, visibleRange, 1L, finalDelayPulse);
    }
}

