/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.emojis;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ud.skript.sashie.skDragon.emojis.CustomEmote;
import ud.skript.sashie.skDragon.emojis.SkullConfig;
import ud.skript.sashie.skDragon.emojis.SkullEffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Emotes - Custom")
@Description(value={"Using the names in the CustomEmotes.yml file you can play any custom emote or animation sequence you've made"})
@Syntaxes(value={"custom emote %string% on %entity%[with [frame] delay %-number%][ [and] repeat[ing] %-number% [time[s]]]"})
@Examples(value={"custom emote \"test\" on player", "custom emote \"test\" on target entity"})
public class EffEmoteCustom
extends Effect {
    private Expression<String> name;
    private Expression<Entity> entity;
    private Expression<Number> pulseTicks;
    private Expression<Number> repeat;
    private String parsedSyntax;
    private boolean isRepeating = false;
    private int iterations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.entity = exprs[1];
        this.pulseTicks = exprs[2];
        this.repeat = exprs[3];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "emote: " + this.name.toString(e, debug) + " entity: " + this.entity.toString(e, debug) + " ticks: " + (this.pulseTicks != null ? this.pulseTicks.toString(e, debug) : "0") + " repeats: " + (this.repeat != null ? this.repeat.toString(e, debug) : "0");
    }

    protected void execute(@Nullable Event e) {
        String emoteName = (String)this.name.getSingle(e);
        final LivingEntity ent = (LivingEntity)this.entity.getSingle(e);
        String skullName = "\ufffdb\ufffdlEMOTE-" + ent.getUniqueId().toString();
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.pulseTicks);
        if (this.parsedSyntax.contains("repeat")) {
            this.isRepeating = true;
        }
        this.iterations = SkriptHandler.inputInt(0, e, this.repeat);
        if (!SkullEffectsLib.emotelist.containsKey(ent.getUniqueId().toString())) {
            SkullEffectsLib.originalItem.put(ent.getUniqueId().toString(), SkullEffectsLib.getHelmet(ent));
            final CustomEmote emote = SkullConfig.customEmoteList.get(emoteName);
            final ArrayList<ItemStack> skulls = new ArrayList<ItemStack>();
            int i = 0;
            while (i < emote.size()) {
                skulls.add(SkullEffectsLib.createSkull(skullName, emote.getFrameData(i)));
                ++i;
            }
            int custom = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                int time = 0;
                int skullStep = 0;
                int timeCounter = 0;

                @Override
                public void run() {
                    if (this.time == this.timeCounter) {
                        this.timeCounter += emote.getFrameLength(this.skullStep);
                        SkullEffectsLib.setHelmet(ent, (ItemStack)skulls.get(this.skullStep));
                        ++this.skullStep;
                    }
                    ++this.time;
                    if (EffEmoteCustom.this.isRepeating) {
                        if (this.time >= emote.getTotalLength()) {
                            this.time = 0;
                            this.skullStep = 0;
                            this.timeCounter = 0;
                            EffEmoteCustom effEmoteCustom = EffEmoteCustom.this;
                            effEmoteCustom.iterations = effEmoteCustom.iterations - 1;
                        }
                        if (EffEmoteCustom.this.iterations < 1) {
                            SkullEffectsLib.removeSkull(ent);
                            Bukkit.getScheduler().cancelTask(SkullEffectsLib.emotelist.get(ent.getUniqueId().toString()).intValue());
                            SkullEffectsLib.emotelist.remove(ent.getUniqueId().toString());
                        }
                    } else if (this.time >= emote.getTotalLength()) {
                        SkullEffectsLib.removeSkull(ent);
                        Bukkit.getScheduler().cancelTask(SkullEffectsLib.emotelist.get(ent.getUniqueId().toString()).intValue());
                        SkullEffectsLib.emotelist.remove(ent.getUniqueId().toString());
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            SkullEffectsLib.emotelist.put(ent.getUniqueId().toString(), custom);
        }
    }
}

