/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.utils;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.ReflectionUtils;

public enum ParticleEffect {
    explosion("explosion", 0, 0, -1, ParticleProperty.DIRECTIONAL),
    explosionlarge("explosionlarge", 1, 1, -1, new ParticleProperty[0]),
    explosionhuge("explosionhuge", 2, 2, -1, new ParticleProperty[0]),
    fireworkspark("fireworkspark", 3, 3, -1, ParticleProperty.DIRECTIONAL),
    waterbubble("waterbubble", 4, 4, -1, ParticleProperty.DIRECTIONAL, ParticleProperty.USES_WATER),
    watersplash("watersplash", 5, 5, -1, ParticleProperty.DIRECTIONAL),
    waterwake("waterwake", 6, 6, 7, ParticleProperty.DIRECTIONAL),
    suspended("suspended", 7, 7, -1, ParticleProperty.USES_WATER),
    suspenddepth("suspenddepth", 8, 8, -1, ParticleProperty.DIRECTIONAL),
    crit("crit", 9, 9, -1, ParticleProperty.DIRECTIONAL),
    critmagic("critmagic", 10, 10, -1, ParticleProperty.DIRECTIONAL),
    smoke("smoke", 11, 11, -1, ParticleProperty.DIRECTIONAL),
    smokelarge("smokelarge", 12, 12, -1, ParticleProperty.DIRECTIONAL),
    spell("spell", 13, 13, -1, new ParticleProperty[0]),
    spellinstant("spellinstant", 14, 14, -1, new ParticleProperty[0]),
    mobspell("mobspell", 15, 15, -1, ParticleProperty.COLORABLE),
    mobspellambient("mobspellambient", 16, 16, -1, ParticleProperty.COLORABLE),
    witchspell("witchspell", 17, 17, -1, new ParticleProperty[0]),
    waterdrip("waterdrip", 18, 18, -1, new ParticleProperty[0]),
    lavadrip("lavadrip", 19, 19, -1, new ParticleProperty[0]),
    angryvillager("angryvillager", 20, 20, -1, new ParticleProperty[0]),
    happyvillager("happyvillager", 21, 21, -1, ParticleProperty.DIRECTIONAL),
    townaura("townaura", 22, 22, -1, ParticleProperty.DIRECTIONAL),
    note("note", 23, 23, -1, ParticleProperty.COLORABLE),
    portal("portal", 24, 24, -1, ParticleProperty.DIRECTIONAL),
    enchantmenttable("enchantmenttable", 25, 25, -1, ParticleProperty.DIRECTIONAL),
    flame("flame", 26, 26, -1, ParticleProperty.DIRECTIONAL),
    lava("lava", 27, 27, -1, new ParticleProperty[0]),
    footstep("footstep", 28, -1, new ParticleProperty[0]),
    cloud("cloud", 29, 28, -1, ParticleProperty.DIRECTIONAL),
    redstone("redstone", 30, 29, -1, ParticleProperty.COLORABLE),
    snowball("snowball", 31, 30, -1, new ParticleProperty[0]),
    snowshovel("snowshovel", 32, 31, -1, ParticleProperty.DIRECTIONAL),
    slime("slime", 33, 32, -1, new ParticleProperty[0]),
    heart("heart", 34, 33, -1, new ParticleProperty[0]),
    barrier("barrier", 35, 34, 8, new ParticleProperty[0]),
    itemcrack("itemcrack", 36, 35, -1, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_DATA),
    blockcrack("blockcrack", 37, 36, -1, ParticleProperty.REQUIRES_DATA),
    blockdust("blockdust", 38, 37, 7, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_DATA),
    waterdrop("waterdrop", 39, 38, 8, new ParticleProperty[0]),
    itemtake("itemtake", 40, 8, new ParticleProperty[0]),
    mobappearance("mobappearance", 41, 39, 8, new ParticleProperty[0]),
    dragonbreath("dragonbreath", 42, 40, 9, ParticleProperty.DIRECTIONAL),
    endrod("endrod", 43, 41, 9, ParticleProperty.DIRECTIONAL),
    damage("damage", 44, 42, 9, ParticleProperty.DIRECTIONAL),
    sweep("sweep", 45, 43, 9, new ParticleProperty[0]),
    fallingdust("fallingdust", 46, 44, 10, ParticleProperty.REQUIRES_DATA),
    totem("totem", 47, 45, 11, ParticleProperty.DIRECTIONAL),
    spit("spit", 48, 46, 11, ParticleProperty.DIRECTIONAL),
    squidink("squidink", 47, 13, ParticleProperty.DIRECTIONAL),
    bubblepop("bubblepop", 48, 13, ParticleProperty.DIRECTIONAL),
    bubblecurrentdown("bubblecurrentdown", 49, 13, ParticleProperty.DIRECTIONAL),
    bubblecurrentup("bubblecurrentup", 50, 13, ParticleProperty.DIRECTIONAL),
    nautilus("nautilus", 51, 13, ParticleProperty.DIRECTIONAL),
    dolphin("dolphin", 52, 13, ParticleProperty.DIRECTIONAL),
    legacyblockcrack("legacyblockcrack", 53, 13, ParticleProperty.REQUIRES_DATA),
    legacyblockdust("legacyblockdust", 54, 13, ParticleProperty.DIRECTIONAL, ParticleProperty.REQUIRES_DATA),
    legacyfallingdust("legacyfallingdust", 55, 13, ParticleProperty.REQUIRES_DATA);

    public static final Map<String, ParticleEffect> NAME_MAP;
    private final String name;
    private final int oldID;
    private final int newID;
    private final int requiredVersion;
    private final List<ParticleProperty> properties;

    static {
        NAME_MAP = new HashMap<String, ParticleEffect>();
        ParticleEffect[] particleEffectArray = ParticleEffect.values();
        int n = particleEffectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleEffect effect = particleEffectArray[n2];
            NAME_MAP.put(effect.name, effect);
            ++n2;
        }
    }

    private ParticleEffect(String name, int id, int requiredVersion, ParticleProperty ... properties) {
        this.name = name;
        this.oldID = id;
        this.newID = id;
        this.requiredVersion = requiredVersion;
        this.properties = Arrays.asList(properties);
    }

    private ParticleEffect(String name, int id, int newID, int requiredVersion, ParticleProperty ... properties) {
        this.name = name;
        this.oldID = id;
        this.newID = newID;
        this.requiredVersion = requiredVersion;
        this.properties = Arrays.asList(properties);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.oldID;
    }

    public int getNewID() {
        return this.newID;
    }

    public int getRequiredVersion() {
        return this.requiredVersion;
    }

    public boolean hasProperty(ParticleProperty property) {
        return this.properties.contains((Object)property);
    }

    public List<ParticleProperty> getProperties() {
        return this.properties;
    }

    public boolean isSupported() {
        if (this.requiredVersion == -1) {
            return true;
        }
        return ParticlePacket.getVersion() >= this.requiredVersion;
    }

    public static ParticleEffect fromName(String name) {
        for (Map.Entry<String, ParticleEffect> entry : NAME_MAP.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isLongDistance(Location location, List<Player> players) {
        String world = location.getWorld().getName();
        for (Player player : players) {
            Location playerLocation = player.getLocation();
            if (!world.equals(playerLocation.getWorld().getName()) || playerLocation.distanceSquared(location) < 65536.0) continue;
            return true;
        }
        return false;
    }

    private static boolean isLongDistance(Location location, Player player) {
        Location playerLocation;
        String world = location.getWorld().getName();
        return world.equals((playerLocation = player.getLocation()).getWorld().getName()) && !(playerLocation.distanceSquared(location) < 65536.0);
    }

    private static boolean isDataCorrect(ParticleEffect effect, ParticleData data) {
        return (effect == blockcrack || effect == blockdust || effect == fallingdust) && data instanceof BlockData || effect == itemcrack && data instanceof ItemData;
    }

    private static boolean isColorCorrect(ParticleEffect effect, ParticleColor color) {
        if (ParticlePacket.getVersion() < 13) {
            return (effect == mobspell || effect == mobspellambient || effect == redstone) && color instanceof OrdinaryColor || effect == note && color instanceof NoteColor;
        }
        return (effect == mobspell || effect == mobspellambient) && color instanceof OrdinaryColor || effect == redstone && color instanceof RedstoneColor || effect == note && color instanceof NoteColor;
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, null).sendTo(center, range);
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, ParticleEffect.isLongDistance(center, players), null).sendTo(center, players);
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, Player player) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, ParticleEffect.isLongDistance(center, player), null).sendTo(center, player);
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, Player ... players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        this.display(offsetX, offsetY, offsetZ, speed, amount, center, Arrays.asList(players));
    }

    public void display(Vector direction, float speed, Location center, double range) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (!this.hasProperty(ParticleProperty.DIRECTIONAL)) {
            throw new IllegalArgumentException("This particle effect is not directional");
        }
        new ParticlePacket(this, direction, speed, true, null).sendTo(center, range);
    }

    public void display(Vector direction, float speed, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect requires additional data");
        }
        if (!this.hasProperty(ParticleProperty.DIRECTIONAL)) {
            throw new IllegalArgumentException("This particle effect is not directional");
        }
        new ParticlePacket(this, direction, speed, ParticleEffect.isLongDistance(center, players), null).sendTo(center, players);
    }

    public void display(Vector direction, float speed, Location center, Player ... players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        this.display(direction, speed, center, Arrays.asList(players));
    }

    public void display(ParticleColor color, Location center, double range) throws ParticleVersionException, ParticleColorException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.COLORABLE)) {
            throw new ParticleColorException("This particle effect is not colorable");
        }
        if (!ParticleEffect.isColorCorrect(this, color)) {
            throw new ParticleColorException("The particle color type is incorrect");
        }
        new ParticlePacket(this, color, true).sendTo(center, range);
    }

    public void display(ParticleColor color, Location center, List<Player> players) throws ParticleVersionException, ParticleColorException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.COLORABLE)) {
            throw new ParticleColorException("This particle effect is not colorable");
        }
        if (!ParticleEffect.isColorCorrect(this, color)) {
            throw new ParticleColorException("The particle color type is incorrect");
        }
        new ParticlePacket(this, color, ParticleEffect.isLongDistance(center, players)).sendTo(center, players);
    }

    public void display(ParticleColor color, Location center, Player ... players) throws ParticleVersionException, ParticleColorException {
        this.display(color, center, Arrays.asList(players));
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, data).sendTo(center, range);
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, ParticleEffect.isLongDistance(center, players), data).sendTo(center, players);
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, Player ... players) throws ParticleVersionException, ParticleDataException {
        this.display(data, offsetX, offsetY, offsetZ, speed, amount, center, Arrays.asList(players));
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, double range) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, direction, speed, true, data).sendTo(center, range);
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("This particle effect is not supported by your server version");
        }
        if (!this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            throw new ParticleDataException("This particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect");
        }
        new ParticlePacket(this, direction, speed, ParticleEffect.isLongDistance(center, players), data).sendTo(center, players);
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, Player ... players) throws ParticleVersionException, ParticleDataException {
        this.display(data, direction, speed, center, Arrays.asList(players));
    }

    public void display(String idName, Material dataMat, byte dataID, Player player, Location center, double visibleRange, boolean isSinglePlayer, boolean rainbowMode, float hue, float offsetX, float offsetY, float offsetZ, float speed, int particleCount) {
        if (!this.isSupported()) {
            EffectsLib.stopEffect(idName);
            return;
        }
        if (this == redstone || this == mobspell || this == mobspellambient) {
            if (rainbowMode) {
                int argb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                float b = (float)(argb & 0xFF) / 255.0f;
                float f = r = r == 0.0f ? 0.001f : r;
                if (this == redstone) {
                    RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
                    if (isSinglePlayer) {
                        this.display((ParticleColor)color, center, player);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                } else if (isSinglePlayer) {
                    this.display(r, g, b, 1.0f, 0, center, player);
                } else {
                    this.display(r, g, b, 1.0f, 0, center, visibleRange);
                }
            } else {
                int r = Math.round(offsetX);
                int g = Math.round(offsetY);
                int b = Math.round(offsetZ);
                if (this == redstone) {
                    RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
                    if (isSinglePlayer) {
                        this.display((ParticleColor)color, center, player);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                } else if (isSinglePlayer) {
                    this.display((ParticleColor)new OrdinaryColor(r, g, b), center, player);
                } else {
                    this.display((ParticleColor)new OrdinaryColor(r, g, b), center, visibleRange);
                }
            }
        } else if (this == note) {
            if (rainbowMode) {
                NoteColor color = new NoteColor((int)hue);
                if (isSinglePlayer) {
                    this.display((ParticleColor)color, center, player);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else if (isSinglePlayer) {
                this.display((ParticleColor)new NoteColor((int)offsetX), center, player);
            } else {
                this.display((ParticleColor)new NoteColor((int)offsetX), center, visibleRange);
            }
        } else if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            if ((this == fallingdust || this == blockcrack || this == blockdust) && dataMat != null) {
                BlockData finalData = new BlockData(dataMat, dataID);
                if (isSinglePlayer) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, player);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            } else if (this == itemcrack && dataMat != null) {
                ItemData finalData = new ItemData(dataMat, dataID);
                if (isSinglePlayer) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, player);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            }
        } else if (isSinglePlayer) {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, player);
        } else {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
        }
    }

    public void display(String idName, Material dataMat, byte dataID, Player player, Location center, double visibleRange, boolean isSinglePlayer, boolean rainbowMode, float hue, double offsetX, double offsetY, double offsetZ, float speed, int particleCount) {
        this.display(idName, dataMat, dataID, player, center, visibleRange, isSinglePlayer, rainbowMode, hue, (float)offsetX, (float)offsetY, (float)offsetZ, speed, particleCount);
    }

    public static float simpleRainbowHelper(float hue, String particle) {
        if (particle.equals(note.getName())) {
            if (hue >= 24.0f) {
                hue = 0.0f;
            }
            hue += 1.0f;
        } else if (particle.equals(redstone.getName()) || particle.equals(mobspell.getName()) || particle.equals(mobspellambient.getName())) {
            if (hue >= 1.0f) {
                hue = 0.0f;
            }
            hue = (float)((double)hue + 0.01);
        }
        return hue;
    }

    public static float simpleRainbowHelper(float hue, ParticleEffect particle) {
        if (particle.equals((Object)note)) {
            if (hue >= 24.0f) {
                hue = 0.0f;
            }
            hue += 1.0f;
        } else if (particle.equals((Object)redstone) || particle.equals((Object)mobspell) || particle.equals((Object)mobspellambient)) {
            if (hue >= 1.0f) {
                hue = 0.0f;
            }
            hue = (float)((double)hue + 0.01);
        }
        return hue;
    }

    public void display(Player player, Location center, double visibleRange, boolean isSinglePlayer, float hue) {
        if (this == redstone || this == mobspell || this == mobspellambient) {
            int argb = Color.HSBtoRGB(hue / 20.0f, 1.0f, 1.0f);
            float r = (float)(argb >> 16 & 0xFF) / 255.0f;
            float g = (float)(argb >> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            float f = r = r == 0.0f ? 0.001f : r;
            if (this == redstone) {
                RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
                if (isSinglePlayer) {
                    this.display((ParticleColor)color, center, player);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else if (isSinglePlayer) {
                this.display(r, g, b, 1.0f, 0, center, player);
            } else {
                this.display(r, g, b, 1.0f, 0, center, visibleRange);
            }
        }
    }

    public void display(Location center, double visibleRange, boolean isSinglePlayer, Player player, boolean rainbowMode, float hue, int r, int g, int b) {
        if (rainbowMode) {
            int argb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            float r2 = (float)(argb >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(argb >> 8 & 0xFF) / 255.0f;
            float b2 = (float)(argb & 0xFF) / 255.0f;
            r2 = r2 == 0.0f ? 0.001f : r2;
            RedstoneColor color = new RedstoneColor(new Color(r2, g2, b2), 1.0f);
            if (isSinglePlayer) {
                this.display((ParticleColor)color, center, player);
            } else {
                this.display((ParticleColor)color, center, visibleRange);
            }
        } else {
            RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
            if (isSinglePlayer) {
                this.display((ParticleColor)color, center, player);
            } else {
                this.display((ParticleColor)color, center, visibleRange);
            }
        }
    }

    public void display(Location center, double visibleRange, boolean isSinglePlayer, Player player, int r, int g, int b) {
        if (this == redstone || this == mobspell || this == mobspellambient) {
            if (this == redstone) {
                RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
                if (isSinglePlayer) {
                    this.display((ParticleColor)color, center, player);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else if (isSinglePlayer) {
                this.display((float)r, (float)g, (float)b, 1.0f, 0, center, player);
            } else {
                this.display((float)r, (float)g, (float)b, 1.0f, 0, center, visibleRange);
            }
        }
    }

    public void display(Location center, double visibleRange, List<Player> players, int r, int g, int b) {
        if (this == redstone || this == mobspell || this == mobspellambient) {
            if (this == redstone) {
                RedstoneColor color = new RedstoneColor(new Color(r, g, b), 1.0f);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else if (players != null) {
                this.display((float)r, (float)g, (float)b, 1.0f, 0, center, players);
            } else {
                this.display((float)r, (float)g, (float)b, 1.0f, 0, center, visibleRange);
            }
        }
    }

    public void display(String idName, Material dataMat, byte dataID, List<Player> players, Location center, double visibleRange, boolean rainbowMode, float offsetX, float offsetY, float offsetZ, float speed, int particleCount) {
        if (!this.isSupported()) {
            EffectsLib.stopEffect(idName);
            return;
        }
        if (this == redstone || this == mobspell || this == mobspellambient) {
            if (rainbowMode) {
                if (this == redstone) {
                    RedstoneColor color = new RedstoneColor(new Color((int)offsetX, (int)offsetY, (int)offsetZ), 1.0f);
                    if (players != null) {
                        this.display((ParticleColor)color, center, players);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                } else {
                    OrdinaryColor color = new OrdinaryColor(Color.getHSBColor(offsetX, offsetY, offsetZ));
                    if (players != null) {
                        this.display((ParticleColor)color, center, players);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                }
            } else if (this == redstone) {
                RedstoneColor color = new RedstoneColor(new Color((int)offsetX, (int)offsetY, (int)offsetZ), 1.0f);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else {
                OrdinaryColor color = new OrdinaryColor((int)offsetX, (int)offsetY, (int)offsetZ);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            }
        } else if (this == note) {
            if (rainbowMode) {
                NoteColor color = new NoteColor((int)offsetX);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else {
                NoteColor color = new NoteColor((int)offsetX);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            }
        } else if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            if ((this == fallingdust || this == blockcrack || this == blockdust) && dataMat != null) {
                BlockData finalData = new BlockData(dataMat, dataID);
                if (players != null) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, players);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            } else if (this == itemcrack && dataMat != null) {
                ItemData finalData = new ItemData(dataMat, dataID);
                if (players != null) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, players);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            }
        } else if (players != null) {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, players);
        } else {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
        }
    }

    public void display(Material dataMat, byte dataID, List<Player> players, Location center, double visibleRange, boolean rainbowMode, float offsetX, float offsetY, float offsetZ, float speed, int particleCount) {
        if (this == redstone || this == mobspell || this == mobspellambient) {
            if (rainbowMode) {
                if (this == redstone) {
                    RedstoneColor color = new RedstoneColor(new Color((int)offsetX, (int)offsetY, (int)offsetZ), 1.0f);
                    if (players != null) {
                        this.display((ParticleColor)color, center, players);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                } else {
                    OrdinaryColor color = new OrdinaryColor(Color.getHSBColor(offsetX, offsetY, offsetZ));
                    if (players != null) {
                        this.display((ParticleColor)color, center, players);
                    } else {
                        this.display((ParticleColor)color, center, visibleRange);
                    }
                }
            } else if (this == redstone) {
                RedstoneColor color = new RedstoneColor(new Color((int)offsetX, (int)offsetY, (int)offsetZ), 1.0f);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else {
                OrdinaryColor color = new OrdinaryColor((int)offsetX, (int)offsetY, (int)offsetZ);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            }
        } else if (this == note) {
            if (rainbowMode) {
                NoteColor color = new NoteColor((int)offsetX);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            } else {
                NoteColor color = new NoteColor((int)offsetX);
                if (players != null) {
                    this.display((ParticleColor)color, center, players);
                } else {
                    this.display((ParticleColor)color, center, visibleRange);
                }
            }
        } else if (this.hasProperty(ParticleProperty.REQUIRES_DATA)) {
            if ((this == fallingdust || this == blockcrack || this == blockdust) && dataMat != null) {
                BlockData finalData = new BlockData(dataMat, dataID);
                if (players != null) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, players);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            } else if (this == itemcrack && dataMat != null) {
                ItemData finalData = new ItemData(dataMat, dataID);
                if (players != null) {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, players);
                } else {
                    this.display((ParticleData)finalData, offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
                }
            }
        } else if (players != null) {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, players);
        } else {
            this.display(offsetX, offsetY, offsetZ, speed, particleCount, center, visibleRange);
        }
    }

    public static double simpleRainbowHelper(double finalOffsetX, ParticleEffect particleEffect) {
        if (particleEffect.equals((Object)note)) {
            if (finalOffsetX >= 24.0) {
                finalOffsetX = 0.0;
            }
            finalOffsetX += 1.0;
        } else if (particleEffect.equals((Object)redstone) || particleEffect.equals((Object)mobspell) || particleEffect.equals((Object)mobspellambient)) {
            if (finalOffsetX >= 1.0) {
                finalOffsetX = 0.0;
            }
            finalOffsetX += 0.01;
        }
        return finalOffsetX;
    }

    public static final class BlockData
    extends ParticleData {
        public BlockData(Material material, byte data) throws IllegalArgumentException {
            super(material, data);
            if (!material.isBlock()) {
                throw new IllegalArgumentException("The material is not a block");
            }
        }

        public BlockData(Material material) throws IllegalArgumentException {
            super(material);
            if (!material.isBlock()) {
                throw new IllegalArgumentException("The material is not a block");
            }
        }
    }

    public static final class ItemData
    extends ParticleData {
        public ItemData(Material material, byte data) {
            super(material, data);
        }
    }

    public static final class NoteColor
    extends ParticleColor {
        private final int note;

        public NoteColor(int note) throws IllegalArgumentException {
            if (note < 0) {
                throw new IllegalArgumentException("The note value is lower than 0");
            }
            if (note > 24) {
                throw new IllegalArgumentException("The note value is higher than 24");
            }
            this.note = note;
        }

        @Override
        public float getR() {
            return (float)this.note / 24.0f;
        }

        @Override
        public float getG() {
            return 0.0f;
        }

        @Override
        public float getB() {
            return 0.0f;
        }
    }

    public static class OrdinaryColor
    extends ParticleColor {
        private final int red;
        private final int green;
        private final int blue;

        public OrdinaryColor(int red, int green, int blue) throws IllegalArgumentException {
            if (red < 0) {
                throw new IllegalArgumentException("The red value is lower than 0");
            }
            if (red > 255) {
                throw new IllegalArgumentException("The red value is higher than 255");
            }
            this.red = red;
            if (green < 0) {
                throw new IllegalArgumentException("The green value is lower than 0");
            }
            if (green > 255) {
                throw new IllegalArgumentException("The green value is higher than 255");
            }
            this.green = green;
            if (blue < 0) {
                throw new IllegalArgumentException("The blue value is lower than 0");
            }
            if (blue > 255) {
                throw new IllegalArgumentException("The blue value is higher than 255");
            }
            this.blue = blue;
        }

        public OrdinaryColor(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue());
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        @Override
        public float getR() {
            return (float)this.red / 255.0f;
        }

        @Override
        public float getG() {
            return (float)this.green / 255.0f;
        }

        @Override
        public float getB() {
            return (float)this.blue / 255.0f;
        }
    }

    public static abstract class ParticleColor {
        public abstract float getR();

        public abstract float getG();

        public abstract float getB();
    }

    private static final class ParticleColorException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleColorException(String message) {
            super(message);
        }
    }

    public static abstract class ParticleData {
        private final Material material;
        private byte data;
        private int[] packetData;

        public ParticleData(Material material, byte data) {
            this.material = material;
            this.data = data;
            this.packetData = new int[]{material.getId(), data};
        }

        public ParticleData(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public int[] getPacketData() {
            return this.packetData;
        }

        public String getPacketDataString() {
            return "_" + this.packetData[0] + "_" + this.packetData[1];
        }
    }

    private static final class ParticleDataException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleDataException(String message) {
            super(message);
        }
    }

    public static final class ParticlePacket {
        private static int version;
        private static Class<?> enumParticle;
        private static Constructor<?> packetConstructor;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static boolean initialized;
        private final ParticleEffect effect;
        private float offsetX;
        private final float offsetY;
        private final float offsetZ;
        private final float speed;
        private final int amount;
        private final boolean longDistance;
        private final ParticleData data;
        private RedstoneColor colorData;
        private Object packet;

        public ParticlePacket(ParticleEffect effect, float offsetX, float offsetY, float offsetZ, float speed, int amount, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            ParticlePacket.initialize();
            if (speed < 0.0f) {
                throw new IllegalArgumentException("The speed is lower than 0");
            }
            if (amount < 0) {
                throw new IllegalArgumentException("The amount is lower than 0");
            }
            this.effect = effect;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.speed = speed;
            this.amount = amount;
            this.longDistance = longDistance;
            this.data = data;
        }

        public ParticlePacket(ParticleEffect effect, Vector direction, float speed, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            this(effect, (float)direction.getX(), (float)direction.getY(), (float)direction.getZ(), speed, 0, longDistance, data);
        }

        public ParticlePacket(ParticleEffect effect, ParticleColor color, boolean longDistance) {
            this(effect, color.getR(), color.getG(), color.getB(), 1.0f, 0, longDistance, null);
            if (effect == redstone && color instanceof OrdinaryColor && ((OrdinaryColor)color).getRed() == 0) {
                this.offsetX = Float.MIN_NORMAL;
            }
            if (effect == redstone) {
                this.colorData = (RedstoneColor)color;
            }
        }

        public static void initialize() throws VersionIncompatibleException {
            if (initialized) {
                return;
            }
            try {
                version = Integer.parseInt(Character.toString(ReflectionUtils.PackageType.getServerVersion().charAt(3)));
                if (version == 1 && Integer.parseInt(Character.toString(ReflectionUtils.PackageType.getServerVersion().charAt(4))) >= 0) {
                    version = Integer.parseInt(String.valueOf(Integer.parseInt(Character.toString(ReflectionUtils.PackageType.getServerVersion().charAt(3)))) + Integer.parseInt(Character.toString(ReflectionUtils.PackageType.getServerVersion().charAt(4))));
                }
                if (version > 7 && version < 13) {
                    enumParticle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("EnumParticle");
                } else if (version >= 13) {
                    enumParticle = ReflectionUtils.PackageType.CRAFTBUKKIT.getClass("CraftParticle");
                }
                Class<?> packetClass = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass(version < 7 ? "Packet63WorldParticles" : "PacketPlayOutWorldParticles");
                packetConstructor = ReflectionUtils.getConstructor(packetClass, new Class[0]);
                getHandle = ReflectionUtils.getMethod("CraftPlayer", ReflectionUtils.PackageType.CRAFTBUKKIT_ENTITY, "getHandle", new Class[0]);
                playerConnection = ReflectionUtils.getField("EntityPlayer", ReflectionUtils.PackageType.MINECRAFT_SERVER, false, "playerConnection");
                sendPacket = ReflectionUtils.getMethod(playerConnection.getType(), "sendPacket", ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Packet"));
            }
            catch (Exception exception) {
                throw new VersionIncompatibleException("Your current bukkit version seems to be incompatible with this library", exception);
            }
            initialized = true;
        }

        public static int getVersion() {
            if (!initialized) {
                ParticlePacket.initialize();
            }
            return version;
        }

        public static boolean isInitialized() {
            return initialized;
        }

        private void initializePacket(Location center) throws PacketInstantiationException {
            if (this.packet != null) {
                return;
            }
            try {
                this.packet = packetConstructor.newInstance(new Object[0]);
                if (version < 8) {
                    String name = this.effect.getName();
                    if (this.data != null) {
                        name = String.valueOf(name) + this.data.getPacketDataString();
                    }
                    ReflectionUtils.setValue(this.packet, true, "a", name);
                } else if (version >= 13) {
                    Particle particle = Particle.values()[this.effect.newID];
                    Class<?> particleParam = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParam");
                    Method toNMS = null;
                    Object param = null;
                    if (this.effect == redstone) {
                        Class<?> redstone = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone");
                        Constructor<?> thing = ReflectionUtils.getConstructor(redstone, Float.class, Float.class, Float.class, Float.class);
                        param = thing.newInstance(Float.valueOf(this.colorData.getR()), Float.valueOf(this.colorData.getG()), Float.valueOf(this.colorData.getB()), Float.valueOf(this.colorData.getSize()));
                    } else if (this.effect == fallingdust || this.effect == blockcrack || this.effect == blockdust) {
                        Class<?> blockDataClass = ReflectionUtils.PackageType.BUKKIT_BLOCK_DATA.getClass("BlockData");
                        Method getBlockData = ReflectionUtils.getMethod(Bukkit.class, "createBlockData", Material.class);
                        Object blockData = getBlockData.invoke(blockDataClass, this.data.getMaterial());
                        toNMS = ReflectionUtils.getMethod("CraftParticle", ReflectionUtils.PackageType.CRAFTBUKKIT, "toNMS", Particle.class, blockDataClass);
                        param = toNMS.invoke(particleParam, particle, blockData);
                    } else if (this.effect == legacyfallingdust || this.effect == legacyblockcrack || this.effect == legacyblockdust) {
                        Class<?> materialDataClass = ReflectionUtils.PackageType.BUKKIT_MATERIAL.getClass("MaterialData");
                        Constructor<?> materialDataConstructor = ReflectionUtils.getConstructor(materialDataClass, Material.class);
                        Object materialData = materialDataConstructor.newInstance(this.data.getMaterial());
                        toNMS = ReflectionUtils.getMethod("CraftParticle", ReflectionUtils.PackageType.CRAFTBUKKIT, "toNMS", Particle.class, materialDataClass);
                        param = toNMS.invoke(particleParam, particle, materialData);
                    } else if (this.effect == itemcrack) {
                        ItemStack item = new ItemStack(this.data.getMaterial());
                        item.setDurability((short)this.data.getData());
                        toNMS = ReflectionUtils.getMethod("CraftParticle", ReflectionUtils.PackageType.CRAFTBUKKIT, "toNMS", Particle.class, ItemStack.class);
                        param = toNMS.invoke(particleParam, particle, item);
                    } else {
                        toNMS = ReflectionUtils.getMethod("CraftParticle", ReflectionUtils.PackageType.CRAFTBUKKIT, "toNMS", Particle.class);
                        param = toNMS.invoke(particleParam, particle);
                    }
                    ReflectionUtils.setValue(this.packet, true, "j", param);
                    ReflectionUtils.setValue(this.packet, true, "i", this.longDistance);
                    ReflectionUtils.setValue(this.packet, true, "a", Float.valueOf((float)center.getX()));
                    ReflectionUtils.setValue(this.packet, true, "b", Float.valueOf((float)center.getY()));
                    ReflectionUtils.setValue(this.packet, true, "c", Float.valueOf((float)center.getZ()));
                    ReflectionUtils.setValue(this.packet, true, "d", Float.valueOf(this.offsetX));
                    ReflectionUtils.setValue(this.packet, true, "e", Float.valueOf(this.offsetY));
                    ReflectionUtils.setValue(this.packet, true, "f", Float.valueOf(this.offsetZ));
                    ReflectionUtils.setValue(this.packet, true, "g", Float.valueOf(this.speed));
                    ReflectionUtils.setValue(this.packet, true, "h", this.amount);
                } else {
                    ReflectionUtils.setValue(this.packet, true, "a", enumParticle.getEnumConstants()[this.effect.getId()]);
                    ReflectionUtils.setValue(this.packet, true, "j", this.longDistance);
                    if (this.data != null) {
                        int[] nArray;
                        int[] packetData = this.data.getPacketData();
                        if (this.effect == itemcrack) {
                            nArray = packetData;
                        } else {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = packetData[0] | packetData[1] << 12;
                        }
                        ReflectionUtils.setValue(this.packet, true, "k", nArray);
                    }
                    ReflectionUtils.setValue(this.packet, true, "b", Float.valueOf((float)center.getX()));
                    ReflectionUtils.setValue(this.packet, true, "c", Float.valueOf((float)center.getY()));
                    ReflectionUtils.setValue(this.packet, true, "d", Float.valueOf((float)center.getZ()));
                    ReflectionUtils.setValue(this.packet, true, "e", Float.valueOf(this.offsetX));
                    ReflectionUtils.setValue(this.packet, true, "f", Float.valueOf(this.offsetY));
                    ReflectionUtils.setValue(this.packet, true, "g", Float.valueOf(this.offsetZ));
                    ReflectionUtils.setValue(this.packet, true, "h", Float.valueOf(this.speed));
                    ReflectionUtils.setValue(this.packet, true, "i", this.amount);
                }
            }
            catch (Exception exception) {
                throw new PacketInstantiationException("Packet instantiation failed", exception);
            }
        }

        public void sendTo(Location center, Player player) throws PacketInstantiationException, PacketSendingException {
            this.initializePacket(center);
            try {
                sendPacket.invoke(playerConnection.get(getHandle.invoke((Object)player, new Object[0])), this.packet);
            }
            catch (Exception exception) {
                throw new PacketSendingException("Failed to send the packet to player '" + player.getName() + "'", exception);
            }
        }

        public void sendTo(Location center, List<Player> players) throws IllegalArgumentException {
            if (players.isEmpty()) {
                throw new IllegalArgumentException("The player list is empty");
            }
            for (Player player : players) {
                this.sendTo(center, player);
            }
        }

        public void sendTo(Location center, double range) throws IllegalArgumentException {
            if (range < 1.0) {
                throw new IllegalArgumentException("The range is lower than 1");
            }
            String worldName = center.getWorld().getName();
            double squared = range * range;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(center) > squared) continue;
                this.sendTo(center, player);
            }
        }

        private static final class PacketInstantiationException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketInstantiationException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class PacketSendingException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketSendingException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class VersionIncompatibleException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public VersionIncompatibleException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static enum ParticleProperty {
        USES_WATER,
        REQUIRES_DATA,
        DIRECTIONAL,
        COLORABLE;

    }

    private static final class ParticleVersionException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleVersionException(String message) {
            super(message);
        }
    }

    public static final class RedstoneColor
    extends OrdinaryColor {
        private final Color color;
        private final float size;

        public RedstoneColor(Color color, float size) {
            super(color.getRed(), color.getGreen(), color.getBlue());
            this.color = color;
            this.size = size;
        }

        public Color getColor() {
            return this.color;
        }

        public float getSize() {
            return this.size;
        }
    }
}

