/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.maths;

import ch.njol.skript.Skript;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.ColoredVector;
import ud.skript.sashie.skDragon.particleEngine.utils.DynamicLocation;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.VectorUtils;
import ud.skript.sashie.skDragonCore;

public class Cape
extends EffectsLib {
    boolean initialize = false;
    boolean initImage = false;
    BufferedImage image = null;
    float hue;
    Player p;
    double capeHeight;
    boolean isGliding = false;
    float floatDown = 0.523599f;
    int imgHeight;
    int imgWidth;
    List<ColoredVector> vectorList = new ArrayList<ColoredVector>();
    File file;
    float size;
    DynamicLocation center;
    String idName;

    public Cape(File file, DynamicLocation center, String idName, int scale) {
        this.file = file;
        this.center = center;
        this.idName = idName;
        this.size = 1.0f / (float)scale;
        this.init();
        this.imageInit();
    }

    private void init() {
        if (!this.initialize) {
            if (this.image == null && this.file != null) {
                try {
                    this.image = ImageIO.read(this.file);
                }
                catch (Exception ex) {
                    Skript.warning((String)"[skDragon] Error: Invalid file type or make sure the image is in /plugins/skDragon/capes");
                    this.image = null;
                }
            }
            if (this.image == null) {
                EffectsLib.stopEffect(this.idName);
                Skript.warning((String)"[skDragon] Error: The image failed to load, try another? :c");
                return;
            }
            this.imgHeight = this.image.getHeight();
            this.imgWidth = this.image.getWidth();
            if (this.center.getEntity() instanceof Player) {
                this.p = (Player)this.center.getEntity();
            }
            this.initialize = true;
        }
    }

    private void imageInit() {
        int y = 0;
        while (y < this.imgHeight) {
            int x = 0;
            while (x < this.imgWidth) {
                int filter = this.image.getRGB(x, y);
                if (filter != 0 && filter >> 24 != 0 && filter != 0xFFFFFF) {
                    Color color = new Color(filter);
                    this.vectorList.add(new ColoredVector(new Vector((double)(this.imgWidth / 2 - x) - 0.5, (double)(-y), 0.0).multiply(this.size), color));
                }
                ++x;
            }
            ++y;
        }
        this.image.flush();
    }

    public void drawEffect(final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean dynamicCape, final float backSet, final float gravity, final double visibleRange, long delayStart, long delayPulse) {
        if (!EffectsLib.arraylist.containsKey(this.idName)) {
            int cape = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){

                @Override
                public void run() {
                    try {
                        Cape.this.center.update();
                        if (Cape.this.p != null) {
                            if (skDragonCore.serverVersion >= 9) {
                                Cape.this.isGliding = Cape.this.p.isGliding();
                            }
                            if (rainbowMode) {
                                Cape.this.hue = ParticleEffect.simpleRainbowHelper(Cape.this.hue, "redstone");
                            }
                            Cape.this.capeHeight = Cape.this.p.isSneaking() ? 1.2 / (double)Cape.this.imgHeight : (Cape.this.isGliding ? 0.5 / (double)Cape.this.imgHeight : 1.4 / (double)Cape.this.imgHeight);
                            Cape.this.center.add(0.0, (double)Cape.this.imgHeight * Cape.this.capeHeight, 0.0);
                            if (dynamicCape) {
                                Cape.this.center.movementCheck();
                                Cape.this.floatDown = Cape.this.center.isFalling() ? 2.9f : (Cape.this.center.isMoving() && !Cape.this.center.isFalling() ? (!(Cape.this.floatDown > 1.3f) ? 1.3f : (Cape.this.floatDown -= 0.1f + gravity)) : (Cape.this.floatDown > 0.523599f ? (Cape.this.floatDown -= 0.1f + gravity) : 0.523599f));
                            }
                        }
                        int i = Cape.this.vectorList.size();
                        while (i > 0) {
                            ColoredVector entry = Cape.this.vectorList.get(i - 1);
                            Vector v = entry.getPoint();
                            Color color = entry.getColor();
                            double yaw = Math.toRadians(-1.0f * Cape.this.center.getYaw() + 180.0f);
                            double pitch = -Cape.this.floatDown;
                            double cosYaw = Math.cos(yaw);
                            double cosPitch = Math.cos(pitch);
                            double sinYaw = Math.sin(yaw);
                            double sinPitch = Math.sin(pitch);
                            double initialY = v.getY();
                            double initialZ = v.getZ();
                            double z = initialY * sinPitch - initialZ * cosPitch;
                            double y = initialY * cosPitch + initialZ * sinPitch;
                            initialZ = z;
                            double initialX = v.getX();
                            z = initialZ * cosYaw - initialX * sinYaw;
                            double x = initialZ * sinYaw + initialX * cosYaw;
                            v.setX(x).setY(y).setZ(z);
                            Vector v2 = VectorUtils.getBackVector(Cape.this.center);
                            if (Cape.this.isGliding) {
                                v2.setY(0).multiply(1.1 + (double)backSet);
                            } else {
                                v2.setY(0).multiply(-0.3 + (double)backSet);
                            }
                            int r = color.getRed();
                            int g = color.getGreen();
                            int b = color.getBlue();
                            ParticleEffect.redstone.display(Cape.this.center.add(v).add(v2), visibleRange, isSinglePlayer, player, rainbowMode, Cape.this.hue, r, g, b);
                            Cape.this.center.subtract(v2).subtract(v);
                            --i;
                        }
                    }
                    catch (NullPointerException ex) {
                        Cape.foundNull(Cape.this.center, Cape.this.idName, ex);
                        Cape.stopEffect(Cape.this.idName);
                    }
                }
            }, delayStart, delayPulse).getTaskId();
            EffectsLib.arraylist.put(this.idName, cape);
        }
    }

    public boolean getRange(float low, float high, float x) {
        return x - low <= high - low;
    }
}

