/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.emojis;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ud.skript.sashie.skDragon.emojis.CustomEmote;
import ud.skript.sashie.skDragon.emojis.EmoteType;
import ud.skript.sashie.skDragon.emojis.SkullEffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Emotes - Built in")
@Description(value={"Using the names in the CustomEmotes.yml file you can play any custom emote or animation sequence you've made"})
@Syntaxes(value={"emote %emotetype% on %entity% [with [frame] delay %-number%][ [and] repeat[ing] %-number% [time[s]]]"})
@Examples(value={"emote smile on player", "emote cheeky on target entity", "emote santa wink on player with frame delay 1 and repeating 2 times", "emote rage on player with frame delay 2", "emote tan on player repeating 1 time"})
public class EffEmoteType
extends Effect {
    private Expression<EmoteType> name;
    private Expression<Entity> entity;
    private Expression<Number> pulseTicks;
    private Expression<Number> repeat;
    private String parsedSyntax;
    private boolean isRepeating = false;
    private int iterations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.entity = exprs[1];
        this.pulseTicks = exprs[2];
        this.repeat = exprs[3];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "emote: " + this.name.toString(e, debug) + " entity: " + this.entity.toString(e, debug) + " ticks: " + (this.pulseTicks != null ? this.pulseTicks.toString(e, debug) : "0") + " repeats: " + (this.repeat != null ? this.repeat.toString(e, debug) : "0");
    }

    protected void execute(final @Nullable Event e) {
        final LivingEntity ent = (LivingEntity)this.entity.getSingle(e);
        String skullName = "\ufffdb\ufffdlEMOTE-" + ent.getUniqueId().toString();
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.pulseTicks);
        if (this.parsedSyntax.contains("repeat")) {
            this.isRepeating = true;
        }
        this.iterations = SkriptHandler.inputInt(0, e, this.repeat);
        if (!SkullEffectsLib.emotelist.containsKey(ent.getUniqueId().toString())) {
            SkullEffectsLib.originalItem.put(ent.getUniqueId().toString(), SkullEffectsLib.getHelmet(ent));
            final CustomEmote emote = ((EmoteType)((Object)this.name.getSingle(e))).initEmote();
            final ArrayList<ItemStack> skulls = new ArrayList<ItemStack>();
            int i = 0;
            while (i < emote.size()) {
                skulls.add(SkullEffectsLib.createSkull(skullName, emote.getFrameData(i)));
                ++i;
            }
            int custom = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                int time = 0;
                int skullStep = 0;
                int timeCounter = 0;

                @Override
                public void run() {
                    ((EmoteType)((Object)EffEmoteType.this.name.getSingle(e))).playParticle(this.time, this.skullStep, ent.getEyeLocation());
                    if (this.time == this.timeCounter) {
                        this.timeCounter += emote.getFrameLength(this.skullStep);
                        SkullEffectsLib.setHelmet(ent, (ItemStack)skulls.get(this.skullStep));
                        ++this.skullStep;
                    }
                    ++this.time;
                    if (EffEmoteType.this.isRepeating) {
                        if (this.time >= emote.getTotalLength()) {
                            this.time = 0;
                            this.skullStep = 0;
                            this.timeCounter = 0;
                            EffEmoteType effEmoteType = EffEmoteType.this;
                            effEmoteType.iterations = effEmoteType.iterations - 1;
                        }
                        if (EffEmoteType.this.iterations < 1) {
                            SkullEffectsLib.removeSkull(ent);
                            Bukkit.getScheduler().cancelTask(SkullEffectsLib.emotelist.get(ent.getUniqueId().toString()).intValue());
                            SkullEffectsLib.emotelist.remove(ent.getUniqueId().toString());
                        }
                    } else if (this.time >= emote.getTotalLength()) {
                        SkullEffectsLib.removeSkull(ent);
                        Bukkit.getScheduler().cancelTask(SkullEffectsLib.emotelist.get(ent.getUniqueId().toString()).intValue());
                        SkullEffectsLib.emotelist.remove(ent.getUniqueId().toString());
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            SkullEffectsLib.emotelist.put(ent.getUniqueId().toString(), custom);
        }
    }
}

