/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.dragontravel.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import ud.skript.sashie.skDragon.dragontravel.DragonTravelHook;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="DragonTravel - Station displayname")
@Description(value={"Gets the displayname of a dragontravel station"})
@Syntaxes(value={"displayname of station named %string%"})
@Examples(value={"set {_name} to displayname of station named \"test\""})
public class ExprStationDisplayName
extends SimpleExpression<String> {
    private Expression<String> name;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.name = expr[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "DragonTravel Station displayname";
    }

    @Nullable
    protected String[] get(Event e) {
        String n = (String)this.name.getSingle(e);
        String displayName = DragonTravelHook.getStationDisplayName(n);
        try {
            return new String[]{displayName};
        }
        catch (Exception ex) {
            skDragonCore.error("No stations with that name exist");
            return new String[1];
        }
    }
}

