/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import ud.skript.sashie.skDragon.particleEngine.maths.Heart;
import ud.skript.sashie.skDragon.particleEngine.utils.DynamicLocation;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;

@Name(value="drawHeart")
@Description(value={"Draws a heart shape at a player or location"})
@Syntaxes(value={"drawHeart particle %particlename%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %object%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], ySpin %number%, width %number%, height %number%, innerSpike %number%, compress %number%, density %number%, visibleRange %number%[, rot[ation]XYZ %-number%, %-number%, %-number%][, dis[placement]XYZ %-number%, %-number%, %-number%][, pulseDelay %-number%]"})
@Examples(value={"placeholder"})
public class EffHeart
extends Effect {
    private Expression<ParticleEffect> inputParticle;
    private Expression<ItemStack> inputParticleData;
    private Expression<Number> speed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<?> entLoc;
    private Expression<String> InputIdName;
    private Expression<Boolean> singlePlayer;
    private Expression<Player> player;
    private Expression<Boolean> rainbMode;
    private Expression<Number> spin;
    private Expression<Number> inputWidth;
    private Expression<Number> inputHeight;
    private Expression<Number> inputInnerSpike;
    private Expression<Number> inputCompress;
    private Expression<Number> inputDensity;
    private Expression<Number> range;
    private Expression<Number> xRot;
    private Expression<Number> yRot;
    private Expression<Number> zRot;
    private Expression<Number> displaceX;
    private Expression<Number> displaceY;
    private Expression<Number> displaceZ;
    private Expression<Number> ticks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inputParticle = exprs[0];
        this.inputParticleData = exprs[1];
        this.speed = exprs[2];
        this.offX = exprs[3];
        this.offY = exprs[4];
        this.offZ = exprs[5];
        this.entLoc = exprs[6];
        this.InputIdName = exprs[7];
        this.singlePlayer = exprs[8];
        this.player = exprs[9];
        this.rainbMode = exprs[10];
        this.spin = exprs[11];
        this.inputWidth = exprs[12];
        this.inputHeight = exprs[13];
        this.inputInnerSpike = exprs[14];
        this.inputCompress = exprs[15];
        this.inputDensity = exprs[16];
        this.range = exprs[17];
        this.xRot = exprs[18];
        this.yRot = exprs[19];
        this.zRot = exprs[20];
        this.displaceX = exprs[21];
        this.displaceY = exprs[22];
        this.displaceZ = exprs[23];
        this.ticks = exprs[24];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "drawHeart particle %particlename%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %entity/location%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], ySpin %number%, width %number%, height %number%, innerSpike %number%, compress %number%, density %number%, visibleRange %number%[, rot[ation]XYZ %-number%, %-number%, %-number%][, dis[placement]XYZ %-number%, %-number%, %-number%][, pulseDelay %-number%]";
    }

    protected void execute(@Nullable Event e) {
        DynamicLocation center;
        ParticleEffect particle = (ParticleEffect)((Object)this.inputParticle.getSingle(e));
        Material dataMat = SkriptHandler.inputParticleDataMat(e, this.inputParticleData);
        byte dataID = SkriptHandler.inputParticleDataID(e, this.inputParticleData);
        float finalSpeed = SkriptHandler.inputFloat(0.0f, e, this.speed);
        int offsetX = SkriptHandler.inputInt(0, e, this.offX);
        int offsetY = SkriptHandler.inputInt(0, e, this.offY);
        int offsetZ = SkriptHandler.inputInt(0, e, this.offZ);
        try {
            center = DynamicLocation.init(this.entLoc.getSingle(e));
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        String idName = (String)this.InputIdName.getSingle(e);
        boolean isSinglePlayer = SkriptHandler.inputBoolean(false, e, this.singlePlayer);
        Player p = SkriptHandler.inputPlayer(e, this.player);
        boolean rainbowMode = SkriptHandler.inputBoolean(false, e, this.rainbMode);
        float finalSpin = ((Number)this.spin.getSingle(e)).floatValue();
        double finalWidth = ((Number)this.inputWidth.getSingle(e)).doubleValue();
        double finalHeight = ((Number)this.inputHeight.getSingle(e)).doubleValue();
        double finalInnerSpike = ((Number)this.inputInnerSpike.getSingle(e)).doubleValue();
        double finalCompress = ((Number)this.inputCompress.getSingle(e)).doubleValue();
        int pDensity = SkriptHandler.inputInt(10, e, this.inputDensity);
        double visibleRange = ((Number)this.range.getSingle(e)).doubleValue();
        double xRotation = SkriptHandler.inputDouble(0.0, e, this.xRot);
        double yRotation = SkriptHandler.inputDouble(0.0, e, this.yRot);
        double zRotation = SkriptHandler.inputDouble(0.0, e, this.zRot);
        double disX = SkriptHandler.inputDouble(0.0, e, this.displaceX);
        double disY = SkriptHandler.inputDouble(0.0, e, this.displaceY);
        double disZ = SkriptHandler.inputDouble(0.0, e, this.displaceZ);
        long finalDelayTicks = SkriptHandler.inputLong(0, e, this.ticks);
        Heart.drawEffect(particle, finalSpeed, dataMat, dataID, idName, center, isSinglePlayer, p, rainbowMode, finalSpin, finalWidth, finalHeight, finalInnerSpike, finalCompress, pDensity, xRotation, yRotation, zRotation, offsetX, offsetY, offsetZ, disX, disY, disZ, visibleRange, 0L, finalDelayTicks);
    }
}

