/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.dragontravel;

import eu.phiwa.dragontravel.core.DragonTravel;
import eu.phiwa.dragontravel.core.hooks.server.IRyeDragon;
import eu.phiwa.dragontravel.core.movement.flight.Flight;
import eu.phiwa.dragontravel.core.movement.stationary.StationaryDragon;
import eu.phiwa.dragontravel.core.movement.travel.Home;
import eu.phiwa.dragontravel.core.movement.travel.Station;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DragonTravelHook {
    private File dbStationsFile;
    private FileConfiguration dbStationsConfig;
    public static final List<Station> stations = new ArrayList<Station>();
    private File dbHomesFile;
    private FileConfiguration dbHomesConfig;
    private File dbStatDragonsFile;
    private FileConfiguration dbStatDragonsConfig;
    private File dbFlightsFile;
    private FileConfiguration dbFlightsConfig;

    public void initStationDB() {
        this.dbStationsFile = new File("plugins/DragonTravel/databases", "stations.yml");
        this.dbStationsConfig = new YamlConfiguration();
        try {
            this.dbStationsConfig.load(this.dbStationsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cacheStations() {
        for (String name : this.dbStationsConfig.getConfigurationSection("Stations").getKeys(false)) {
            Station station = DragonTravel.getInstance().getDbStationsHandler().getStation(name);
            stations.add(station);
        }
    }

    public List<String> getStationNames() {
        ArrayList<String> stations = new ArrayList<String>();
        for (String name : this.dbStationsConfig.getConfigurationSection("Stations").getKeys(false)) {
            Station station = DragonTravelHook.getStation(name);
            stations.add(station.getName());
        }
        return stations;
    }

    public static Station getStation(String name) {
        return DragonTravel.getInstance().getDbStationsHandler().getStation(name);
    }

    public static Location getStationLocation(String name) {
        return DragonTravelHook.getStation(name).toLocation();
    }

    public static String getStationDisplayName(String name) {
        return DragonTravelHook.getStation(name).getDisplayName();
    }

    public static String getStationOwner(String name) {
        return DragonTravelHook.getStation(name).getOwner();
    }

    public void initHomesDB() {
        this.dbHomesFile = new File("plugins/DragonTravel/databases", "homes.yml");
        this.dbHomesConfig = new YamlConfiguration();
        try {
            this.dbHomesConfig.load(this.dbHomesFile);
            Bukkit.getLogger().log(Level.INFO, "[DragonTravel] Loaded homes-database.");
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "[DragonTravel] No homes-database found");
            e.printStackTrace();
        }
    }

    public List<String> getAllHomes() {
        ArrayList<String> homes = new ArrayList<String>();
        for (String name : this.dbHomesConfig.getConfigurationSection("Homes").getKeys(false)) {
            Home home = DragonTravel.getInstance().getDbHomesHandler().getHome(name);
            if (home == null) continue;
            homes.add(home.playerName);
        }
        return homes;
    }

    public static Location getHomeLocation(String name) {
        return DragonTravel.getInstance().getDbHomesHandler().getHome(name).toLocation();
    }

    public void initStatDragonDB() {
        this.dbStatDragonsFile = new File("plugins/DragonTravel/databases", "statdragons.yml");
        this.dbStatDragonsConfig = new YamlConfiguration();
        try {
            this.dbStatDragonsConfig.load(this.dbStatDragonsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getStatDragonNames() {
        ArrayList<String> statDragons = new ArrayList<String>();
        for (String name : this.dbStatDragonsConfig.getConfigurationSection("StatDragons").getKeys(false)) {
            StationaryDragon sDragon = DragonTravelHook.getStatDragon(name);
            statDragons.add(sDragon.getName());
        }
        return statDragons;
    }

    private static StationaryDragon getStatDragon(String name) {
        return (StationaryDragon)DragonTravel.getInstance().getDragonManager().getStationaryDragons().get(name);
    }

    public static Location getStatDragonLocation(String name) {
        return new Location(Bukkit.getWorld((String)DragonTravelHook.getStatDragon(name).getWorldName()), DragonTravelHook.getStatDragon(name).getX(), DragonTravelHook.getStatDragon(name).getY(), DragonTravelHook.getStatDragon(name).getZ(), (float)DragonTravelHook.getStatDragon(name).getYaw(), (float)DragonTravelHook.getStatDragon(name).getPitch());
    }

    public static String getStatDragonDisplayName(String name) {
        return DragonTravelHook.getStatDragon(name).getDisplayName();
    }

    public static String getStatDragonOwner(String name) {
        return DragonTravelHook.getStatDragon(name).getOwner();
    }

    public static void setStatDragonDisplayName(String name, String display) {
        DragonTravelHook.getStatDragon(name).setDisplayName(display);
    }

    public static IRyeDragon getStatDragonInfo(String name) {
        return DragonTravelHook.getStatDragon(name).getDragon();
    }

    public void initFlightDB() {
        this.dbFlightsFile = new File("plugins/DragonTravel/databases", "flights.yml");
        this.dbFlightsConfig = new YamlConfiguration();
        try {
            this.dbFlightsConfig.load(this.dbFlightsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getFlightNames() {
        ArrayList<String> flights = new ArrayList<String>();
        for (String name : this.dbFlightsConfig.getConfigurationSection("Flights").getKeys(false)) {
            Flight flight = DragonTravelHook.getFlight(name);
            flights.add(flight.getName());
        }
        return flights;
    }

    private static Flight getFlight(String name) {
        return DragonTravel.getInstance().getDbFlightsHandler().getFlight(name);
    }
}

