/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.utils;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.utils.enums.PlaneEnum;

public final class VectorUtils {
    private VectorUtils() {
    }

    public static Vector rot(Vector vector, Vector axis, double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        Vector a = axis.clone().normalize();
        double ax = a.getX();
        double ay = a.getY();
        double az = a.getZ();
        Vector rotx = new Vector(cos + ax * ax * (1.0 - cos), ax * ay * (1.0 - cos) - az * sin, ax * az * (1.0 - cos) + ay * sin);
        Vector roty = new Vector(ay * ax * (1.0 - cos) + az * sin, cos + ay * ay * (1.0 - cos), ay * az * (1.0 - cos) - ax * sin);
        Vector rotz = new Vector(az * ax * (1.0 - cos) - ay * sin, az * ay * (1.0 - cos) + ax * sin, cos + az * az * (1.0 - cos));
        double x = rotx.dot(vector);
        double y = roty.dot(vector);
        double z = rotz.dot(vector);
        vector.setX(x).setY(y).setZ(z);
        return vector;
    }

    public static final Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static final Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static final Vector rotateAroundAxisY(Vector v, float angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static final Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    public static final Vector rotateVector(Vector v, double angleX, double angleY, double angleZ) {
        VectorUtils.rotateAroundAxisX(v, angleX);
        VectorUtils.rotateAroundAxisY(v, angleY);
        VectorUtils.rotateAroundAxisZ(v, angleZ);
        return v;
    }

    public static final Vector rotateVector(Vector v, Location location) {
        return VectorUtils.rotateVectorYZ(v, location.getYaw(), location.getPitch());
    }

    public static final Vector rotateVectorYZ(Vector v, float yawDegrees, float pitchDegrees) {
        double yaw = -1.0f * (yawDegrees + 90.0f);
        double pitch = -pitchDegrees;
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialX = v.getX();
        double initialY = v.getY();
        double x = initialX * cosPitch - initialY * sinPitch;
        double y = initialX * sinPitch + initialY * cosPitch;
        double initialZ = v.getZ();
        initialX = x;
        double z = initialZ * cosYaw - initialX * sinYaw;
        x = initialZ * sinYaw + initialX * cosYaw;
        return new Vector(x, y, z);
    }

    public static final Vector rotateVectorYX(Vector v, float yawDegrees, float pitchDegrees) {
        double yaw = -1.0f * yawDegrees;
        double pitch = -pitchDegrees;
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialY = v.getY();
        double initialZ = v.getZ();
        double z = initialY * sinPitch - initialZ * cosPitch;
        double y = initialY * cosPitch + initialZ * sinPitch;
        initialZ = z;
        double initialX = v.getX();
        z = initialZ * cosYaw - initialX * sinYaw;
        double x = initialZ * sinYaw + initialX * cosYaw;
        return new Vector(x, y, z);
    }

    public static final Vector rotateVectorXYZ(Vector v, float xRadians, float yRadians, float zRadians) {
        double inputY = -1.0f * yRadians;
        double inputX = -xRadians;
        double inputZ = -zRadians;
        double cosY = Math.cos(inputY);
        double cosX = Math.cos(inputX);
        double cosZ = Math.cos(inputZ);
        double sinY = Math.sin(inputY);
        double sinX = Math.sin(inputX);
        double sinZ = Math.sin(inputZ);
        double initialY = v.getY();
        double initialZ = v.getZ();
        double z = initialY * sinX - initialZ * cosX;
        double y = initialY * cosX + initialZ * sinX;
        initialZ = z;
        double initialX = v.getX();
        z = initialZ * cosY - initialX * sinY;
        double x = initialZ * sinY + initialX * cosY;
        initialX = v.getX();
        initialY = v.getY();
        x = initialX * cosZ - initialY * sinZ;
        y = initialX * sinZ + initialY * cosZ;
        return new Vector(x, y, z);
    }

    public static float angleXZBetweenPoints(Location center, Location facing) {
        double dx = facing.getX() - center.getX();
        double dz = -(facing.getZ() - center.getZ());
        double angle = Math.atan2(dz, dx);
        angle = angle < 0.0 ? Math.abs(angle) : Math.PI * 2 - angle;
        return (float)angle;
    }

    public static float angleXYBetweenPoints(Location center, Location facing) {
        double dx = facing.getX() - center.getX();
        double dy = -(facing.getY() - center.getY());
        double angle = Math.atan2(dy, dx);
        angle = angle < 0.0 ? Math.abs(angle) : Math.PI * 2 - angle;
        return (float)angle;
    }

    public static final double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }

    public static Vector getBackVector(Location location) {
        float newZ = (float)(location.getZ() + 1.0 * Math.sin(Math.toRadians(location.getYaw() + 90.0f)));
        float newX = (float)(location.getX() + 1.0 * Math.cos(Math.toRadians(location.getYaw() + 90.0f)));
        return new Vector((double)newX - location.getX(), 0.0, (double)newZ - location.getZ());
    }

    public static double offset(Entity a, Entity b) {
        return VectorUtils.offset(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset(Location a, Location b) {
        return VectorUtils.offset(a.toVector(), b.toVector());
    }

    public static double offset(Vector a, Vector b) {
        return a.subtract(b).length();
    }

    public static Vector planeRotation(Vector v, PlaneEnum plane, Vector angularVelocity, int rotationStep) {
        double rotX = 0.0;
        double rotY = 0.0;
        double rotZ = 0.0;
        switch (plane) {
            case X: {
                rotX = Math.PI / angularVelocity.getX() * (double)rotationStep;
                break;
            }
            case Y: {
                rotY = Math.PI / angularVelocity.getY() * (double)rotationStep;
                break;
            }
            case Z: {
                rotZ = Math.PI / angularVelocity.getZ() * (double)rotationStep;
                break;
            }
            case XY: {
                rotX = Math.PI / angularVelocity.getX() * (double)rotationStep;
                rotY = Math.PI / angularVelocity.getY() * (double)rotationStep;
                break;
            }
            case XZ: {
                rotX = Math.PI / angularVelocity.getX() * (double)rotationStep;
                rotZ = Math.PI / angularVelocity.getZ() * (double)rotationStep;
                break;
            }
            case XYZ: {
                rotX = Math.PI / angularVelocity.getX() * (double)rotationStep;
                rotY = Math.PI / angularVelocity.getY() * (double)rotationStep;
                rotZ = Math.PI / angularVelocity.getZ() * (double)rotationStep;
                break;
            }
            case YZ: {
                rotY = Math.PI / angularVelocity.getY() * (double)rotationStep;
                rotZ = Math.PI / angularVelocity.getZ() * (double)rotationStep;
            }
        }
        v = VectorUtils.rotateVectorYX(v, (float)rotY, (float)rotX);
        v = VectorUtils.rotateVectorYZ(v, 0.0f, (float)rotZ);
        return v;
    }

    public static Vector calculateBezierPoint(float t, Vector p0, Vector p1, Vector p2, Vector p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        Vector p = p0.multiply(uuu);
        p.add(p1.multiply(3.0f * uu * t));
        p.add(p2.multiply(3.0f * u * tt));
        p.add(p3.multiply(ttt));
        return p;
    }

    public static Vector calculateBezierPoint(float t, Location p0, Location p1, Location p2, Location p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        Vector p = p0.toVector().multiply(uuu);
        p.add(p1.toVector().multiply(3.0f * uu * t));
        p.add(p2.toVector().multiply(3.0f * u * tt));
        p.add(p3.toVector().multiply(ttt));
        return p;
    }
}

