/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects.spawns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.effects.DragonEffect;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.maths.FancyShapes;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Spawn more complex directional particle patterns using colorable particles")
@Description(value={"Most particles react differently to this effect using their individual built in mojang nature", "Uses any bukkit vector type as input for the direction"})
@Syntaxes(value={"draw %number% style %number% (redstone|mobspell|mobspellambient) particle[s] at %objects% with direction %vector%, speed %number% and RGB %number%, %number%, %number%[, offset %-number%, %-number%, %-number%][, id %-string%][, r[ainbow]M[ode] %-boolean%][, randomColor %-boolean%][, visibleTo %-players%][, visibleRange %-number%][, pulseDelay %-number%][, keepFor %-timespan%]"})
@Examples(value={"draw 2 style 2 redstone particles at location of player with direction {_v}, speed .4 and RGB 20, 50, 80, keepFor 1 second"})
public class EffSpawnParticleDirectionMadness
extends DragonEffect {
    private Expression<Number> partCount;
    private Expression<Number> inputStyle;
    private Expression<?> entLoc;
    private Expression<Vector> inputDirection;
    private Expression<Number> inputSpeed;
    private Expression<Number> coffX;
    private Expression<Number> coffY;
    private Expression<Number> coffZ;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<String> inputIdName;
    private Expression<Boolean> isRainbowTrue;
    private Expression<Boolean> inputRandomColor;
    private Expression<Player> inputPlayers;
    private Expression<Number> inputRange;
    private Expression<Number> inputPulseDelay;
    private Expression<Timespan> inputKeepDelay;
    private String parsedSyntax = "";

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.partCount = exprs[0];
        this.inputStyle = exprs[1];
        this.entLoc = exprs[2];
        this.inputDirection = exprs[3];
        this.inputSpeed = exprs[4];
        this.coffX = exprs[5];
        this.coffY = exprs[6];
        this.coffZ = exprs[7];
        this.offX = exprs[8];
        this.offY = exprs[9];
        this.offZ = exprs[10];
        this.inputIdName = exprs[11];
        this.isRainbowTrue = exprs[12];
        this.inputRandomColor = exprs[13];
        this.inputPlayers = exprs[14];
        this.inputRange = exprs[15];
        this.inputPulseDelay = exprs[16];
        this.inputKeepDelay = exprs[17];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Direction Particle Madness";
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        return null;
    }

    @Override
    protected void exec(@Nullable Event e) {
        final int count = SkriptHandler.inputParticleCount(e, this.partCount);
        final int style = SkriptHandler.inputInt(1, e, this.inputStyle);
        final Object[] center = this.entLoc.getAll(e);
        final boolean rainbowMode = SkriptHandler.inputRainbowMode(e, this.isRainbowTrue);
        final boolean randomColor = SkriptHandler.inputBoolean(false, e, this.inputRandomColor);
        final List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        float coffsetX = SkriptHandler.inputFloat(0.0f, e, this.coffX);
        float coffsetY = SkriptHandler.inputFloat(0.0f, e, this.coffY);
        float coffsetZ = SkriptHandler.inputFloat(0.0f, e, this.coffZ);
        final float offsetX = SkriptHandler.inputParticleOffset(e, this.offX);
        final float offsetY = SkriptHandler.inputParticleOffset(e, this.offY);
        final float offsetZ = SkriptHandler.inputParticleOffset(e, this.offZ);
        Vector direction = SkriptHandler.inputVector(e, this.inputDirection);
        float speed = SkriptHandler.inputFloat(0.0f, e, this.inputSpeed);
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseDelay);
        long finalKeepDelay = SkriptHandler.inputKeepDelay(e, this.inputKeepDelay);
        double range = SkriptHandler.inputDouble(32.0, e, this.inputRange);
        final String idName = this.inputIdName != null ? (String)this.inputIdName.getSingle(e) : "&dot-" + Math.random() + "-&dot";
        ParticleEffect inputParticle = ParticleEffect.redstone;
        if (this.parsedSyntax.contains("redstone")) {
            inputParticle = ParticleEffect.redstone;
        } else if (this.parsedSyntax.contains("mobspell")) {
            inputParticle = ParticleEffect.mobspell;
        } else if (this.parsedSyntax.contains("mobspellambient")) {
            inputParticle = ParticleEffect.mobspellambient;
        }
        final DragonParticle particle = new DragonParticle();
        particle.setRange(range);
        particle.setDirection(direction);
        particle.setSpeed(speed);
        particle.setParticle(inputParticle);
        if (this.inputKeepDelay != null && finalPulseTick > finalKeepDelay) {
            finalPulseTick = finalKeepDelay;
        }
        if (!EffectsLib.arraylist.containsKey(idName)) {
            int dotGo = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(coffsetX, coffsetY, coffsetZ){
                float finalOffsetX;
                float finalOffsetY;
                float finalOffsetZ;
                float finalColorOffsetX;
                float finalColorOffsetY;
                float finalColorOffsetZ;
                {
                    this.finalOffsetX = f;
                    this.finalOffsetY = f2;
                    this.finalOffsetZ = f3;
                    this.finalColorOffsetX = f4;
                    this.finalColorOffsetY = f5;
                    this.finalColorOffsetZ = f6;
                }

                @Override
                public void run() {
                    Object[] objectArray = center;
                    int n = center.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object loc = objectArray[n2];
                        Location location = EffSpawnParticleDirectionMadness.getLocation(loc);
                        if (randomColor) {
                            if (rainbowMode) {
                                this.finalColorOffsetY = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalColorOffsetZ = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                            } else {
                                this.finalColorOffsetX = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalColorOffsetY = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                                this.finalColorOffsetZ = RandomUtils.randomRangeFloat(0.0f, 255.0f);
                            }
                        }
                        if (rainbowMode) {
                            if (!randomColor) {
                                this.finalColorOffsetX = ParticleEffect.simpleRainbowHelper(this.finalColorOffsetX, particle.getParticle());
                            } else {
                                this.finalColorOffsetX = ParticleEffect.simpleRainbowHelper(this.finalColorOffsetX, particle.getParticle());
                                if (offsetY == 0.0f) {
                                    this.finalColorOffsetY = 1.0f;
                                }
                                if (offsetZ == 0.0f) {
                                    this.finalColorOffsetZ = 1.0f;
                                }
                            }
                        }
                        particle.setOffsetXYZ(this.finalColorOffsetX, this.finalColorOffsetY, this.finalColorOffsetZ);
                        int i = 0;
                        while (i < count) {
                            if (offsetX > 0.0f) {
                                this.finalOffsetX = RandomUtils.randomRangeFloat(-offsetX, offsetX);
                            }
                            if (offsetY > 0.0f) {
                                this.finalOffsetY = RandomUtils.randomRangeFloat(-offsetY, offsetY);
                            }
                            if (offsetZ > 0.0f) {
                                this.finalOffsetZ = RandomUtils.randomRangeFloat(-offsetZ, offsetZ);
                            }
                            location.add((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            FancyShapes boop = new FancyShapes(particle, rainbowMode);
                            if (style <= 1) {
                                boop.startLine1(location, idName, players);
                            } else if (style == 2) {
                                boop.startEnchant1(location, idName, players);
                            } else if (style == 3) {
                                boop.startEnchant2(location, idName, players);
                            } else if (style >= 4) {
                                boop.startPortal(location, idName, players);
                            }
                            location.subtract((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            ++i;
                        }
                        ++n2;
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            EffectsLib.arraylist.put(idName, dotGo);
            if (this.inputIdName == null) {
                EffectsLib.stopEffectDelayed(finalKeepDelay, dotGo, idName);
            }
        }
    }
}

