/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.emojis;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import ud.skript.sashie.skDragon.emojis.CustomEmote;
import ud.skript.sashie.skDragonCore;

public class SkullConfig {
    private File skullConfig;
    private FileConfiguration skullData;
    public static final HashMap<String, CustomEmote> customEmoteList = new HashMap();
    public static final HashMap<String, String> customSkullList = new HashMap();

    public SkullConfig() {
        this.initFile();
    }

    private void initFile() {
        this.skullConfig = new File(skDragonCore.getFolder(), "CustomEmotes.yml");
        if (!this.skullConfig.exists()) {
            this.skullConfig.getParentFile().mkdirs();
            skDragonCore.error("CustomEmotes.yml not found, generating new one");
            skDragonCore.getInstance().saveResource("CustomEmotes.yml", false);
        }
        this.skullData = new YamlConfiguration();
        try {
            this.skullData.load(this.skullConfig);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void initData() {
        for (String name : this.skullData.getConfigurationSection("Skulls").getKeys(false)) {
            String data = this.skullData.getString("Skulls." + name);
            customSkullList.put(name, data);
        }
        for (String name : this.skullData.getConfigurationSection("Emotes").getKeys(false)) {
            CustomEmote emote = new CustomEmote(name);
            Map frames = this.skullData.getConfigurationSection("Emotes." + name + ".Frames").getValues(false);
            Map timings = this.skullData.getConfigurationSection("Emotes." + name + ".Timings").getValues(false);
            int i = 1;
            while (i < frames.size() + 1) {
                String key = String.valueOf(i);
                boolean found = false;
                for (String skull : customSkullList.keySet()) {
                    if (!this.skullData.getString("Emotes." + name + ".Frames." + key).equals(skull)) continue;
                    emote.addFrame((Integer)timings.get(key), customSkullList.get((String)frames.get(key)));
                    found = true;
                    break;
                }
                if (!found) {
                    emote.addFrame((Integer)timings.get(key), (String)frames.get(key));
                }
                ++i;
            }
            customEmoteList.put(name, emote);
        }
    }

    public void reload() {
        customSkullList.clear();
        customEmoteList.clear();
        this.initData();
    }
}

