/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.tint;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragon.tint.TintAPI;

@Name(value="Send Red Tint")
@Description(value={"Sends red tint to a player"})
@Syntaxes(value={"send[ red] tint to %players%[ with fadeTime %-number%, intensity %-number% and damageMode %-boolean%]"})
@Examples(value={"send red tint to player", "send red tint to player with fadeTime 3, intensity 2 and damageMode true"})
public class EffSendPlayersTint
extends Effect {
    private Expression<Player> inputPlayers;
    private Expression<Number> inputFadeTime;
    private Expression<Number> inputIntensity;
    private Expression<Boolean> inputDamageMode;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inputPlayers = exprs[0];
        this.inputFadeTime = exprs[1];
        this.inputIntensity = exprs[2];
        this.inputDamageMode = exprs[3];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "send[ red] tint to %players%[ with fadeTime %number%, intensity %number% and damageMode %boolean%]";
    }

    protected void execute(@Nullable Event e) {
        List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        int fadeTime = SkriptHandler.inputInt(5, e, this.inputFadeTime);
        int intensity = SkriptHandler.inputInt(2, e, this.inputIntensity);
        boolean damageMode = SkriptHandler.inputBoolean(true, e, this.inputDamageMode);
        if (players != null) {
            for (Player p : players) {
                int percentage;
                int health = TintAPI.tintUtils.getPlayerHealth(p);
                int maxhealth = TintAPI.tintUtils.getMaxPlayerHealth(p);
                if (damageMode) {
                    health = (int)p.getLastDamage();
                    percentage = 100 - health * 100 / maxhealth;
                } else {
                    percentage = (health -= (int)p.getLastDamage()) * 100 / maxhealth;
                }
                TintAPI.tintUtils.sendBorder(p, percentage, fadeTime, intensity);
            }
        }
    }
}

