/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.registration;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.util.SimpleExpression;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ud.skript.sashie.skDragon.registration.Documentation;
import ud.skript.sashie.skDragon.registration.Registration;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.DontRegister;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.ExpressionsType;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.PropertyExpressionType;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

public class AnnotationParser {
    public <T> void register() throws Exception {
        File file = null;
        try {
            file = new File(URLDecoder.decode(skDragonCore.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Could not find main .jar file!");
            e.printStackTrace();
        }
        for (Class<?> clazz : this.getClasses(file, "ud.skript.sashie")) {
            if (Effect.class.isAssignableFrom(clazz)) {
                this.effects(clazz);
                continue;
            }
            if (SimplePropertyExpression.class.isAssignableFrom(clazz)) {
                this.simplePropertyExpressions(clazz);
                continue;
            }
            if (PropertyExpression.class.isAssignableFrom(clazz)) {
                this.propertyExpressions(clazz);
                continue;
            }
            if (SimpleExpression.class.isAssignableFrom(clazz)) {
                this.simpleExpressions(clazz);
                continue;
            }
            if (Expression.class.isAssignableFrom(clazz)) {
                this.expressions(clazz);
                continue;
            }
            if (SkriptEvent.class.isAssignableFrom(clazz)) {
                this.events(clazz);
                continue;
            }
            if (Condition.class.isAssignableFrom(clazz)) {
                this.conditions(clazz);
                continue;
            }
            if (!PropertyCondition.class.isAssignableFrom(clazz)) continue;
            this.propertyConditions(clazz);
        }
    }

    private void effects(Class<? extends Effect> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
        if (clazz.getAnnotation(Syntaxes.class) == null) {
            return;
        }
        String[] syntax = this.getSyntax(clazz.getAnnotation(Syntaxes.class));
        Skript.registerEffect(clazz, (String[])syntax);
        this.registerDocs(clazz, Documentation.effects, syntax);
    }

    private <T> void expressions(Class<? extends Expression<T>> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
        if (clazz.getAnnotation(Syntaxes.class) == null) {
            return;
        }
        String[] syntax = this.getSyntax(clazz.getAnnotation(Syntaxes.class));
        ExpressionsType type = clazz.getAnnotation(ExpressionsType.class);
        Class returnType = this.getExpressionReturnType(clazz);
        if (type == null) {
            Skript.registerExpression(clazz, (Class)returnType, (ExpressionType)ExpressionType.SIMPLE, (String[])syntax);
        } else {
            Skript.registerExpression(clazz, (Class)returnType, (ExpressionType)type.value(), (String[])syntax);
        }
        this.registerDocs(clazz, Documentation.expressions, syntax);
    }

    private <T> void simpleExpressions(Class<? extends Expression<T>> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
        if (clazz.getAnnotation(Syntaxes.class) == null) {
            return;
        }
        String[] syntax = this.getSyntax(clazz.getAnnotation(Syntaxes.class));
        Class returnType = this.getExpressionReturnType(clazz);
        Skript.registerExpression(clazz, (Class)returnType, (ExpressionType)ExpressionType.SIMPLE, (String[])syntax);
        this.registerDocs(clazz, Documentation.expressions, syntax);
    }

    private <T> void simplePropertyExpressions(Class<? extends Expression<T>> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
        if (clazz.getAnnotation(Syntaxes.class) == null) {
            return;
        }
        String[] syntax = this.getSyntax(clazz.getAnnotation(Syntaxes.class));
        PropertyExpressionType propertyType = clazz.getAnnotation(PropertyExpressionType.class);
        if (propertyType == null) {
            skDragonCore.error("lel this 'SimplePropertyExpression' needs 'PropertyExpressionType' annotation and Sashie forgot to add it :p");
            return;
        }
        Class returnType = this.getExpressionReturnType(clazz);
        int i = 0;
        while (i < syntax.length) {
            SimplePropertyExpression.register(clazz, (Class)returnType, (String)syntax[i], (String)propertyType.value()[0]);
            ++i;
        }
        this.registerDocs(clazz, Documentation.expressions, syntax);
    }

    private <T> void propertyExpressions(Class<? extends Expression<T>> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
        if (clazz.getAnnotation(Syntaxes.class) == null) {
            return;
        }
        String[] syntax = this.getSyntax(clazz.getAnnotation(Syntaxes.class));
        Class returnType = this.getExpressionReturnType(clazz);
        Skript.registerExpression(clazz, (Class)returnType, (ExpressionType)ExpressionType.PROPERTY, (String[])syntax);
        this.registerDocs(clazz, Documentation.expressions, syntax);
    }

    private void events(Class<? extends SkriptEvent> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
    }

    private void conditions(Class<? extends Condition> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
    }

    private void propertyConditions(Class<? extends Condition> clazz) {
        if (clazz.getAnnotation(DontRegister.class) != null) {
            return;
        }
    }

    private String[] getSyntax(Syntaxes syntaxes) {
        return this.appendPrefix(syntaxes.value());
    }

    private void registerDocs(Class<?> clazz, List<Registration> list, String[] syntax) {
        if (clazz.getAnnotation(Name.class) == null || clazz.getAnnotation(Name.class).value().isEmpty()) {
            skDragonCore.error(String.valueOf(clazz.getCanonicalName()) + " is not documented, get your lazy ass going and fix it Sashie!");
        } else {
            list.add(new Registration(clazz.getAnnotation(Name.class).value(), clazz.getAnnotation(Description.class).value(), syntax, clazz.getAnnotation(Examples.class).value()));
        }
    }

    private String[] appendPrefix(String[] syntax) {
        String[] syntaxes = null;
        int i = 0;
        if (syntax != null) {
            syntaxes = new String[syntax.length];
            String[] stringArray = syntax;
            int n = syntax.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                syntaxes[i] = "[skDragon] " + s;
                ++i;
                ++n2;
            }
            return syntaxes;
        }
        return null;
    }

    public Set<Class<?>> getClasses(File jarFile, String packageName) {
        HashSet classes = new HashSet();
        try {
            JarFile file = new JarFile(jarFile);
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String name = jarEntry.getName().replace("/", ".");
                if (!name.startsWith(packageName) || !name.endsWith(".class") || name.contains("dragontravel") && !skDragonCore.isDragonTravelEnabled()) continue;
                classes.add(Class.forName(name.substring(0, name.length() - 6)));
            }
            file.close();
        }
        catch (Exception e) {
            ClassNotFoundException.class.isAssignableFrom(e.getClass());
            e.printStackTrace();
        }
        return classes;
    }

    private Class getExpressionReturnType(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getReturnType", new Class[0]);
            Object o = clazz.newInstance();
            Object returnType = method.invoke(o, new Object[0]);
            return returnType.getClass();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

