/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.fancyeffects.maths;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.fancyeffects.FancyEffectManager;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.VectorUtils;

public abstract class CachedEffect
extends FancyEffectManager {
    private static final long serialVersionUID = 1L;
    protected List<Vector> vectors;
    private boolean init;
    double angularVelocityX;
    double angularVelocityY;
    double angularVelocityZ;
    protected float step;
    private Vector v;
    int i = 0;

    public CachedEffect(ParticleEffect particle) {
        this.effect.getParticle().setParticle(particle);
        this.v = new Vector(0, 0, 0);
        this.vectors = new ArrayList<Vector>();
        this.init = false;
        this.angularVelocityX = this.PI / 200.0;
        this.angularVelocityY = this.PI / 170.0;
        this.angularVelocityZ = this.PI / 155.0;
        this.step = 0.0f;
    }

    public abstract void init();

    public abstract void solid();

    public abstract void nonSolid();

    @Override
    public void onRun() {
        if (!this.init) {
            if (this.effect.getCurrentLocation().isDynamic()) {
                this.effect.getCurrentLocation().add(this.effect.getDisX(), this.effect.getDisY() + 1.0f, this.effect.getDisZ());
            } else {
                this.effect.getCurrentLocation().add(this.effect.getDisplacement());
            }
            this.init();
            this.effect.setSize(this.vectors.size());
            this.init = true;
        } else {
            if (this.effect.getReset()) {
                this.effect.setCurrentLocation(this.effect.getStartLocation());
                this.v = new Vector(0, 0, 0);
                this.vectors.clear();
                this.effect.setReset(false);
                this.init();
                this.effect.setSize(this.vectors.size());
            }
            this.effect.getCurrentLocation().update();
            if (this.effect.getParticle().getParticle().hasProperty(ParticleEffect.ParticleProperty.COLORABLE) && this.effect.rainbowMode()) {
                this.effect.getParticle().setOffsetX(ParticleEffect.simpleRainbowHelper(this.effect.getParticle().getOffsetX(), this.effect.getParticle().getParticle()));
                if (this.effect.getParticle().getOffsetY() == 0.0f) {
                    this.effect.getParticle().setOffsetY(1.0f);
                }
                if (this.effect.getParticle().getOffsetZ() == 0.0f) {
                    this.effect.getParticle().setOffsetZ(1.0f);
                }
            }
            if (this.effect.getIsSolid()) {
                this.solid();
                this.rotate();
                int i = 0;
                while (i < this.vectors.size()) {
                    this.v = this.vectors.get(i);
                    this.spawnParticle(this.v);
                    ++i;
                }
            } else {
                this.nonSolid();
                this.v = this.vectors.get(this.i);
                this.rotate();
                this.spawnParticle(this.v);
                ++this.i;
                if (this.i >= this.vectors.size()) {
                    this.i = 0;
                }
            }
            this.step += 1.0f;
        }
    }

    public void rotate() {
        if (this.effect.isAutoRotating()) {
            int i = 0;
            while (i < this.vectors.size()) {
                this.v = this.rotateShape(this.vectors.get(i));
                this.vectors.remove(i);
                this.vectors.add(this.v);
                ++i;
            }
        }
    }

    public Vector rotateShape(Vector v) {
        return VectorUtils.rotateVector(v, this.angularVelocityX * (double)this.step, this.angularVelocityY * (double)this.step, this.angularVelocityZ * (double)this.step);
    }
}

