/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.fancyeffects.expressions.common;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.PropertyExpressionType;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Particles - Rainbow mode")
@Description(value={"Get or set the rainbow mode of an effect", "    - You guessed it! this only works for colorable particles"})
@Syntaxes(value={"particle effect rainbow mode"})
@PropertyExpressionType(value={"string"})
@Examples(value={"set particle effect rainbow mode of \"%player%\" to true"})
public class ExprEffectRainbowMode
extends SimplePropertyExpression<String, Boolean> {
    public Boolean convert(String ent) {
        if (ent == null) {
            return null;
        }
        if (skDragonCore.fancyEffects().containsKey(ent)) {
            return skDragonCore.fancyEffects().get(ent).getEffect().rainbowMode();
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String ent = (String)this.getExpr().getSingle(e);
        if (ent == null) {
            return;
        }
        if (!skDragonCore.fancyEffects().containsKey(ent)) {
            return;
        }
        if (!skDragonCore.fancyEffects().get(ent).getEffect().getParticle().getParticle().hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
            skDragonCore.warn("The effect '" + ent + "' does not contain a colorable particle, rainbow mode not available");
            return;
        }
        Boolean b = (Boolean)delta[0];
        skDragonCore.fancyEffects().get(ent).getEffect().setRainbowMode(b);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    protected String getPropertyName() {
        return "set Rainbow Mode";
    }
}

