/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.fancyeffects.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import ud.skript.sashie.skDragon.particleEngine.fancyeffects.RunnableType;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleError;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Start particle effect")
@Description(value={"Starts a particle effect of a given id name.", "   - Using the async option makes the effect play in an asynchronous runnable", "   - Adding a delay makes the effect start later", "   - The effect will play only once unless you add the repeating option", "   - The repeating option will play infinitely unless the number of times option is used", "   - When using repeat the pulse is used to determine how fast between iterations"})
@Syntaxes(value={"(start|run) [async] particle effect %string%[ delayed by %-number% tick[s]][ repeat(ed|ing)[ %-number% times] with a pulse of %-number% tick[s]]"})
@Examples(value={"start particle effect \"%player%\"", "start async particle effect \"%player%\"", "start particle effect \"%player%\" delayed by 10 ticks", "start particle effect \"%player%\" repeating with a pulse of 1 tick", "start particle effect \"%player%\" repeating 5 times with a pulse of 0 ticks", "start async particle effect \"%player%\" delayed by 10 ticks repeating 5 times with a pulse of 5 ticks"})
public class EffStartParticleEffect
extends Effect {
    private String parsedSyntax;
    private Expression<String> name;
    private Expression<Number> inputDelay;
    private Expression<Number> inputRepeat;
    private Expression<Number> inputPulse;

    protected void execute(Event event) {
        String name = (String)this.name.getSingle(event);
        int finalDelay = SkriptHandler.inputInt(0, event, this.inputDelay);
        int finalRepeat = SkriptHandler.inputInt(-1, event, this.inputRepeat);
        int finalPulse = SkriptHandler.inputInt(2, event, this.inputPulse);
        if (skDragonCore.fancyEffects().containsKey(name)) {
            try {
                if (this.parsedSyntax.contains("async")) {
                    skDragonCore.fancyEffects().get(name).setAsynchronous(true);
                }
                RunnableType type = RunnableType.INSTANT;
                if (finalDelay > 0) {
                    type = RunnableType.DELAYED;
                    skDragonCore.fancyEffects().get(name).setTickDelay(finalDelay);
                }
                if (this.parsedSyntax.contains("repeat")) {
                    type = RunnableType.REPEATING;
                    skDragonCore.fancyEffects().get(name).setIterations(finalRepeat);
                    skDragonCore.fancyEffects().get(name).setTickPulse(finalPulse);
                }
                skDragonCore.fancyEffects().get(name).setRunnableType(type);
                skDragonCore.fancyEffects().get(name).start();
            }
            catch (ParticleError e) {
                e.printStackTrace();
            }
        } else {
            Skript.error((String)("No particle effect named '" + name + "' exists, register it first"));
        }
    }

    public String toString(Event event, boolean b) {
        return "Start Particle Effect";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.parsedSyntax = parseResult.expr;
        this.name = exprs[0];
        this.inputDelay = exprs[1];
        this.inputRepeat = exprs[2];
        this.inputPulse = exprs[3];
        int cfr_ignored_0 = exprs.length;
        return true;
    }
}

