/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.fancyeffects;

import java.io.Serializable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.fancyeffects.FancyEffect;
import ud.skript.sashie.skDragon.particleEngine.fancyeffects.RunnableType;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleError;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragonCore;

public abstract class FancyEffectManager
implements Serializable {
    private static final long serialVersionUID = -1404699272515296173L;
    protected double PI = Math.PI;
    protected double PI2 = Math.PI * 2;
    protected double degreesToRadians = this.PI / 180.0;
    public RunnableType type = RunnableType.INSTANT;
    protected long tickDelay = 0L;
    protected long tickPulse = 2L;
    private int iterations = 1;
    Boolean running = false;
    Boolean paused = false;
    Boolean pausedInPlace = false;
    Boolean isAsynchronous = false;
    transient Tracker tracker;
    protected FancyEffect effect = new FancyEffect();

    public boolean isRunning() {
        return this.running;
    }

    public FancyEffect getEffect() {
        return this.effect;
    }

    public void setEffect(FancyEffect effect) {
        this.effect = effect;
    }

    public void setAsynchronous(boolean isAsynchronous) {
        this.isAsynchronous = isAsynchronous;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public void setRunnableType(RunnableType type) {
        this.type = type;
    }

    public long getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(long tickDelay) {
        this.tickDelay = tickDelay;
    }

    public long getTickPulse() {
        return this.tickPulse;
    }

    public void setTickPulse(long tickPulse) {
        this.tickPulse = tickPulse;
    }

    public void start() throws ParticleError {
        if (!this.effect.getParticle().getParticle().isSupported()) {
            skDragonCore.error("The particle used is not supported by this version of bukkit/spigot");
            return;
        }
        if (this.effect.getStartLocation() == null) {
            skDragonCore.error("Location not provided");
            return;
        }
        if (this.isRunning()) {
            skDragonCore.error("Already running");
            return;
        }
        this.running = true;
        this.tracker = new Tracker();
        this.effect.setCurrentLocation(this.effect.getStartLocation());
        this.tracker.run();
    }

    public void stop() {
        this.running = false;
        this.tracker.task.cancel();
    }

    public void pause() {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = false;
        }
    }

    public void unpause() {
        if (this.isRunning()) {
            this.paused = false;
            this.pausedInPlace = false;
        }
    }

    public void pause(boolean inPlace) {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = inPlace;
        }
    }

    public int iterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public abstract void onRun();

    public void spawnParticle() {
        this.effect.getParticle().getParticle().display(this.effect.getParticle().getMaterial(), (byte)this.effect.getParticle().getMaterial().getId(), this.effect.getPlayers(), (Location)this.effect.getCurrentLocation(), this.effect.getParticle().getRange(), this.effect.rainbowMode(), this.effect.getParticle().getOffsetX(), this.effect.getParticle().getOffsetY(), this.effect.getParticle().getOffsetZ(), this.effect.getParticle().getSpeed(), this.effect.getParticle().getCount());
    }

    public void spawnParticle(Vector vector) {
        switch (this.effect.getParticleCount()) {
            case 1: {
                this.spawnParticles(this.effect.getParticle(), vector);
                break;
            }
            case 2: {
                this.spawnParticles(this.effect.getParticle(), vector);
                this.spawnParticles(this.effect.getParticle2(), vector);
                break;
            }
            case 3: {
                this.spawnParticles(this.effect.getParticle(), vector);
                this.spawnParticles(this.effect.getParticle2(), vector);
                this.spawnParticles(this.effect.getParticle3(), vector);
                break;
            }
            case 4: {
                this.spawnParticles(this.effect.getParticle(), vector);
                this.spawnParticles(this.effect.getParticle2(), vector);
                this.spawnParticles(this.effect.getParticle3(), vector);
                this.spawnParticles(this.effect.getParticle4(), vector);
            }
        }
    }

    private void spawnParticles(DragonParticle particle, Vector vector) {
        if (particle.getParticle().hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
            if (this.effect.randomColor()) {
                if (this.effect.rainbowMode()) {
                    particle.setOffsetY(RandomUtils.randomRangeFloat(0.0f, 255.0f));
                    particle.setOffsetZ(RandomUtils.randomRangeFloat(0.0f, 255.0f));
                } else {
                    particle.setOffsetXYZ(RandomUtils.randomRangeFloat(0.0f, 255.0f), RandomUtils.randomRangeFloat(0.0f, 255.0f), RandomUtils.randomRangeFloat(0.0f, 255.0f));
                }
            }
            if (particle.getCount() >= 2) {
                float cOffsetX = this.effect.getColorXoff();
                float cOffsetY = this.effect.getColorYoff();
                float cOffsetZ = this.effect.getColorZoff();
                int i = 0;
                while (i < particle.getCount()) {
                    if (cOffsetX > 0.0f) {
                        this.effect.setColorOffsetX(RandomUtils.randomRangeFloat(-cOffsetX, cOffsetX));
                    }
                    if (cOffsetY > 0.0f) {
                        this.effect.setColorOffsetY(RandomUtils.randomRangeFloat(-cOffsetY, cOffsetY));
                    }
                    if (cOffsetZ > 0.0f) {
                        this.effect.setColorOffsetZ(RandomUtils.randomRangeFloat(-cOffsetZ, cOffsetZ));
                    }
                    this.effect.setCurrentLocation(this.effect.getCurrentLocation().add(vector));
                    this.effect.setCurrentLocation(this.effect.getCurrentLocation().add(this.effect.getColorOffset()));
                    particle.displayColor(this.effect.getPlayers(), this.effect.getCurrentLocation(), this.effect.rainbowMode());
                    this.effect.setCurrentLocation(this.effect.getCurrentLocation().subtract(this.effect.getColorOffset()));
                    this.effect.setCurrentLocation(this.effect.getCurrentLocation().subtract(vector));
                    ++i;
                }
            } else {
                this.effect.setCurrentLocation(this.effect.getCurrentLocation().add(vector));
                particle.getParticle().display(particle.getMaterial(), (byte)particle.getMaterial().getId(), this.effect.getPlayers(), (Location)this.effect.getCurrentLocation(), particle.getRange(), this.effect.rainbowMode(), particle.getOffsetX(), particle.getOffsetY(), particle.getOffsetZ(), particle.getSpeed(), particle.getCount());
                this.effect.setCurrentLocation(this.effect.getCurrentLocation().subtract(vector));
            }
        } else {
            this.effect.setCurrentLocation(this.effect.getCurrentLocation().add(vector));
            particle.getParticle().display(particle.getMaterial(), (byte)particle.getMaterial().getId(), this.effect.getPlayers(), (Location)this.effect.getCurrentLocation(), particle.getRange(), this.effect.rainbowMode(), particle.getOffsetX(), particle.getOffsetY(), particle.getOffsetZ(), particle.getSpeed(), particle.getCount());
            this.effect.setCurrentLocation(this.effect.getCurrentLocation().subtract(vector));
        }
    }

    public void spawnParticle(List<Vector> vectors) {
        for (Vector vector : vectors) {
            this.spawnParticle(vector);
        }
    }

    public double wrapAngleRad(double angle) {
        if ((angle %= this.PI2) <= -this.PI) {
            return angle + this.PI2;
        }
        if (angle > this.PI) {
            return angle - this.PI2;
        }
        return angle;
    }

    class Tracker
    implements Runnable {
        BukkitTask task;
        int size = 0;

        public Tracker() {
            switch (FancyEffectManager.this.type) {
                case INSTANT: {
                    if (FancyEffectManager.this.isAsynchronous()) {
                        this.task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)skDragonCore.getInstance(), (Runnable)this);
                        break;
                    }
                    this.task = Bukkit.getScheduler().runTask((Plugin)skDragonCore.getInstance(), (Runnable)this);
                    break;
                }
                case DELAYED: {
                    if (FancyEffectManager.this.isAsynchronous()) {
                        this.task = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)skDragonCore.getInstance(), (Runnable)this, FancyEffectManager.this.getTickDelay());
                        break;
                    }
                    this.task = Bukkit.getScheduler().runTaskLater((Plugin)skDragonCore.getInstance(), (Runnable)this, FancyEffectManager.this.getTickDelay());
                    break;
                }
                case REPEATING: {
                    this.task = FancyEffectManager.this.isAsynchronous() ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.getInstance(), (Runnable)this, FancyEffectManager.this.getTickDelay(), FancyEffectManager.this.getTickPulse()) : Bukkit.getScheduler().runTaskTimer((Plugin)skDragonCore.getInstance(), (Runnable)this, FancyEffectManager.this.getTickDelay(), FancyEffectManager.this.getTickPulse());
                }
            }
        }

        @Override
        public void run() {
            if (FancyEffectManager.this.isRunning()) {
                if (!FancyEffectManager.this.paused.booleanValue()) {
                    FancyEffectManager.this.onRun();
                } else if (FancyEffectManager.this.pausedInPlace.booleanValue()) {
                    FancyEffectManager.this.spawnParticle();
                }
            }
            if (FancyEffectManager.this.type == RunnableType.REPEATING) {
                if (FancyEffectManager.this.iterations == -1) {
                    return;
                }
                ++this.size;
                if (this.size >= FancyEffectManager.this.effect.size()) {
                    this.size = 0;
                    FancyEffectManager fancyEffectManager = FancyEffectManager.this;
                    fancyEffectManager.iterations = fancyEffectManager.iterations - 1;
                }
                if (FancyEffectManager.this.iterations < 1) {
                    this.task.cancel();
                    FancyEffectManager.this.running = false;
                }
            } else {
                this.task.cancel();
                FancyEffectManager.this.running = false;
            }
        }
    }
}

