/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects.spawns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.effects.DragonEffect;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.DragonParticle;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.particleEngine.utils.enums.BlockColor;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;
import ud.skript.sashie.skDragonCore;

@Name(value="Spawn colored directional particles")
@Description(value={"Like material based directional particles but with a color spectrum based on different block types", "This color spectrum is spurcial... ", "shade(1-17) - from white most to black most shaded blocks", "red(1-13) - ends with orange", "green(1-15) - starts with yellow", "blue(1-24) - ends with violets", "rainbow - simulates what is done with normal redstone particle rainbow mode", "full(1-69) - lets you cycle between the full enum"})
@Syntaxes(value={"draw %number% (shade|red|green|blue|rainbow|full)[ scale %-number%] colo[u]red directional (blockdust|itemcrack) particle[s] at %objects% with direction %vector% and speed %number%[, offset %-number%, %-number%, %-number%][, id %-string%][, visibleTo %-players%][, visibleRange %-number%][, pulseDelay %-number%][, keepFor %-timespan%]"})
@Examples(value={"draw 2 shade scale 9 colored directional itemcrack particles at location of player with direction {_vector} and speed .6", "draw 2 red scale 3 colored directional itemcrack particles at location of player with direction {_vector} and speed .6", "draw 2 green scale 6 colored directional itemcrack particles at location of player with direction {_vector} and speed .6", "draw 2 blue scale 7 colored directional itemcrack particles at location of player with direction {_vector} and speed .6", "draw 2 rainbow colored directional itemcrack particles at location of player with direction {_vector} and speed .6, keepfor 15 seconds"})
public class EffSpawnParticleDirectionColor
extends DragonEffect {
    private Expression<Number> partCount;
    private Expression<Number> inputParticleColor;
    private Expression<?> entLoc;
    private Expression<Vector> inputDirection;
    private Expression<Number> inputSpeed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<String> inputIdName;
    private Expression<Player> inputPlayers;
    private Expression<Number> inputRange;
    private Expression<Number> inputPulseDelay;
    private Expression<Timespan> inputKeepDelay;
    private String parsedSyntax = "";
    private boolean rainbow = false;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.partCount = exprs[0];
        this.inputParticleColor = exprs[1];
        this.entLoc = exprs[2];
        this.inputDirection = exprs[3];
        this.inputSpeed = exprs[4];
        this.offX = exprs[5];
        this.offY = exprs[6];
        this.offZ = exprs[7];
        this.inputIdName = exprs[8];
        this.inputPlayers = exprs[9];
        this.inputRange = exprs[10];
        this.inputPulseDelay = exprs[11];
        this.inputKeepDelay = exprs[12];
        this.parsedSyntax = parseResult.expr;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Colored Directional Particles";
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        return null;
    }

    @Override
    protected void exec(@Nullable Event e) {
        final int count = SkriptHandler.inputParticleCount(e, this.partCount);
        ParticleEffect inputParticle = ParticleEffect.happyvillager;
        Material dataMat = Material.DIRT;
        byte dataID = 0;
        BlockColor color = BlockColor.WHITE1;
        if (this.parsedSyntax.contains("blockdust")) {
            inputParticle = ParticleEffect.blockdust;
        } else if (this.parsedSyntax.contains("itemcrack")) {
            inputParticle = ParticleEffect.itemcrack;
        }
        if (this.parsedSyntax.contains(" shade")) {
            color = BlockColor.shade(SkriptHandler.inputInt(1, e, this.inputParticleColor));
            dataMat = color.getType();
            dataID = color.getData();
        } else if (this.parsedSyntax.contains(" red")) {
            color = BlockColor.red(SkriptHandler.inputInt(1, e, this.inputParticleColor));
            dataMat = color.getType();
            dataID = color.getData();
        } else if (this.parsedSyntax.contains(" green")) {
            color = BlockColor.green(SkriptHandler.inputInt(1, e, this.inputParticleColor));
            dataMat = color.getType();
            dataID = color.getData();
        } else if (this.parsedSyntax.contains(" blue")) {
            color = BlockColor.blue(SkriptHandler.inputInt(1, e, this.inputParticleColor));
            dataMat = color.getType();
            dataID = color.getData();
        } else if (this.parsedSyntax.contains(" rainbow")) {
            this.rainbow = true;
        } else if (this.parsedSyntax.contains(" full")) {
            color = BlockColor.full(SkriptHandler.inputInt(1, e, this.inputParticleColor));
            dataMat = color.getType();
            dataID = color.getData();
        }
        final Object[] center = this.entLoc.getAll(e);
        final List<Player> players = SkriptHandler.inputPlayers(e, this.inputPlayers);
        final float offsetX = SkriptHandler.inputParticleOffset(e, this.offX);
        final float offsetY = SkriptHandler.inputParticleOffset(e, this.offY);
        final float offsetZ = SkriptHandler.inputParticleOffset(e, this.offZ);
        Vector direction = SkriptHandler.inputVector(e, this.inputDirection);
        float speed = SkriptHandler.inputFloat(0.0f, e, this.inputSpeed);
        long finalPulseTick = SkriptHandler.inputPulseTick(e, this.inputPulseDelay);
        long finalKeepDelay = SkriptHandler.inputKeepDelay(e, this.inputKeepDelay);
        double range = SkriptHandler.inputDouble(32.0, e, this.inputRange);
        final String idName = this.inputIdName != null ? (String)this.inputIdName.getSingle(e) : "&dot-" + Math.random() + "-&dot";
        final DragonParticle particle = new DragonParticle();
        particle.setRange(range);
        particle.setDirection(direction);
        particle.setSpeed(speed);
        particle.setParticle(inputParticle);
        particle.setMaterial(dataMat);
        particle.setMaterialId(dataID);
        if (finalPulseTick > finalKeepDelay) {
            finalPulseTick = finalKeepDelay;
        }
        if (!EffectsLib.arraylist.containsKey(idName)) {
            int dotGo = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float finalOffsetX;
                float finalOffsetY;
                float finalOffsetZ;
                int boop;
                {
                    this.finalOffsetX = f;
                    this.finalOffsetY = f2;
                    this.finalOffsetZ = f3;
                    this.boop = 1;
                }

                @Override
                public void run() {
                    Object[] objectArray = center;
                    int n = center.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object loc = objectArray[n2];
                        Location location = EffSpawnParticleDirectionColor.getLocation(loc);
                        if (EffSpawnParticleDirectionColor.this.rainbow) {
                            this.boop = BlockColor.simpleRainbowHelper(this.boop);
                            try {
                                particle.setMaterial(BlockColor.rainbow(this.boop).getType());
                                particle.setMaterialId(BlockColor.rainbow(this.boop).getData());
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        int i = 0;
                        while (i < count) {
                            if (offsetX > 0.0f) {
                                this.finalOffsetX = RandomUtils.randomRangeFloat(-offsetX, offsetX);
                            }
                            if (offsetY > 0.0f) {
                                this.finalOffsetY = RandomUtils.randomRangeFloat(-offsetY, offsetY);
                            }
                            if (offsetZ > 0.0f) {
                                this.finalOffsetZ = RandomUtils.randomRangeFloat(-offsetZ, offsetZ);
                            }
                            location.add((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            particle.displayDirectional(idName, players, location);
                            location.subtract((double)this.finalOffsetX, (double)this.finalOffsetY, (double)this.finalOffsetZ);
                            ++i;
                        }
                        ++n2;
                    }
                }
            }, 0L, finalPulseTick).getTaskId();
            EffectsLib.arraylist.put(idName, dotGo);
            EffectsLib.stopEffectDelayed(finalKeepDelay, dotGo, idName);
        }
    }
}

