/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import ud.skript.sashie.skDragon.particleEngine.maths.EffectsLib;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.SkriptHandler;
import ud.skript.sashie.skDragon.registration.annotations.Description;
import ud.skript.sashie.skDragon.registration.annotations.Examples;
import ud.skript.sashie.skDragon.registration.annotations.Name;
import ud.skript.sashie.skDragon.registration.annotations.Syntaxes;

@Name(value="drawComplexSpiral ")
@Description(value={"Draws a spiral that follows the player or plays at a location. New Syntax as of v0.06.0-BETA "})
@Syntaxes(value={"draw[Complex]Spiral particle %string%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %object%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], clockwise %boolean%, scan %boolean%, radius %number%, density %number%, height %number%, effectMod %number%, start %number%, visibleRange %number%[, xR[otation] %-number%, yR[otation] %-number%, zR[otation] %-number%][, dis[placement]X %-number%, dis[placement]Y %-number%, dis[placement]Z %-number%][, tps %-number%, second %-number%]"})
@Examples(value={"drawComplexSpiral particle \"redstone\", center player, id \"%player%\", rainbowMode true, clockwise true, scan true, radius 1.5, density 50, height 6, effectMod .05, start 0, visibleRange 30"})
public class EffComplexSpiral
extends Effect {
    private Expression<String> particleString;
    private Expression<ItemStack> inputParticleData;
    private Expression<Number> speed;
    private Expression<Number> offX;
    private Expression<Number> offY;
    private Expression<Number> offZ;
    private Expression<?> entLoc;
    private Expression<String> idName;
    private Expression<Boolean> singlePlayer;
    private Expression<?> player;
    private Expression<Boolean> rainbMode;
    private Expression<Boolean> clockwise;
    private Expression<Boolean> scan;
    private Expression<Number> height;
    private Expression<Number> effectMod;
    private Expression<Number> range;
    private Expression<Number> xRot;
    private Expression<Number> yRot;
    private Expression<Number> zRot;
    private Expression<Number> radius;
    private Expression<Long> cDensity;
    private Expression<Number> displaceX;
    private Expression<Number> displaceY;
    private Expression<Number> displaceZ;
    private Expression<Number> step;
    private Expression<Long> ticks;
    private Expression<Long> seconds;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.particleString = exprs[0];
        this.inputParticleData = exprs[1];
        this.speed = exprs[2];
        this.offX = exprs[3];
        this.offY = exprs[4];
        this.offZ = exprs[5];
        this.entLoc = exprs[6];
        this.idName = exprs[7];
        this.singlePlayer = exprs[8];
        this.player = exprs[9];
        this.rainbMode = exprs[10];
        this.clockwise = exprs[11];
        this.scan = exprs[12];
        this.radius = exprs[13];
        this.cDensity = exprs[14];
        this.height = exprs[15];
        this.effectMod = exprs[16];
        this.step = exprs[17];
        this.range = exprs[18];
        this.xRot = exprs[19];
        this.yRot = exprs[20];
        this.zRot = exprs[21];
        this.displaceX = exprs[22];
        this.displaceY = exprs[23];
        this.displaceZ = exprs[24];
        this.ticks = exprs[25];
        this.seconds = exprs[26];
        Class center = this.entLoc.getReturnType();
        if (center instanceof Entity) {
            return true;
        }
        if (center instanceof Location) {
            return true;
        }
        if (center instanceof Object) {
            return true;
        }
        Skript.error((String)(String.valueOf(this.entLoc.toString()) + " is neither an entity nor a location."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        return false;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "drawComplexSpiral particle %string%[, material %-itemstack%][, speed %-number%][, ([offset]XYZ|RGB) %-number%, %-number%, %-number%], center %entity/location%, id %string%[, isSingle %-boolean%, %-player%][, r[ainbow]M[ode] %-boolean%], clockwise %boolean%, scan %boolean%, radius %number%, density %number%, height %number%, effectMod %number%, start %number%, visibleRange %number%[, xR[otation] %-number%, yR[otation] %-number%, zR[otation] %-number%][, dis[placement]X %-number%, dis[placement]Y %-number%, dis[placement]Z %-number%][, tps %-number%, second %-number%]";
    }

    protected void execute(@Nullable Event e) {
        String particle = "limeglassparticle";
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        double xRotation = 0.0;
        double yRotation = 0.0;
        double zRotation = 0.0;
        double disX = 0.0;
        double disY = 0.0;
        double disZ = 0.0;
        float finalSpeed = 0.0f;
        float finalHeight = 6.0f;
        float finalEffectMod = 0.0f;
        Long finalDelayTicks = 0L;
        Long finalDelayBySec = 0L;
        if (this.particleString != null && ParticleEffect.NAME_MAP.containsKey(((String)this.particleString.getSingle(e)).toLowerCase())) {
            particle = ((String)this.particleString.getSingle(e)).toLowerCase();
        }
        Object center = this.entLoc.getSingle(e);
        String idName = (String)this.idName.getSingle(e);
        Long cD = (Long)this.cDensity.getSingle(e);
        Integer finalCircleDensity = cD != null ? Integer.valueOf(cD.intValue()) : null;
        float finalStep = ((Number)this.step.getSingle(e)).floatValue();
        double visibleRange = ((Number)this.range.getSingle(e)).doubleValue();
        Player p = null;
        boolean isSinglePlayer = false;
        if (this.singlePlayer != null && this.singlePlayer.getSingle(e) != null && this.player != null && this.player.getSingle(e) != null) {
            isSinglePlayer = (Boolean)this.singlePlayer.getSingle(e);
            p = (Player)this.player.getSingle(e);
        }
        boolean rainbowMode = false;
        if (this.rainbMode != null && this.rainbMode.getSingle(e) != null) {
            rainbowMode = (Boolean)this.rainbMode.getSingle(e);
        }
        boolean finalClockwise = (Boolean)this.clockwise.getSingle(e);
        boolean finalScan = (Boolean)this.scan.getSingle(e);
        Number radiusInt = (Number)this.radius.getSingle(e);
        float radius = radiusInt.floatValue();
        if (this.height != null) {
            finalHeight = ((Number)this.height.getSingle(e)).floatValue();
        }
        if (this.effectMod != null) {
            finalEffectMod = ((Number)this.effectMod.getSingle(e)).floatValue();
        }
        if (this.speed != null) {
            finalSpeed = ((Number)this.speed.getSingle(e)).floatValue();
        }
        if (this.offX != null && this.offY != null && this.offZ != null) {
            offsetX = ((Number)this.offX.getSingle(e)).intValue();
            offsetY = ((Number)this.offY.getSingle(e)).intValue();
            offsetZ = ((Number)this.offZ.getSingle(e)).intValue();
        }
        if (this.displaceX != null && this.displaceY != null && this.displaceZ != null) {
            disX = ((Number)this.displaceX.getSingle(e)).doubleValue();
            disY = ((Number)this.displaceY.getSingle(e)).doubleValue();
            disZ = ((Number)this.displaceZ.getSingle(e)).doubleValue();
        }
        if (this.xRot != null && this.yRot != null && this.zRot != null) {
            xRotation = ((Number)this.xRot.getSingle(e)).doubleValue();
            yRotation = ((Number)this.yRot.getSingle(e)).doubleValue();
            zRotation = ((Number)this.zRot.getSingle(e)).doubleValue();
        }
        if (this.ticks != null) {
            finalDelayTicks = (Long)this.ticks.getSingle(e);
        }
        if (this.seconds != null) {
            finalDelayBySec = (Long)this.seconds.getSingle(e);
        }
        Material dataMat = SkriptHandler.inputParticleDataMat(e, this.inputParticleData);
        byte dataID = SkriptHandler.inputParticleDataID(e, this.inputParticleData);
        EffectsLib.drawComplexSpiral(particle, dataMat, dataID, finalSpeed, offsetX, offsetY, offsetZ, center, idName, isSinglePlayer, p, rainbowMode, finalClockwise, finalScan, visibleRange, xRotation, yRotation, zRotation, radius, finalHeight, finalEffectMod, finalCircleDensity, disX, disY, disZ, finalStep, finalDelayTicks, finalDelayBySec);
    }
}

