/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DynamicLocation
extends Location {
    public static List<String> Moving = new ArrayList<String>();
    public static List<String> Falling = new ArrayList<String>();
    final HashMap<UUID, Location> lastLocation = new HashMap();
    private Entity entity = null;
    private boolean dynamic = false;
    private float epsilon = 0.05f;
    private float epsilonNoSneak = 0.1f;

    public DynamicLocation(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public DynamicLocation(Entity entity) {
        super(entity.getWorld(), entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), entity.getLocation().getYaw(), entity.getLocation().getPitch());
        this.entity = entity;
        this.dynamic = true;
    }

    public DynamicLocation update() {
        if (this.dynamic) {
            this.setX(this.entity.getLocation().getX());
            this.setY(this.entity.getLocation().getY());
            this.setZ(this.entity.getLocation().getZ());
            this.setYaw(this.entity.getLocation().getYaw());
            this.setPitch(this.entity.getLocation().getPitch());
        }
        return this;
    }

    public void MovementCheck() {
        if (this.dynamic) {
            Location current = this.entity.getLocation();
            Location last = this.lastLocation.get(this.entity.getUniqueId());
            if (this.lastLocation.get(this.entity.getUniqueId()) == null) {
                this.lastLocation.put(this.entity.getUniqueId(), current);
                last = this.lastLocation.get(this.entity.getUniqueId());
            }
            this.lastLocation.put(this.entity.getUniqueId(), this.entity.getLocation());
            if (last.getY() > current.getY()) {
                if (last.distanceSquared(current) > (double)(this.epsilon * this.epsilon) && !Falling.contains(this.entity.getName())) {
                    Falling.add(this.entity.getName());
                }
            } else if (Falling.contains(this.entity.getName())) {
                Falling.remove(this.entity.getName());
            }
            if (last.getX() != current.getX() || last.getZ() != current.getZ()) {
                if (last.distanceSquared(current) > (double)(this.epsilonNoSneak * this.epsilonNoSneak) && !Moving.contains(this.entity.getName())) {
                    Moving.add(this.entity.getName());
                }
            } else if (Moving.contains(this.entity.getName())) {
                Moving.remove(this.entity.getName());
            }
        }
    }

    public static boolean isMoving(Player p) {
        return Moving.contains(p.getName());
    }

    public static boolean isFalling(Player p) {
        return Falling.contains(p.getName());
    }

    public boolean needsUpdate() {
        return this.dynamic && this.distanceSquared(this.entity.getLocation()) > (double)(this.epsilon * this.epsilon);
    }

    public boolean needsUpdate(long ticks) {
        if (this.dynamic) {
            double d = this.distanceSquared(this.entity.getLocation());
            long l = ticks > 0L ? ticks : 1L;
            if (d > (double)(this.epsilon * this.epsilon / (float)l)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasMoved() {
        return this.needsUpdate();
    }

    public boolean hasMoved(long ticks) {
        return this.needsUpdate(ticks);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public float getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(float epsilon) {
        this.epsilon = epsilon;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Vector getVector() {
        return new Vector(this.getX(), this.getY(), this.getZ());
    }

    public static DynamicLocation init(Object center) {
        if (center instanceof Entity) {
            return new DynamicLocation((Entity)center);
        }
        if (center instanceof Location) {
            return new DynamicLocation((Location)center);
        }
        throw new IllegalArgumentException("[skDragon] The object is not of type Entity or Location");
    }
}

