/*
 * Decompiled with CFR 0.152.
 */
package ud.skript.sashie.skDragon.particleEngine.maths;

import ch.njol.skript.Skript;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ud.skript.sashie.skDragon.particleEngine.utils.MathUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.ParticleEffect;
import ud.skript.sashie.skDragon.particleEngine.utils.RandomUtils;
import ud.skript.sashie.skDragon.particleEngine.utils.SchedulingManager;
import ud.skript.sashie.skDragon.particleEngine.utils.VectorUtils;
import ud.skript.sashie.skDragonCore;

public class EffectsLib {
    public static final HashMap<String, Integer> arraylist = new HashMap();
    public static final HashMap<String, Integer> arraylist2 = new HashMap();
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static int taskID;

    public static void stopEffect(String idName) {
        if (arraylist.containsKey(idName)) {
            Bukkit.getScheduler().cancelTask(arraylist.get(idName).intValue());
            arraylist.remove(idName);
        }
    }

    public static void stopItemEffect(String idName) {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!arraylist.containsKey(String.valueOf(entity.getUniqueId().toString()) + idName) || !skDragonCore.notInUseItems.contains(entity.getUniqueId())) continue;
                arraylist.remove(String.valueOf(entity.getUniqueId().toString()) + idName);
                skDragonCore.notInUseItems.remove(entity.getUniqueId());
                entity.remove();
            }
        }
    }

    public static void stopEffect2(String idName) {
        if (arraylist2.containsKey(idName)) {
            Bukkit.getScheduler().cancelTask(arraylist2.get(idName).intValue());
            arraylist2.remove(idName);
        }
    }

    public static boolean EffectActive(String idName) {
        return !arraylist.containsKey(idName);
    }

    public static Location getLocation(Object location) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return new Location(((Location)location).getWorld(), ((Location)location).getX(), ((Location)location).getY(), ((Location)location).getZ(), ((Location)location).getYaw(), ((Location)location).getPitch());
        }
        return null;
    }

    public static Location getLocation(Object location, String idName) {
        if (location instanceof Entity) {
            return ((Entity)location).getLocation();
        }
        if (location instanceof Location) {
            return new Location(((Location)location).getWorld(), ((Location)location).getX(), ((Location)location).getY(), ((Location)location).getZ(), ((Location)location).getYaw(), ((Location)location).getPitch());
        }
        skDragonCore.sendExLog("The location used is invalid or null", idName, 3);
        EffectsLib.stopItemEffect(idName);
        EffectsLib.stopEffect(idName);
        return null;
    }

    public static void foundNull(Location location, String idName, Exception ex) {
        if (location != null) {
            skDragonCore.sendExLog("Null found, effect stopped", idName, 3);
            ex.printStackTrace();
        }
    }

    public static void drawSimpleHalo(final String particle, final Object center, final Material dataMat, final byte dataID, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final float speed, final int particleDensity, final double visibleRange, final float offsetX, final float offsetY, final float offsetZ, long delayTicks, long delayBySecond, final boolean solid) {
        if (!arraylist.containsKey(idName)) {
            int normalHalo = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float step = 0.0f;
                public float hue;
                final double angle;
                Location location;
                {
                    this.angle = (float)Math.PI / (float)n;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(0.0, 2.05, 0.0);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        if (solid) {
                            for (Location loc : EffectsLib.getCircle(this.location, 0.3, particleDensity)) {
                                ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, loc, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            }
                        } else {
                            Vector v = new Vector(Math.cos(this.angle * (double)this.step) * (double)0.3f, 0.0, Math.sin(this.angle * (double)this.step) * (double)0.3f);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.step += 1.0f;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, normalHalo);
        }
    }

    public static void drawComplexCircle(final String particle, final Material dataMat, final byte dataID, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean enableRotation, final float radius, final float speed, final int particleDensity, float steps, final double visibleRange, final double xRotation, final double yRotation, final double zRotation, final float offsetX, final float offsetY, final float offsetZ, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int circle = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(steps){
                public double angularVelocityX = 0.015707964077591896;
                public double angularVelocityY = 0.018479958176612854;
                public double angularVelocityZ = 0.02026834f;
                public float step;
                public float hue;
                Vector v;
                Location location;
                {
                    this.step = f;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY + 1.0, disZ);
                        double angle = this.step * ((float)Math.PI * 2 / (float)particleDensity);
                        this.v = new Vector();
                        this.v.setX(Math.cos(angle) * (double)radius);
                        this.v.setZ(Math.sin(angle) * (double)radius);
                        VectorUtils.rotateVector(this.v, xRotation, yRotation, zRotation);
                        if (enableRotation) {
                            VectorUtils.rotateVector(this.v, this.angularVelocityX * (double)this.step, this.angularVelocityY * (double)this.step, this.angularVelocityZ * (double)this.step);
                        }
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.step += 1.0f;
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, circle);
        }
    }

    public static void drawAtom(final String particle, final Material dataMat, final byte dataID, final float speed, final String particle2, final Material dataMat2, final byte dataID2, final float speed2, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final float innerRadius, final int innerParticles, final int orbitParticles, final int orbitalCount, float steps, final double visibleRange, final double rotations, final float offsetX, final float offsetY, final float offsetZ, final float offsetX2, final float offsetY2, final float offsetZ2, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int atom = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(steps){
                public double angularVelocity = 0.07853981852531433;
                public float step;
                public float hue;
                Location location;
                {
                    this.step = f;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY + 3.0, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        int i = 0;
                        while (i < innerParticles) {
                            Vector v = RandomUtils.getRandomVector().multiply(0.5 * (double)innerRadius);
                            ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                            this.location.subtract(v);
                            ++i;
                        }
                        i = 0;
                        while (i < orbitParticles) {
                            double angle = (double)this.step * this.angularVelocity;
                            int j = 0;
                            while (j < orbitalCount) {
                                double xRotation = (float)Math.PI / (float)orbitalCount * (float)j;
                                Vector v = new Vector();
                                v.setX(Math.sin(angle) * (0.6 + (double)innerRadius));
                                v.setY(Math.cos(angle) * (0.6 + (double)innerRadius));
                                VectorUtils.rotateAroundAxisX(v, xRotation);
                                VectorUtils.rotateAroundAxisY(v, rotations);
                                ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                this.location.subtract(v);
                                ++j;
                            }
                            this.step += 1.0f;
                            ++i;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, atom);
        }
    }

    public static void drawArc(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final Object getTarget, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final int particleDensity, final float height, final float pitchMuliplier, final double visibleRange, final double disX, final double disY, final double disZ, final double disX2, final double disY2, final double disZ2, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int arc = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                int step = 0;
                public float hue;
                Location location;
                Location target;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.target = EffectsLib.getLocation(getTarget, idName);
                        if (this.location == null || this.target == null) {
                            return;
                        }
                        this.location.add(disX, disY, disZ);
                        this.target.add(disX2, disY2, disZ2);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        Vector link = this.target.toVector().subtract(this.location.toVector());
                        float length = (float)link.length();
                        float pitch = (float)((double)(pitchMuliplier * height) / Math.pow(length, 2.0));
                        int i = 0;
                        while (i < particleDensity) {
                            Vector v = link.clone().normalize().multiply(length * (float)i / (float)particleDensity);
                            float x = (float)i / (float)particleDensity * length - length / 2.0f;
                            float y = (float)((double)(-pitch) * Math.pow(x, 2.0) + (double)height);
                            this.location.add(v).add(0.0, (double)y, 0.0);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(0.0, (double)y, 0.0).subtract(v);
                            ++this.step;
                            ++i;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, arc);
        }
    }

    public static void drawDot(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean isFacing, final float faceAngle, final float radius, final double xRotation, final double yRotation, final double zRotation, final double disX, final double disY, final double disZ, final double visibleRange, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int simpleDot = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public float hue;
                Location location;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(0.0 + disX, (double)0.3f + disY, 0.0 + disZ);
                        double inc = 6.2831854820251465;
                        double angle = 1.0 * inc;
                        Vector v = new Vector();
                        v.setX(Math.cos(angle) * (double)radius);
                        v.setZ(Math.sin(angle) * (double)radius);
                        VectorUtils.rotateVector(v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        if (isFacing) {
                            this.location.setPitch(0.0f);
                            this.location.add(this.location.getDirection().multiply(-0.2));
                            Location loc1R = this.location.clone();
                            loc1R.setYaw(loc1R.getYaw() + faceAngle);
                            Location loc2R = loc1R.clone().add(loc1R.getDirection().multiply(1));
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, loc2R.add(0.0, 0.0, 0.0), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        } else {
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, simpleDot);
        }
    }

    public static void drawComplexSpiral(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean clockwise, final boolean scan, final double visibleRange, final double xRotation, final double yRotation, final double zRotation, final float radius, final float height, final float effectMod, final int circleDensity, final double disX, final double disY, final double disZ, float steps, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int complexSpiral = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(steps){
                float step;
                private float hue;
                float i;
                boolean up;
                Vector v;
                Location location;
                {
                    this.step = f;
                    this.up = true;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        double angle = (float)Math.PI * 2 / (float)circleDensity * this.step;
                        double y = 0.3 * (double)this.i;
                        if (!clockwise) {
                            this.v = new Vector(Math.sin(angle) * (double)radius, y, Math.cos(angle) * (double)radius);
                        }
                        if (clockwise) {
                            this.v = new Vector(Math.cos(angle) * (double)radius, y, Math.sin(angle) * (double)radius);
                        }
                        VectorUtils.rotateVector(this.v, xRotation, yRotation, zRotation);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.step += 1.0f;
                        if (scan) {
                            if (this.i > height) {
                                this.up = false;
                            } else if (this.i < 0.0f) {
                                this.up = true;
                            }
                        } else {
                            if (this.i > height) {
                                this.i = 0.0f;
                            }
                            if (this.i < 0.0f) {
                                this.i = height;
                            }
                        }
                        if (this.up) {
                            this.i += effectMod;
                        }
                        if (!this.up) {
                            this.i -= effectMod;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, complexSpiral);
        }
    }

    public static void drawBand(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final boolean rainbowMode, final double visibleRange, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond, final Player player) {
        if (!arraylist.containsKey(idName)) {
            int band = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                private float hue;
                Location location;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        int i = 0;
                        while (i < 15) {
                            this.location.setY(this.location.getY() + 0.1);
                            if (rainbowMode) {
                                this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                            }
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            ++i;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, band);
        }
    }

    public static void drawNyanBand(final Object center, final String idName, final boolean isSinglePlayer, final double visibleRange, long delayTicks, long delayBySecond, final Player player) {
        if (!arraylist.containsKey(idName)) {
            int rainbowband = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                Location location;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        int i = 0;
                        while (i < 15) {
                            ParticleEffect.valueOf("redstone").display(player, this.location, visibleRange, isSinglePlayer, i);
                            this.location.setY(this.location.getY() + 0.1);
                            ++i;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, rainbowband);
        }
    }

    public static void drawImage(final File file, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean enableRotation, final Plane plane, int pixelStepX, int pixelStepY, long scaleSize, final double visibleRange, final double xRotation, final double yRotation, final double zRotation, double disX, double disY, double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int colorImage = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(pixelStepX, pixelStepY, scaleSize){
                int stepX;
                int stepY;
                float size;
                double angularVelocityX;
                double angularVelocityY;
                double angularVelocityZ;
                BufferedImage image;
                boolean isGif;
                File gifFile;
                int step;
                int rotationStep;
                int delay;
                Location location;
                boolean invert;
                {
                    this.stepX = n;
                    this.stepY = n2;
                    this.size = 1.0f / (float)l;
                    this.angularVelocityX = 0.015707964077591896;
                    this.angularVelocityY = 0.018479958176612854;
                    this.angularVelocityZ = 0.02026834f;
                    this.image = null;
                    this.isGif = false;
                    this.gifFile = null;
                    this.step = 0;
                    this.rotationStep = 0;
                    this.delay = 0;
                    this.invert = false;
                }

                @Override
                public void run() {
                    try {
                        if (this.image == null && file != null) {
                            try {
                                this.image = ImageIO.read(file);
                                this.isGif = file.getName().endsWith(".gif");
                                this.gifFile = file;
                            }
                            catch (Exception ex) {
                                Skript.warning((String)"[skDragon] Error: Invalid file used, make sure the image is in /plugins/skDragon/");
                                this.image = null;
                            }
                        }
                        if (this.image == null) {
                            EffectsLib.stopEffect(idName);
                            Skript.warning((String)"[skDragon] Error: The image failed to load, try another? :c");
                            return;
                        }
                        if (this.isGif) {
                            try {
                                this.image = this.getImg(this.step);
                            }
                            catch (IOException e) {
                                Skript.warning((String)"[skDragon] Error: The .gif failed to load..");
                                e.printStackTrace();
                            }
                            if (this.delay == 5) {
                                ++this.step;
                                this.delay = 0;
                            }
                            ++this.delay;
                        }
                        this.location = EffectsLib.getLocation(center, idName);
                        int y = 0;
                        while (y < this.image.getHeight()) {
                            int x = 0;
                            while (x < this.image.getWidth()) {
                                int clr = this.image.getRGB(x, y);
                                if ((this.invert || clr != 0 && clr != 0xFFFFFF) && (!this.invert || clr == 0 && clr != 0xFFFFFF)) {
                                    Vector v = new Vector((float)this.image.getWidth() / 2.0f - (float)x, (float)this.image.getHeight() / 2.0f - (float)y, 0.0f).multiply(this.size);
                                    VectorUtils.rotateVector(v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                                    if (enableRotation) {
                                        double rotX = 0.0;
                                        double rotY = 0.0;
                                        double rotZ = 0.0;
                                        switch (plane) {
                                            case X: {
                                                rotX = this.angularVelocityX * (double)this.rotationStep;
                                                break;
                                            }
                                            case Y: {
                                                rotY = this.angularVelocityY * (double)this.rotationStep;
                                                break;
                                            }
                                            case Z: {
                                                rotZ = this.angularVelocityZ * (double)this.rotationStep;
                                                break;
                                            }
                                            case XY: {
                                                rotX = this.angularVelocityX * (double)this.rotationStep;
                                                rotY = this.angularVelocityY * (double)this.rotationStep;
                                                break;
                                            }
                                            case XZ: {
                                                rotX = this.angularVelocityX * (double)this.rotationStep;
                                                rotZ = this.angularVelocityZ * (double)this.rotationStep;
                                                break;
                                            }
                                            case XYZ: {
                                                rotX = this.angularVelocityX * (double)this.rotationStep;
                                                rotY = this.angularVelocityY * (double)this.rotationStep;
                                                rotZ = this.angularVelocityZ * (double)this.rotationStep;
                                                break;
                                            }
                                            case YZ: {
                                                rotY = this.angularVelocityY * (double)this.rotationStep;
                                                rotZ = this.angularVelocityZ * (double)this.rotationStep;
                                            }
                                        }
                                        VectorUtils.rotateVector(v, rotX, rotY, rotZ);
                                    }
                                    int r = new Color(this.image.getRGB(x, y)).getRed();
                                    int g = new Color(this.image.getRGB(x, y)).getGreen();
                                    int b = new Color(this.image.getRGB(x, y)).getBlue();
                                    ParticleEffect.valueOf("redstone").display(this.location.add(v), visibleRange, isSinglePlayer, player, r, g, b);
                                    this.location.subtract(v);
                                }
                                x += this.stepX;
                            }
                            y += this.stepY;
                        }
                        ++this.rotationStep;
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }

                private BufferedImage getImg(int s) throws IOException {
                    ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                    ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
                    ImageInputStream in = ImageIO.createImageInputStream(this.gifFile);
                    reader.setInput(in);
                    int i = 0;
                    int count = reader.getNumImages(true);
                    while (i < count) {
                        BufferedImage image = reader.read(i);
                        images.add(image);
                        ++i;
                    }
                    if (this.step >= reader.getNumImages(true)) {
                        this.step = 0;
                        return (BufferedImage)images.get(s - 1);
                    }
                    reader.dispose();
                    in.close();
                    return (BufferedImage)images.get(s);
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, colorImage);
        }
    }

    public static void drawBreath(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final float finalArcPitch, final int finalArcs, final int finalParticleCount, final int finalStepPerIteration, final float finalLength, final double visibleRange, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int breath = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                protected int step = 0;
                protected final List<Float> rndF;
                protected final List<Double> rndAngle;
                Location location;
                public float hue;
                {
                    this.rndF = new ArrayList<Float>(n);
                    this.rndAngle = new ArrayList<Double>(n);
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, 1.475 + disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        int j = 0;
                        while (j < finalStepPerIteration) {
                            if (this.step % finalParticleCount == 0) {
                                this.rndF.clear();
                                this.rndAngle.clear();
                            }
                            while (this.rndF.size() < finalArcs) {
                                this.rndF.add(Float.valueOf(RandomUtils.random.nextFloat()));
                            }
                            while (this.rndAngle.size() < finalArcs) {
                                this.rndAngle.add(RandomUtils.getRandomAngle());
                            }
                            int i = 0;
                            while (i < finalArcs) {
                                float pitch = this.rndF.get(i).floatValue() * 2.0f * finalArcPitch - finalArcPitch;
                                float x = (float)(this.step % finalParticleCount) * finalLength / (float)finalParticleCount;
                                float y = (float)((double)pitch * Math.pow(x, 2.0));
                                Vector v = new Vector(x, y, 0.0f);
                                VectorUtils.rotateAroundAxisX(v, this.rndAngle.get(i));
                                VectorUtils.rotateAroundAxisZ(v, -this.location.getPitch() * ((float)Math.PI / 180));
                                VectorUtils.rotateAroundAxisY(v, -(this.location.getYaw() + 90.0f) * ((float)Math.PI / 180));
                                ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                this.location.subtract(v);
                                ++i;
                            }
                            ++this.step;
                            ++j;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, breath);
        }
    }

    public static void drawCylinder(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean enableRotation, final boolean solid, final float radius, final int finalParticleCount, final float height, float ratio, final double visibleRange, double xRotation, double yRotation, double zRotation, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int cylinder = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(ratio){
                public double angularVelocityX = 0.015707964077591896;
                public double angularVelocityY = 0.018479958176612854;
                public double angularVelocityZ = 0.02026834f;
                public double rotationX;
                public double rotationY;
                public double rotationZ;
                protected int step = 0;
                float sideRatio;
                Location location;
                public float hue;
                {
                    this.sideRatio = f;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        if (this.sideRatio == 0.0f) {
                            float grounds = 9.869605f * radius * 2.0f;
                            float side = (float)Math.PI * 2 * radius * height;
                            this.sideRatio = side / (side + grounds);
                        }
                        Random r = RandomUtils.random;
                        double xRotation = this.rotationX;
                        double yRotation = this.rotationY;
                        double zRotation = this.rotationZ;
                        if (enableRotation) {
                            xRotation += (double)this.step * this.angularVelocityX;
                            yRotation += (double)this.step * this.angularVelocityY;
                            zRotation += (double)this.step * this.angularVelocityZ;
                        }
                        int i = 0;
                        while (i < finalParticleCount) {
                            float multi = solid ? r.nextFloat() : 1.0f;
                            Vector v = RandomUtils.getRandomCircleVector().multiply(radius);
                            if (r.nextFloat() <= this.sideRatio) {
                                v.multiply(multi);
                                v.setY((r.nextFloat() * 2.0f - 1.0f) * (height / 2.0f));
                            } else {
                                v.multiply(r.nextFloat());
                                if ((double)r.nextFloat() < 0.5) {
                                    v.setY(multi * (height / 2.0f));
                                } else {
                                    v.setY(-multi * (height / 2.0f));
                                }
                            }
                            if (enableRotation) {
                                VectorUtils.rotateVector(v, xRotation, yRotation, zRotation);
                            }
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(v);
                            ++i;
                        }
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        ++this.step;
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, cylinder);
        }
    }

    public static void drawRings(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean enableRotation, final boolean animated, final float radius, final int ringCount, final int ringDensity, float height, final double visibleRange, double xRotation, double yRotation, double zRotation, final double disX, final double disY, final double disZ, long delayTicks, final long periodTicks) {
        if (!arraylist.containsKey(idName)) {
            int rings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                double rotation = 90.0;
                public double angularVelocityX = 0.015707964077591896;
                public double angularVelocityY = 0.018479958176612854;
                public double angularVelocityZ = 0.02026834f;
                double angularVelocity = 0.03926991f;
                int step = 0;
                float hue = 0.0f;
                Location location;
                double n;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY + 1.0, disZ);
                        this.n = 0.0;
                        int i = 0;
                        while (i < ringDensity) {
                            double angle = (double)this.step * this.angularVelocity;
                            int j = 0;
                            while (j < ringCount) {
                                double n4 = (float)Math.PI / (float)ringCount * (float)j;
                                Vector v = new Vector(Math.cos(angle), Math.sin(angle), 0.0).multiply(radius);
                                VectorUtils.rotateAroundAxisX(v, n4);
                                VectorUtils.rotateAroundAxisY(v, this.rotation);
                                if (enableRotation) {
                                    VectorUtils.rotateVector(v, this.angularVelocityX * (double)this.step, this.angularVelocityY * (double)this.step, this.angularVelocityZ * (double)this.step);
                                }
                                this.location.add(v);
                                final Location add = this.location.clone();
                                if (!animated) {
                                    if (rainbowMode) {
                                        this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                                    }
                                    ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                } else {
                                    this.n += (double)periodTicks;
                                    final int test = SchedulingManager.runRepeatingTaskTimer(new Runnable(){
                                        float finalHue;

                                        @Override
                                        public void run() {
                                            if (rainbowMode) {
                                                this.finalHue = ParticleEffect.simpleRainbowHelper(this.finalHue, particle);
                                            }
                                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, add, visibleRange, isSinglePlayer, rainbowMode, this.finalHue, offsetX, offsetY, offsetZ, speed, 1);
                                        }
                                    }, (int)this.n, 0).getTaskId();
                                    arraylist2.put(idName, test);
                                    int test2 = SchedulingManager.runSyncDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            Bukkit.getScheduler().cancelTask(test);
                                            arraylist2.remove(idName);
                                        }
                                    }, (int)(this.n * 2.0));
                                    arraylist2.put(idName, test2);
                                }
                                this.location.subtract(v);
                                ++j;
                            }
                            ++this.step;
                            ++i;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, 0L, periodTicks).getTaskId();
            arraylist.put(idName, rings);
        }
    }

    public static void drawSphere(final int style, final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final float radius, final int density, final double visibleRange, double xRotation, double yRotation, double zRotation, final double disX, final double disY, final double disZ, long delayTicks, long periodTicks) {
        if (!arraylist.containsKey(idName)) {
            int rings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float hue = 0.0f;
                float radiusCounter;
                float radiusCounterRev;
                float stepRadius;
                float stepRadiusIn;
                Vector v;
                boolean scan;
                Location location;
                double t;
                {
                    this.radiusCounterRev = f;
                    this.stepRadius = f / (float)n;
                    this.stepRadiusIn = f / (float)n;
                    this.scan = false;
                }

                public void radiusScan() {
                    if (this.scan) {
                        if (this.radiusCounter > radius) {
                            this.stepRadius = -this.stepRadius;
                        } else if (this.radiusCounter < 0.0f) {
                            this.stepRadius = -this.stepRadius;
                        }
                    } else {
                        if (this.radiusCounter > radius) {
                            this.radiusCounter = 0.0f;
                        }
                        if (this.radiusCounter < 0.0f) {
                            this.radiusCounter = radius;
                        }
                    }
                    this.radiusCounter += this.stepRadius;
                }

                public void radiusScanRev() {
                    if (this.scan) {
                        if (this.radiusCounterRev > radius) {
                            this.stepRadiusIn = -this.stepRadiusIn;
                        } else if (this.radiusCounterRev < 0.0f) {
                            this.stepRadiusIn = -this.stepRadiusIn;
                        }
                    } else {
                        if (this.radiusCounterRev > radius) {
                            this.radiusCounterRev = 0.0f;
                        }
                        if (this.radiusCounterRev < 0.0f) {
                            this.radiusCounterRev = radius;
                        }
                    }
                    this.radiusCounterRev -= this.stepRadiusIn;
                }

                public void quickSphere(float radius2) {
                    int i = 0;
                    while (i < density) {
                        this.v = RandomUtils.getRandomVector().multiply(radius2);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(this.v);
                        ++i;
                    }
                }

                public void quickSolidSphere(float radius2) {
                    int i = 0;
                    while (i < density) {
                        this.v = RandomUtils.getRandomVector().multiply(this.radiusCounterRev);
                        float i2 = 0.0f;
                        while (i2 < (float)density) {
                            this.radiusScanRev();
                            i2 += 1.0f;
                        }
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(this.v);
                        ++i;
                    }
                }

                public void fancySphere(double radius2) {
                    this.t += Math.PI / (double)density;
                    double theta = 0.0;
                    while (theta <= Math.PI * 2) {
                        double x = radius2 * Math.cos(theta) * Math.sin(this.t);
                        double y = radius2 * Math.cos(this.t);
                        double z = radius2 * Math.sin(theta) * Math.sin(this.t);
                        this.location.add(x, y, z);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location, visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(x, y, z);
                        theta += Math.PI / (double)density;
                    }
                }

                @Override
                public void run() {
                    this.location = EffectsLib.getLocation(center, idName);
                    this.location.add(disX, disY, disZ);
                    if (rainbowMode) {
                        this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                    }
                    if (style <= 1) {
                        this.quickSphere(radius);
                    } else if (style == 2) {
                        this.quickSphere(this.radiusCounter);
                        this.radiusScan();
                    } else if (style == 3) {
                        this.quickSphere(this.radiusCounter);
                        this.scan = true;
                        this.radiusScan();
                    } else if (style == 4) {
                        this.quickSphere(this.radiusCounterRev);
                        this.radiusScanRev();
                    } else if (style == 5) {
                        this.quickSphere(this.radiusCounterRev);
                        this.scan = true;
                        this.radiusScanRev();
                    } else if (style == 6) {
                        this.quickSolidSphere(radius);
                    } else if (style >= 7) {
                        this.fancySphere(radius);
                    }
                }
            }, 0L, delayTicks).getTaskId();
            arraylist.put(idName, rings);
        }
    }

    public static void drawWarpRings(final int style, final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean scan, final float radius, int ringCount, final int ringDensity, final float height, final double visibleRange, final double xRotation, final double yRotation, final double zRotation, final double disX, final double disY, final double disZ, long delayTicks, long periodTicks) {
        if (!arraylist.containsKey(idName)) {
            int rings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(ringCount){
                double x;
                double z;
                float hue = 0.0f;
                float midPoint;
                float heightCounter;
                float heightCounterRev;
                float middleCounterUp;
                float middleCounterDown;
                float radiusCounter;
                float radiusCounterRev;
                float stepHeight;
                float stepHalf;
                float stepRadius;
                float stepHeightDown;
                float stepHalfDown;
                float stepRadiusIn;
                Vector v;
                Location location;
                double t;
                {
                    this.midPoint = f / 2.0f;
                    this.heightCounterRev = f;
                    this.middleCounterUp = this.midPoint;
                    this.middleCounterDown = this.midPoint;
                    this.radiusCounterRev = f2;
                    this.stepHeight = f / (float)n;
                    this.stepHalf = this.midPoint / (float)n;
                    this.stepRadius = f2 / (float)n;
                    this.stepHeightDown = f / (float)n;
                    this.stepHalfDown = this.midPoint / (float)n;
                    this.stepRadiusIn = f2 / (float)n;
                    this.t = 0.0;
                }

                public void heightScan() {
                    if (scan) {
                        if (this.heightCounter > height) {
                            this.stepHeight = -this.stepHeight;
                        }
                        if (this.heightCounter < 0.0f) {
                            this.stepHeight = -this.stepHeight;
                        }
                    } else {
                        if (this.heightCounter > height) {
                            this.heightCounter = 0.0f;
                        }
                        if (this.heightCounter < 0.0f) {
                            this.heightCounter = height;
                        }
                    }
                    this.heightCounter += this.stepHeight;
                }

                public void heightScanRev() {
                    if (scan) {
                        if (this.heightCounterRev > height) {
                            this.stepHeightDown = -this.stepHeightDown;
                        }
                        if (this.heightCounterRev < 0.0f) {
                            this.stepHeightDown = -this.stepHeightDown;
                        }
                    } else {
                        if (this.heightCounterRev > height) {
                            this.heightCounterRev = 0.0f;
                        }
                        if (this.heightCounterRev < 0.0f) {
                            this.heightCounterRev = height;
                        }
                    }
                    this.heightCounterRev -= this.stepHeightDown;
                }

                public void middleScanUp() {
                    if (scan) {
                        if (this.middleCounterUp > height) {
                            this.stepHalf = -this.stepHalf;
                        } else if (this.middleCounterUp < this.midPoint) {
                            this.stepHalf = -this.stepHalf;
                        }
                    } else {
                        if (this.middleCounterUp > height) {
                            this.middleCounterUp = this.midPoint;
                        }
                        if (this.middleCounterUp < this.midPoint) {
                            this.middleCounterUp = height;
                        }
                    }
                    this.middleCounterUp += this.stepHalf;
                }

                public void middleScanDown() {
                    if (scan) {
                        if (this.middleCounterDown > this.midPoint) {
                            this.stepHalfDown = -this.stepHalfDown;
                        } else if (this.middleCounterDown < 0.0f) {
                            this.stepHalfDown = -this.stepHalfDown;
                        }
                    } else {
                        if (this.middleCounterDown > this.midPoint) {
                            this.middleCounterDown = 0.0f;
                        }
                        if (this.middleCounterDown < 0.0f) {
                            this.middleCounterDown = this.midPoint;
                        }
                    }
                    this.middleCounterDown -= this.stepHalfDown;
                }

                public void radiusScan() {
                    if (scan) {
                        if (this.radiusCounter > radius) {
                            this.stepRadius = -this.stepRadius;
                        } else if (this.radiusCounter < 0.0f) {
                            this.stepRadius = -this.stepRadius;
                        }
                    } else {
                        if (this.radiusCounter > radius) {
                            this.radiusCounter = 0.0f;
                        }
                        if (this.radiusCounter < 0.0f) {
                            this.radiusCounter = radius;
                        }
                    }
                    this.radiusCounter += this.stepRadius;
                }

                public void radiusScanRev() {
                    if (scan) {
                        if (this.radiusCounterRev > radius) {
                            this.stepRadiusIn = -this.stepRadiusIn;
                        } else if (this.radiusCounterRev < 0.0f) {
                            this.stepRadiusIn = -this.stepRadiusIn;
                        }
                    } else {
                        if (this.radiusCounterRev > radius) {
                            this.radiusCounterRev = 0.0f;
                        }
                        if (this.radiusCounterRev < 0.0f) {
                            this.radiusCounterRev = radius;
                        }
                    }
                    this.radiusCounterRev -= this.stepRadiusIn;
                }

                public void quickSolidCircle(float radius2, double y) {
                    this.location.add(0.0, y, 0.0);
                    double angle = 0.0;
                    while (angle < 6.2831854820251465) {
                        this.x = Math.cos(angle) * (double)radius2;
                        this.z = Math.sin(angle) * (double)radius2;
                        this.v = new Vector(this.x, 0.0, this.z);
                        VectorUtils.rotateVector(this.v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(this.x, 0.0, this.z);
                        angle += (double)((float)Math.PI / (float)ringDensity);
                    }
                    this.location.subtract(0.0, y, 0.0);
                }

                public void quickRadialWave(float radius2) {
                    this.t += 0.3141592741012573;
                    double angle = 0.0;
                    while (angle < 6.2831854820251465) {
                        this.x = this.t * Math.cos(angle);
                        double y = Math.exp((double)(-this.stepHeight) * this.t) * Math.sin(this.t) + (double)height;
                        this.z = this.t * Math.sin(angle);
                        this.v = new Vector(this.x, y, this.z);
                        VectorUtils.rotateVector(this.v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(this.x, y, this.z);
                        angle += (double)((float)Math.PI / (float)ringDensity);
                    }
                    if (this.t >= (double)radius2) {
                        this.t = 0.0;
                    }
                }

                public void quickRadialWave2(float radius2) {
                    this.t += 0.3141592741012573;
                    double angle = 0.0;
                    while (angle < 6.2831854820251465) {
                        this.x = this.t * Math.cos(angle);
                        double y = 2.0 * Math.exp((double)(-this.stepHeight) * this.t) * Math.sin(this.t) + (double)height;
                        this.z = this.t * Math.sin(angle);
                        this.v = new Vector(this.x, y, this.z);
                        VectorUtils.rotateVector(this.v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                        ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                        this.location.subtract(this.x, y, this.z);
                        angle += (double)((float)Math.PI / (float)ringDensity);
                    }
                    if (this.t >= (double)radius2) {
                        this.t = 0.0;
                    }
                }

                private void quickCubedRings(float radius2, double yStep) {
                    float a = radius2 / 2.0f;
                    int i = 0;
                    while (i < 4) {
                        double angleY = (double)i * Math.PI / 2.0;
                        int p = 0;
                        while (p <= ringDensity) {
                            this.v = new Vector((double)a, yStep, (double)(radius2 * (float)p / (float)ringDensity - a));
                            VectorUtils.rotateAroundAxisY(this.v, angleY);
                            VectorUtils.rotateVector(this.v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(this.v);
                            ++p;
                        }
                        ++i;
                    }
                }

                private void quickCubeOutline(float radius2, double yStep) {
                    float a = radius2 / 2.0f;
                    double b = yStep / 2.0;
                    Vector v = new Vector();
                    int i = 0;
                    while (i < 4) {
                        double angleY = (double)i * Math.PI / 2.0;
                        int j = 0;
                        while (j < 2) {
                            double angleX = (double)j * Math.PI;
                            int p = 0;
                            while (p <= ringDensity) {
                                v.setX(a).setY(a);
                                v.setZ(radius2 * (float)p / (float)ringDensity - a);
                                VectorUtils.rotateAroundAxisX(v, angleX);
                                VectorUtils.rotateAroundAxisY(v, angleY);
                                VectorUtils.rotateVector(v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                                ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                this.location.subtract(v);
                                ++p;
                            }
                            ++j;
                        }
                        int p = 0;
                        while (p <= ringDensity) {
                            v.setX(b).setZ(b);
                            v.setY(yStep * (double)p / (double)ringDensity - b);
                            VectorUtils.rotateAroundAxisY(v, angleY);
                            VectorUtils.rotateVector(v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(v);
                            ++p;
                        }
                        ++i;
                    }
                }

                private void quickDerpRing(float radius2, double yStep) {
                    float a = radius2 / 2.0f;
                    int i = 0;
                    while (i < 10) {
                        double angleY = (float)i * 0.62831855f;
                        int p = 0;
                        while (p <= ringDensity) {
                            this.v = new Vector((double)a, yStep, (double)(radius2 * (float)p / (float)ringDensity - a));
                            VectorUtils.rotateAroundAxisY(this.v, angleY);
                            VectorUtils.rotateVector(this.v, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(this.v);
                            ++p;
                        }
                        ++i;
                    }
                }

                private void quickStarRing(float radius2, double yStep) {
                    double angleForward = 2.5132741928100586;
                    int i = 1;
                    while (i < 6) {
                        double angleY = (float)i * 1.2566371f;
                        double x = Math.cos(angleY) * (double)radius2;
                        double z = Math.sin(angleY) * (double)radius2;
                        this.v = new Vector(x, yStep, z);
                        Vector star = this.v.clone();
                        VectorUtils.rotateAroundAxisY(star, angleForward);
                        this.location.add(this.v);
                        Vector link = star.clone().subtract(this.v.clone());
                        float length = (float)link.length();
                        link.normalize();
                        float ratio = length / (float)ringDensity;
                        Vector v3 = link.multiply(ratio);
                        Location loc = this.location.clone().subtract(v3);
                        int i2 = 0;
                        while (i2 < ringDensity) {
                            VectorUtils.rotateVector(v3, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, loc.add(v3), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            ++i2;
                        }
                        this.location.subtract(this.v);
                        ++i;
                    }
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        if (style <= 1) {
                            this.quickSolidCircle(radius, this.heightCounter);
                            this.heightScan();
                        } else if (style == 2) {
                            this.quickSolidCircle(radius, this.heightCounterRev);
                            this.heightScanRev();
                        } else if (style == 3) {
                            this.quickSolidCircle(this.radiusCounter, this.heightCounter);
                            this.radiusScan();
                        } else if (style == 4) {
                            this.quickSolidCircle(this.radiusCounterRev, this.heightCounter);
                            this.radiusScanRev();
                        } else if (style == 5) {
                            this.quickSolidCircle(this.radiusCounter, this.heightCounterRev);
                            this.heightScanRev();
                            this.radiusScan();
                        } else if (style == 6) {
                            this.quickSolidCircle(this.radiusCounterRev, this.heightCounter);
                            this.heightScan();
                            this.radiusScanRev();
                        } else if (style == 7) {
                            this.quickSolidCircle(radius, this.heightCounter);
                            this.quickSolidCircle(radius, this.heightCounterRev);
                            this.heightScan();
                            this.heightScanRev();
                        } else if (style == 8) {
                            this.quickSolidCircle(this.radiusCounter, this.middleCounterUp);
                            this.quickSolidCircle(this.radiusCounter, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScan();
                        } else if (style == 9) {
                            this.quickSolidCircle(this.radiusCounterRev, this.middleCounterUp);
                            this.quickSolidCircle(this.radiusCounterRev, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScanRev();
                        } else if (style == 10) {
                            this.quickCubedRings(radius, this.heightCounter);
                            this.heightScan();
                        } else if (style == 11) {
                            this.quickCubedRings(radius, this.heightCounterRev);
                            this.heightScanRev();
                        } else if (style == 12) {
                            this.quickCubedRings(this.radiusCounter, this.heightCounter);
                            this.radiusScan();
                        } else if (style == 13) {
                            this.quickCubedRings(this.radiusCounterRev, this.heightCounter);
                            this.radiusScanRev();
                        } else if (style == 14) {
                            this.quickCubedRings(this.radiusCounter, this.heightCounterRev);
                            this.heightScanRev();
                            this.radiusScan();
                        } else if (style == 15) {
                            this.quickCubedRings(this.radiusCounterRev, this.heightCounterRev);
                            this.heightScanRev();
                            this.radiusScanRev();
                        } else if (style == 16) {
                            this.quickCubedRings(radius, this.heightCounter);
                            this.quickCubedRings(radius, this.heightCounterRev);
                            this.heightScan();
                            this.heightScanRev();
                        } else if (style == 17) {
                            this.quickCubedRings(this.radiusCounter, this.middleCounterUp);
                            this.quickCubedRings(this.radiusCounter, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScan();
                        } else if (style == 18) {
                            this.quickCubedRings(this.radiusCounterRev, this.middleCounterUp);
                            this.quickCubedRings(this.radiusCounterRev, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScanRev();
                        } else if (style == 19) {
                            this.quickStarRing(radius, this.heightCounter);
                            this.heightScan();
                        } else if (style == 20) {
                            this.quickStarRing(radius, this.heightCounterRev);
                            this.heightScanRev();
                        } else if (style == 21) {
                            this.quickStarRing(this.radiusCounter, this.heightCounter);
                            this.radiusScan();
                        } else if (style == 22) {
                            this.quickStarRing(this.radiusCounterRev, this.heightCounter);
                            this.radiusScanRev();
                        } else if (style == 23) {
                            this.quickStarRing(this.radiusCounter, this.heightCounterRev);
                            this.heightScanRev();
                            this.radiusScan();
                        } else if (style == 24) {
                            this.quickStarRing(this.radiusCounterRev, this.heightCounterRev);
                            this.heightScanRev();
                            this.radiusScanRev();
                        } else if (style == 25) {
                            this.quickStarRing(radius, this.heightCounter);
                            this.quickStarRing(radius, this.heightCounterRev);
                            this.heightScan();
                            this.heightScanRev();
                        } else if (style == 26) {
                            this.quickStarRing(this.radiusCounter, this.middleCounterUp);
                            this.quickStarRing(this.radiusCounter, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScan();
                        } else if (style == 27) {
                            this.quickStarRing(this.radiusCounterRev, this.middleCounterUp);
                            this.quickStarRing(this.radiusCounterRev, this.middleCounterDown);
                            this.middleScanUp();
                            this.middleScanDown();
                            this.radiusScanRev();
                        } else if (style == 28) {
                            this.quickSolidCircle(this.heightCounter, (double)this.midPoint * Math.cos(this.heightCounter) + (double)(this.midPoint / 2.0f));
                            this.heightScan();
                        } else if (style == 29) {
                            this.quickSolidCircle(this.heightCounterRev, (double)this.midPoint * Math.cos(this.heightCounterRev) + (double)(this.midPoint / 2.0f));
                            this.heightScanRev();
                        } else if (style == 30) {
                            this.quickSolidCircle(this.radiusCounter, (double)this.midPoint * Math.cos(this.heightCounter) + (double)(this.midPoint / 2.0f));
                            this.heightScan();
                            this.radiusScan();
                        } else if (style == 31) {
                            this.quickSolidCircle(this.radiusCounterRev, (double)this.midPoint * Math.cos(this.heightCounterRev) + (double)(this.midPoint / 2.0f));
                            this.heightScanRev();
                            this.radiusScanRev();
                        } else if (style == 32) {
                            this.quickRadialWave(radius);
                        } else if (style == 33) {
                            this.quickRadialWave2(radius);
                        } else if (style == 34) {
                            this.quickDerpRing(this.radiusCounter, this.heightCounter);
                            this.radiusScan();
                        } else if (style == 35) {
                            this.quickCubeOutline(radius, height);
                        } else if (style >= 36) {
                            this.quickCubeOutline(this.radiusCounter, this.heightCounter);
                            this.heightScan();
                            this.radiusScan();
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, 0L, delayTicks).getTaskId();
            arraylist.put(idName, rings);
        }
    }

    public static void drawItemBoops(final ItemStack it, final Object center, final String idName, final float heightMod, final float radius, final int finalDensity, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int items = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                Location location;
                double angle;
                int step = 0;
                Vector v = new Vector();
                Vector vLoc = new Vector();
                Vector vTest = new Vector();
                Item i;
                Location loc;

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        World world = Bukkit.getWorld((String)this.location.getWorld().getName());
                        this.location.add(disX, disY, disZ);
                        this.angle = (float)this.step * ((float)Math.PI * 2 / (float)finalDensity);
                        this.v.setX(Math.cos(this.angle) * (double)radius);
                        this.v.setY(heightMod);
                        this.v.setZ(Math.sin(this.angle) * (double)radius);
                        if (this.step == 0) {
                            this.vLoc.setX(this.location.getX()).setY(this.location.getY()).setZ(this.location.getZ());
                            this.vTest = this.vLoc.add(this.v);
                            this.loc = this.vTest.toLocation(world);
                            ItemMeta itemMeta = it.getItemMeta();
                            itemMeta.setDisplayName("" + new Random(System.nanoTime()));
                            it.setItemMeta(itemMeta);
                            this.i = world.dropItem(this.loc.add(0.0, 1.0, 0.0), it);
                            this.i.setPickupDelay(99999999);
                            String newID = String.valueOf(this.i.getUniqueId().toString()) + idName;
                            arraylist.put(newID, 69);
                            skDragonCore.notInUseItems.add(this.i.getUniqueId());
                        }
                        this.i.setVelocity(this.v);
                        ++this.step;
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, 0L, delayBySecond).getTaskId();
            arraylist.put(idName, items);
        }
    }

    public static void drawItemFountain(final ItemStack it, final int style, final Object center, final String idName, final int itemTime, final float heightMod, final float radius, final int density, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int itemFountain = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)skDragonCore.skdragoncore, new Runnable(){
                Location location;
                double angle;
                double angularVelocity = 0.07853981852531433;
                float step;
                Item i;
                Vector v = new Vector();
                Random rand = new Random();

                @Override
                public void run() {
                    this.location = EffectsLib.getLocation(center, idName);
                    if (style <= 1) {
                        this.angle = (float)(this.rand.nextInt(361) + 0) * ((float)Math.PI * 2 / (float)density);
                        this.v.setX(Math.cos(this.angle) * (double)radius);
                        this.v.setY(heightMod);
                        this.v.setZ(Math.sin(this.angle) * (double)radius);
                    } else if (style == 2) {
                        int i = 0;
                        while (i < density) {
                            this.v = RandomUtils.getRandomVector().multiply(radius);
                            this.v.setY(heightMod);
                            this.v.setY(Math.abs(this.v.getY()));
                            ++i;
                        }
                    } else if (style >= 3) {
                        this.step = this.rand.nextInt(181) + 0;
                        this.v.setX(Math.cos((float)Math.PI * 2 / (float)density) * (double)radius);
                        this.v.setY(heightMod);
                        this.v.setZ(Math.sin((float)Math.PI * 2 / (float)density) * (double)radius);
                        VectorUtils.rotateVector(this.v, this.angularVelocity * (double)this.step, this.angularVelocity * (double)this.step, this.angularVelocity * (double)this.step);
                    }
                    ItemMeta itemMeta = it.getItemMeta();
                    itemMeta.setDisplayName(idName);
                    it.setItemMeta(itemMeta);
                    try {
                        this.i = this.location.getWorld().dropItem(this.location.add(disX, disY, disZ), it);
                    }
                    catch (Exception e) {
                        skDragonCore.sendExLog("The location or item used is invalid", idName, 3);
                        EffectsLib.stopEffect(idName);
                        EffectsLib.stopItemEffect(idName);
                        return;
                    }
                    this.i.setPickupDelay(itemTime * 10);
                    this.i.setVelocity(this.v);
                    String newID = String.valueOf(this.i.getUniqueId().toString()) + idName;
                    arraylist.put(newID, 6969);
                    skDragonCore.notInUseItems.add(this.i.getUniqueId());
                    for (Entity entity : this.location.getWorld().getEntities()) {
                        if (!(entity instanceof Item) || entity.getTicksLived() < itemTime || !skDragonCore.notInUseItems.contains(entity.getUniqueId())) continue;
                        arraylist.remove(String.valueOf(entity.getUniqueId().toString()) + idName);
                        skDragonCore.notInUseItems.remove(entity.getUniqueId());
                        entity.remove();
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, itemFountain);
        }
    }

    public static void drawVortex(final Player p, String idName, final int r, final int g, final int b) {
        if (!arraylist.containsKey(idName)) {
            int vortex = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public float radius = 2.0f;
                public float grow = 0.05f;
                public double radials = 0.19634954631328583;
                public int circles = 3;
                public int helixes = 4;
                float step = 2.0f;

                @Override
                public void run() {
                    Location location = p.getLocation();
                    int x = 0;
                    while (x < this.circles) {
                        int i = 0;
                        while (i < this.helixes) {
                            double angle = (double)this.step * this.radials + Math.PI * 2 * (double)i / (double)this.helixes;
                            Vector v = new Vector(Math.cos(angle) * (double)this.radius, (double)(this.step * this.grow), Math.sin(angle) * (double)this.radius);
                            VectorUtils.rotateAroundAxisX(v, (location.getPitch() + 90.0f) * ((float)Math.PI / 180));
                            VectorUtils.rotateAroundAxisY(v, -location.getYaw() * ((float)Math.PI / 180));
                            location.add(v);
                            ParticleEffect.redstone.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(r, g, b), location, 50.0);
                            location.subtract(v);
                            ++i;
                        }
                        this.step += 1.0f;
                        ++x;
                    }
                    float k = 3.5f;
                    while (k > 0.0f) {
                        Location loc = p.getLocation();
                        Vector v = new Vector((double)k * Math.sin(k * this.step) / 3.0, (double)(-k) + 3.8, (double)k * Math.cos(k * this.step) / 3.0);
                        loc.add(v);
                        ParticleEffect.redstone.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(r, g, b), loc, 50.0);
                        k -= 0.1f;
                    }
                    this.step -= 0.1f;
                    if (this.step <= -10.0f) {
                        this.step = 10.0f;
                    }
                }
            }, 0L, 0L).getTaskId();
            arraylist.put(idName, vortex);
        }
    }

    public static void drawVortex2(final String particle, final Player p, String idName, final boolean rainbowMode, final int r, final int g, final int b) {
        if (!arraylist.containsKey(idName)) {
            int vortex2 = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                float step = 2.0f;
                private float hue;

                @Override
                public void run() {
                    float k = 3.5f;
                    while (k > 0.0f) {
                        Location location = p.getLocation();
                        Vector v = new Vector((double)k * Math.sin(k * this.step) / 3.0, (double)(-k) + 3.8, (double)k * Math.cos(k * this.step) / 3.0);
                        location.add(v);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        ParticleEffect.valueOf(particle).display((float)r, (float)g, (float)b, 1.0f, 0, location, 50.0);
                        k -= 0.1f;
                    }
                    this.step -= 0.1f;
                    if (this.step <= -10.0f) {
                        this.step = 10.0f;
                    }
                }
            }, 0L, 0L).getTaskId();
            arraylist.put(idName, vortex2);
        }
    }

    @Deprecated
    public static void drawRainbowLine(final Player p, String idName, final String particle) {
        if (!arraylist.containsKey(idName)) {
            int rainbowline = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                private float hue = 0.0f;

                @Override
                public void run() {
                    Location loc = p.getLocation();
                    loc.add(0.0, (double)0.3f, 0.0);
                    int argb = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    r = r == 0.0f ? 0.001f : r;
                    this.hue += 0.01f;
                    this.hue = this.hue >= 1.0f ? 0.0f : this.hue;
                    ParticleEffect.valueOf(particle).display(r, g, b, 1.0f, 0, loc, 50.0);
                    ParticleEffect.valueOf(particle).display(r, g, b, 1.0f, 0, loc, 50.0);
                    ParticleEffect.valueOf(particle).display(r, g, b, 1.0f, 0, loc, 50.0);
                    ParticleEffect.valueOf(particle).display(r, g, b, 1.0f, 0, loc, 50.0);
                }
            }, 1L, 1L).getTaskId();
            arraylist.put(idName, rainbowline);
        }
    }

    public static void drawWings(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final String particle2, final Material dataMat2, final byte dataID2, final float speed2, final float offsetX2, final float offsetY2, final float offsetZ2, final String particle3, final Material dataMat3, final byte dataID3, final float speed3, final float offsetX3, final float offsetY3, final float offsetZ3, final Object center, final String idName, final boolean isSinglePlayer, final boolean rainbowMode, final boolean flapMode, float flapStep, final float flapRange, final float wingAngle, final double visibleRange, final boolean[][] shape, final boolean[][] shape2, final boolean[][] shape3, final float height, final double space, long delayTicks, long delayBySecond, final Player player) {
        if (!arraylist.containsKey(idName)) {
            int wings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(flapStep){
                private float hue;
                Location location;
                float flap = 0.0f;
                float stepFlap;
                {
                    this.stepFlap = f;
                }

                @Override
                public void run() {
                    try {
                        double leftWing;
                        double rightWing;
                        Vector v2;
                        Vector vL;
                        Vector vR;
                        Location target;
                        int j;
                        double x;
                        this.location = EffectsLib.getLocation(center, idName);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle2);
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle3);
                        }
                        double defX = x = this.location.getX() + space;
                        double y = this.location.clone().getY() + 2.7 + (double)height;
                        double y2 = this.location.clone().getY() + 2.7 + (double)height;
                        double y3 = this.location.clone().getY() + 2.7 + (double)height;
                        int i = 0;
                        while (i < shape.length) {
                            j = 0;
                            while (j < shape[i].length) {
                                if (shape[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - (wingAngle - this.flap));
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + (wingAngle - this.flap));
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                    ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y -= space;
                            x = defX;
                            ++i;
                        }
                        i = 0;
                        while (i < shape2.length) {
                            j = 0;
                            while (j < shape2[i].length) {
                                if (shape2[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y2);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - (wingAngle - this.flap));
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + (wingAngle - this.flap));
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                                    ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y2 -= space;
                            x = defX;
                            ++i;
                        }
                        i = 0;
                        while (i < shape3.length) {
                            j = 0;
                            while (j < shape3[i].length) {
                                if (shape3[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y3);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - (wingAngle - this.flap));
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + (wingAngle - this.flap));
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle3).display(idName, dataMat3, dataID3, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX3, offsetY3, offsetZ3, speed3, 1);
                                    ParticleEffect.valueOf(particle3).display(idName, dataMat3, dataID3, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX3, offsetY3, offsetZ3, speed3, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y3 -= space;
                            x = defX;
                            ++i;
                        }
                        if (flapMode) {
                            if (this.flap > flapRange) {
                                this.stepFlap = -this.stepFlap;
                            } else if (this.flap < 0.0f) {
                                this.stepFlap = -this.stepFlap;
                            }
                            this.flap += this.stepFlap;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, wings);
        }
    }

    public static void drawWings4Color(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final String particle2, final Material dataMat2, final byte dataID2, final float speed2, final float offsetX2, final float offsetY2, final float offsetZ2, final String particle3, final Material dataMat3, final byte dataID3, final float speed3, final float offsetX3, final float offsetY3, final float offsetZ3, final String particle4, final Material dataMat4, final byte dataID4, final float speed4, final float offsetX4, final float offsetY4, final float offsetZ4, final Object center, final String idName, final boolean isSinglePlayer, final boolean rainbowMode, final boolean flapMode, float flapStep, final float flapRange, final float wingAngle, final double visibleRange, final boolean[][] shape, final boolean[][] shape2, final boolean[][] shape3, final boolean[][] shape4, final float height, final double space, long delayTicks, long delayBySecond, final Player player) {
        if (!arraylist.containsKey(idName)) {
            int wings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(flapStep){
                private float hue;
                Location location;
                float flap = 0.0f;
                float stepFlap;
                {
                    this.stepFlap = f;
                }

                @Override
                public void run() {
                    try {
                        double leftWing;
                        double rightWing;
                        Vector v2;
                        Vector vL;
                        Vector vR;
                        Location target;
                        int j;
                        double x;
                        this.location = EffectsLib.getLocation(center, idName);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle2);
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle3);
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle4);
                        }
                        double defX = x = this.location.getX() + space;
                        double y = this.location.clone().getY() + 2.7 + (double)height;
                        double y2 = this.location.clone().getY() + 2.7 + (double)height;
                        double y3 = this.location.clone().getY() + 2.7 + (double)height;
                        double y4 = this.location.clone().getY() + 2.7 + (double)height;
                        int i = 0;
                        while (i < shape.length) {
                            j = 0;
                            while (j < shape[i].length) {
                                if (shape[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - wingAngle - this.flap);
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + wingAngle - this.flap);
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                    ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y -= space;
                            x = defX;
                            ++i;
                        }
                        i = 0;
                        while (i < shape2.length) {
                            j = 0;
                            while (j < shape2[i].length) {
                                if (shape2[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y2);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - wingAngle - this.flap);
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + wingAngle - this.flap);
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                                    ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y2 -= space;
                            x = defX;
                            ++i;
                        }
                        i = 0;
                        while (i < shape3.length) {
                            j = 0;
                            while (j < shape3[i].length) {
                                if (shape3[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y3);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - wingAngle - this.flap);
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + wingAngle - this.flap);
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle3).display(idName, dataMat3, dataID3, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX3, offsetY3, offsetZ3, speed3, 1);
                                    ParticleEffect.valueOf(particle3).display(idName, dataMat3, dataID3, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX3, offsetY3, offsetZ3, speed3, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y3 -= space;
                            x = defX;
                            ++i;
                        }
                        i = 0;
                        while (i < shape4.length) {
                            j = 0;
                            while (j < shape4[i].length) {
                                if (shape4[i][j]) {
                                    target = this.location.clone();
                                    target.setX(x);
                                    target.setY(y4);
                                    vR = target.toVector().subtract(this.location.toVector());
                                    vL = target.toVector().subtract(this.location.toVector());
                                    v2 = VectorUtils.getBackVector(this.location);
                                    rightWing = Math.toRadians(this.location.getYaw() + 90.0f - wingAngle - this.flap);
                                    leftWing = Math.toRadians(this.location.getYaw() + 90.0f + wingAngle - this.flap);
                                    vR = VectorUtils.rotateAroundAxisY(vR, -rightWing);
                                    vL = VectorUtils.rotateAroundAxisY(vL, -leftWing);
                                    v2.setY(0).multiply(-0.2);
                                    ParticleEffect.valueOf(particle4).display(idName, dataMat4, dataID4, player, this.location.clone().add(vL).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX4, offsetY4, offsetZ4, speed4, 1);
                                    ParticleEffect.valueOf(particle4).display(idName, dataMat4, dataID4, player, this.location.clone().add(vR).add(v2), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX4, offsetY4, offsetZ4, speed4, 1);
                                }
                                x += space;
                                ++j;
                            }
                            y4 -= space;
                            x = defX;
                            ++i;
                        }
                        if (flapMode) {
                            if (this.flap > flapRange) {
                                this.stepFlap = -this.stepFlap;
                            } else if (this.flap < 0.0f) {
                                this.stepFlap = -this.stepFlap;
                            }
                            this.flap += this.stepFlap;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, wings);
        }
    }

    public static void drawPlanet(final String particle, final Material dataMat, final byte dataID, final float speed, final String particle2, final Material dataMat2, final byte dataID2, final float speed2, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean enableRotation, final Plane plane, final float rotationStep, final boolean enableOrbit, final float orbitalRadius, final float orbitalStepDensity, final double xRotation, final double yRotation, final double zRotation, final float radius, final int density, final int precision, final float mountainHeight, final double visibleRange, final float offsetX, final float offsetY, final float offsetZ, final float offsetX2, final float offsetY2, final float offsetZ2, final double disX, final double disY, final double disZ, long delayTicks, long delayBySecond) {
        if (!arraylist.containsKey(idName)) {
            int planet = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public float hue;
                Location location;
                double angularVelocityX = 0.008726646192371845;
                double angularVelocityY = 0.008726646192371845;
                double angularVelocityZ = 0.008726646192371845;
                int orbitalStep = 0;
                boolean firstStep = true;
                Set<Vector> cacheGreen = new HashSet<Vector>();
                Set<Vector> cacheBlue = new HashSet<Vector>();
                Set<Vector> cache = new HashSet<Vector>();

                public void invalidate() {
                    this.firstStep = false;
                    this.cacheGreen.clear();
                    this.cacheBlue.clear();
                    int sqrtParticles = (int)Math.sqrt(density);
                    float theta = 0.0f;
                    float thetaStep = (float)Math.PI / (float)sqrtParticles;
                    float phiStep = (float)Math.PI * 2 / (float)sqrtParticles;
                    int i = 0;
                    while (i < sqrtParticles) {
                        theta += thetaStep;
                        float phi = 0.0f;
                        int j = 0;
                        while (j < sqrtParticles) {
                            float x = radius * MathUtils.sin(theta) * MathUtils.cos(phi += phiStep);
                            float y = radius * MathUtils.sin(theta) * MathUtils.sin(phi);
                            float z = radius * MathUtils.cos(theta);
                            this.cache.add(new Vector(x, y, z));
                            ++j;
                        }
                        ++i;
                    }
                    float increase = mountainHeight / (float)precision;
                    int i2 = 0;
                    while (i2 < precision) {
                        double r1 = RandomUtils.getRandomAngle();
                        double r2 = RandomUtils.getRandomAngle();
                        double r3 = RandomUtils.getRandomAngle();
                        for (Vector v : this.cache) {
                            if (v.getY() > 0.0) {
                                v.setY(v.getY() + (double)increase);
                            } else {
                                v.setY(v.getY() - (double)increase);
                            }
                            if (i2 == precision - 1) continue;
                            VectorUtils.rotateVector(v, r1, r2, r3);
                        }
                        ++i2;
                    }
                    float minSquared = Float.POSITIVE_INFINITY;
                    float maxSquared = Float.NEGATIVE_INFINITY;
                    for (Vector current : this.cache) {
                        float lengthSquared = (float)current.lengthSquared();
                        if (minSquared > lengthSquared) {
                            minSquared = lengthSquared;
                        }
                        if (!(maxSquared < lengthSquared)) continue;
                        maxSquared = lengthSquared;
                    }
                    float average = (minSquared + maxSquared) / 2.0f;
                    for (Vector v : this.cache) {
                        float lengthSquared = (float)v.lengthSquared();
                        if (lengthSquared >= average) {
                            this.cacheGreen.add(v);
                            continue;
                        }
                        this.cacheBlue.add(v);
                    }
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        if (this.firstStep) {
                            this.invalidate();
                        }
                        if (enableOrbit) {
                            double inc = (float)Math.PI * 2 / orbitalStepDensity;
                            double angle = (double)this.orbitalStep * inc;
                            Vector v2 = new Vector();
                            v2.setX(Math.cos(angle) * (double)orbitalRadius);
                            v2.setZ(Math.sin(angle) * (double)orbitalRadius);
                            VectorUtils.rotateVector(v2, xRotation * 0.01745329238474369, yRotation * 0.01745329238474369, zRotation * 0.01745329238474369);
                            this.location.add(v2);
                            ++this.orbitalStep;
                        }
                        if (enableRotation) {
                            double rotX = 0.0;
                            double rotY = 0.0;
                            double rotZ = 0.0;
                            switch (plane) {
                                case X: {
                                    rotX = this.angularVelocityX * (double)rotationStep;
                                    break;
                                }
                                case Y: {
                                    rotY = this.angularVelocityY * (double)rotationStep;
                                    break;
                                }
                                case Z: {
                                    rotZ = this.angularVelocityZ * (double)rotationStep;
                                    break;
                                }
                                case XY: {
                                    rotX = this.angularVelocityX * (double)rotationStep;
                                    rotY = this.angularVelocityY * (double)rotationStep;
                                    break;
                                }
                                case XZ: {
                                    rotX = this.angularVelocityX * (double)rotationStep;
                                    rotZ = this.angularVelocityZ * (double)rotationStep;
                                    break;
                                }
                                case XYZ: {
                                    rotX = this.angularVelocityX * (double)rotationStep;
                                    rotY = this.angularVelocityY * (double)rotationStep;
                                    rotZ = this.angularVelocityZ * (double)rotationStep;
                                    break;
                                }
                                case YZ: {
                                    rotY = this.angularVelocityY * (double)rotationStep;
                                    rotZ = this.angularVelocityZ * (double)rotationStep;
                                }
                            }
                            for (Vector v : this.cache) {
                                VectorUtils.rotateVector(v, rotX, rotY, rotZ);
                            }
                        }
                        for (Vector v : this.cacheGreen) {
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(v);
                        }
                        for (Vector v : this.cacheBlue) {
                            ParticleEffect.valueOf(particle2).display(idName, dataMat2, dataID2, player, this.location.add(v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX2, offsetY2, offsetZ2, speed2, 1);
                            this.location.subtract(v);
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, delayTicks, delayBySecond).getTaskId();
            arraylist.put(idName, planet);
        }
    }

    public static void drawBetaTest1(final Player p, String idName) {
        if (!arraylist.containsKey(idName)) {
            final ParticleEffect.OrdinaryColor color = new ParticleEffect.OrdinaryColor(255, 20, 20);
            int i = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                int particles = 40;
                float radius = 2.0f;
                protected int i;
                int speed = 25;
                double height = 0.0;
                int particles2 = 40;
                float radius2 = 2.0f;
                protected int i2;
                int speed2 = 25;
                double height2 = 0.0;

                @Override
                public void run() {
                    Location location = p.getLocation();
                    Location location2 = p.getLocation();
                    double angle = Math.PI * 2 * (double)this.i / (double)(this.particles * this.speed);
                    double x = Math.cos(angle) * (double)this.radius;
                    double z = Math.sin(angle) * (double)this.radius;
                    location.add(x, this.height, z);
                    ParticleEffect.redstone.display((ParticleEffect.ParticleColor)color, location, 30.0);
                    location.subtract(x, 0.0, z);
                    this.i += this.speed;
                    if ((double)this.radius > 0.02) {
                        this.radius = (float)((double)this.radius - 0.05);
                        this.height += 0.1;
                    } else {
                        this.radius = 2.0f;
                        this.height = 0.0;
                    }
                    double angle2 = Math.PI * 2 * (double)this.i2 / (double)(this.particles2 * this.speed2);
                    double x2 = Math.cos(angle2) * (double)(-this.radius2);
                    double z2 = Math.sin(angle2) * (double)(-this.radius2);
                    Vector v = new Vector(x2, this.height2, z2);
                    location2.add(v);
                    ParticleEffect.redstone.display((ParticleEffect.ParticleColor)color, location, 30.0);
                    location2.subtract(x, 0.0, z);
                    this.i2 += this.speed2;
                    if ((double)this.radius2 > 0.02) {
                        this.radius2 = (float)((double)this.radius2 - 0.05);
                        this.height2 += 0.1;
                    } else {
                        this.radius2 = 2.0f;
                        this.height2 = 0.0;
                    }
                }
            }, 1L, 1L).getTaskId();
            arraylist.put(idName, i);
        } else {
            EffectsLib.stopEffect(idName);
        }
    }

    public static void drawBetaTest2(final Player p, String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest2 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                int particles = 70;
                float radius = 1.245f;
                protected int i;
                int speed = 3;
                double height = 0.3;
                boolean up = false;

                @Override
                public void run() {
                    Location location = p.getEyeLocation();
                    double angle = Math.PI * 2 * (double)this.i / (double)this.particles;
                    double x = Math.cos(angle) * (double)this.radius;
                    double z = Math.sin(angle) * (double)this.radius;
                    location.add(x, this.height, z);
                    ParticleEffect.heart.display(0.0f, 0.0f, 0.0f, 0.0f, 1, location, 50.0);
                    location.subtract(x, 0.0, z);
                    this.i += this.speed;
                    if (this.height < -1.49) {
                        this.up = true;
                    } else if (this.height > 0.6) {
                        this.up = false;
                    }
                    this.height = this.up ? (this.height += 0.05) : (this.height -= 0.05);
                }
            }, 1L, 1L).getTaskId();
            arraylist.put(idName, betatest2);
        } else {
            EffectsLib.stopEffect(idName);
        }
    }

    public static void drawBetaTest3(final Player p, String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest3 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public float radius = 1.0f;
                public float grow = 0.0f;
                public double radials = 0.1963495408493621;
                public int circles = 1;
                public int helixes = 1;
                protected int step = 0;
                public float radius2 = 1.0f;
                public float grow2 = 0.0f;
                public double radials2 = 0.1963495408493621;
                public int helixes2 = 1;
                protected int step2 = 0;

                @Override
                public void run() {
                    Location loc = p.getLocation().add(0.0, 1.0, 0.0);
                    Location loc2 = p.getLocation().add(0.0, 1.0, 0.0);
                    Vector v = null;
                    Vector v2 = null;
                    int x = 0;
                    while (x < this.circles) {
                        double angle;
                        int i = 0;
                        while (i < this.helixes) {
                            angle = (double)this.step * this.radials + Math.PI * 2 * (double)i / (double)this.helixes;
                            v = new Vector(Math.cos(angle) * (double)this.radius, (double)((float)this.step * this.grow), Math.sin(angle) * (double)this.radius);
                            VectorUtils.rotateAroundAxisX(v, 2.356194257736206);
                            VectorUtils.rotateAroundAxisY(v, 0.01745329052209854);
                            loc.add(v);
                            ParticleEffect.happyvillager.display(0.0f, 0.0f, 0.0f, 0.0f, 1, loc, 50.0);
                            loc.subtract(v);
                            ++i;
                        }
                        ++this.step;
                        i = 0;
                        while (i < this.helixes2) {
                            angle = (double)this.step2 * this.radials2 + Math.PI * 2 * (double)i / (double)this.helixes2;
                            v2 = new Vector(Math.cos(angle) * (double)this.radius2, (double)((float)this.step2 * this.grow2), Math.sin(angle) * (double)this.radius2);
                            VectorUtils.rotateAroundAxisX(v2, 0.7853980660438538);
                            VectorUtils.rotateAroundAxisY(v2, 0.01745329052209854);
                            loc2.add(v2);
                            ParticleEffect.happyvillager.display(0.0f, 0.0f, 0.0f, 0.0f, 1, loc2, 50.0);
                            loc2.subtract(v2);
                            ++i;
                        }
                        ++this.step2;
                        ++x;
                    }
                }
            }, 1L, 2L).getTaskId();
            arraylist.put(idName, betatest3);
        } else {
            EffectsLib.stopEffect(idName);
        }
    }

    public static void drawBetaTest4(final Location location, final Location locTest, final Player playerTest, String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest4 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public double radius = 1.5;
                public int particles = 50;

                @Override
                public void run() {
                    Location loc = playerTest.getEyeLocation();
                    Bukkit.getServer().broadcastMessage("[skDragon] Second Test");
                    Bukkit.getServer().broadcastMessage("[skDragon] skriptLoc" + locTest);
                    Bukkit.getServer().broadcastMessage("[skDragon] playerLoc" + loc);
                    Bukkit.getServer().broadcastMessage("[skDragon actual test] " + location);
                    int i = 0;
                    while (i < this.particles) {
                        Vector point = RandomUtils.getRandomVector().multiply(this.radius);
                        location.add(point);
                        ParticleEffect.flame.display(0.0f, 0.0f, 0.0f, 0.0f, 1, location, 50.0);
                        location.subtract(point);
                        ++i;
                    }
                }
            }, 3L, 3L).getTaskId();
            arraylist.put(idName, betatest4);
        } else {
            EffectsLib.stopEffect(idName);
        }
    }

    public static void drawBetaTest6(final Player player, String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest6 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                public float height = 2.5f;
                public float particles = 30.0f;
                public float edgeLength = 6.5f;
                public double yRotation = 0.4487989544868469;

                @Override
                public void run() {
                    Location location = player.getLocation();
                    Vector v = new Vector();
                    int x = 0;
                    while ((float)x <= this.particles) {
                        double y1 = Math.sin((float)Math.PI * (float)x / this.particles);
                        int z = 0;
                        while ((float)z <= this.particles) {
                            double y2 = Math.sin((float)Math.PI * (float)z / this.particles);
                            v.setX(this.edgeLength * (float)x / this.particles).setZ(this.edgeLength * (float)z / this.particles);
                            v.setY((double)this.height * y1 * y2);
                            VectorUtils.rotateAroundAxisY(v, this.yRotation);
                            ParticleEffect.flame.display(0.0f, 0.0f, 0.0f, 0.0f, 1, location.add(v), 50.0);
                            location.subtract(v);
                            ++z;
                        }
                        ++x;
                    }
                }
            }, 1L, 2L).getTaskId();
            arraylist.put(idName, betatest6);
        } else {
            EffectsLib.stopEffect(idName);
        }
    }

    public static void drawBetaTest7(Location location, Location locTest, Player playerTest, final Object center, final Object getTarget, final String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest7 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(){
                Location location;
                Location target;
                public boolean isZigZag = false;
                public int zigZags = 10;
                public int particles = 100;
                public int length = 0;
                protected boolean zigs = false;
                protected float step = 0.0f;

                @Override
                public void run() {
                    if (center instanceof Entity) {
                        this.location = ((Entity)center).getLocation();
                    } else if (center instanceof Location) {
                        this.location = new Location(((Location)center).getWorld(), ((Location)center).getX(), ((Location)center).getY(), ((Location)center).getZ());
                    }
                    if (this.length > 0) {
                        this.target = this.location.clone().add(this.location.getDirection().normalize().multiply(this.length));
                    } else if (getTarget instanceof Entity) {
                        this.target = ((Entity)getTarget).getLocation();
                    } else if (getTarget instanceof Location) {
                        this.target = new Location(((Location)getTarget).getWorld(), ((Location)getTarget).getX(), ((Location)getTarget).getY(), ((Location)getTarget).getZ());
                    }
                    double amount = this.particles / this.zigZags;
                    if (this.location == null || this.target == null) {
                        EffectsLib.stopEffect(idName);
                        return;
                    }
                    Vector link = this.target.toVector().subtract(this.location.toVector());
                    float length = (float)link.length();
                    link.normalize();
                    float ratio = length / (float)this.particles;
                    Vector v = link.multiply(ratio);
                    Location loc = this.location.clone().subtract(v);
                    int i = 0;
                    while (i < this.particles) {
                        if (this.isZigZag) {
                            if (this.zigs) {
                                loc.add(0.0, 0.1, 0.0);
                            } else {
                                loc.subtract(0.0, 0.1, 0.0);
                            }
                        }
                        if ((double)this.step >= amount) {
                            this.zigs = !this.zigs;
                            this.step = 0.0f;
                        }
                        this.step += 1.0f;
                        loc.add(v);
                        ++i;
                    }
                }
            }, 3L, 3L).getTaskId();
            arraylist.put(idName, betatest7);
        }
    }

    public static void drawWarpBubble(final String particle, final Material dataMat, final byte dataID, final float speed, final float offsetX, final float offsetY, final float offsetZ, final Object center, final String idName, final boolean isSinglePlayer, final Player player, final boolean rainbowMode, final boolean scan, final float radius, int ringCount, final int ringDensity, final float height, final double visibleRange, double xRotation, double yRotation, double zRotation, final double disX, final double disY, final double disZ, long delayTicks, long periodTicks) {
        if (!arraylist.containsKey(idName)) {
            int rings = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(ringCount){
                double x;
                double y;
                double z;
                float hue = 0.0f;
                double heightCounter;
                double radiusCounter;
                boolean up = true;
                boolean out = true;
                double stepHeight;
                double stepRadius;
                Vector v;
                Location location;
                float edgeLength;
                double yRotation;
                {
                    this.stepHeight = f / (float)n;
                    this.stepRadius = f2 / (float)n;
                    this.edgeLength = 6.5f;
                    this.yRotation = 0.4487989544868469;
                }

                @Override
                public void run() {
                    try {
                        this.location = EffectsLib.getLocation(center, idName);
                        this.location.add(disX, disY, disZ);
                        if (rainbowMode) {
                            this.hue = ParticleEffect.simpleRainbowHelper(this.hue, particle);
                        }
                        this.y = this.heightCounter;
                        this.location.add(0.0, this.y, 0.0);
                        double angle = 0.0;
                        while (angle < 6.2831854820251465) {
                            this.x = Math.cos(angle) * this.radiusCounter;
                            this.z = Math.sin(angle) * this.radiusCounter;
                            this.v = new Vector(this.x, 0.0, this.z);
                            ParticleEffect.valueOf(particle).display(idName, dataMat, dataID, player, this.location.add(this.v), visibleRange, isSinglePlayer, rainbowMode, this.hue, offsetX, offsetY, offsetZ, speed, 1);
                            this.location.subtract(this.x, 0.0, this.z);
                            angle += (double)((float)Math.PI / (float)ringDensity);
                        }
                        int i = 0;
                        while (i < ringDensity) {
                            double angle2 = 6.2831854820251465 * (double)i / (double)ringDensity;
                            double y2 = Math.sin((float)Math.PI * (float)i / (float)ringDensity);
                            this.x = Math.cos(angle2) * this.radiusCounter;
                            this.z = Math.sin(angle2) * this.radiusCounter;
                            this.v.setX(this.edgeLength * (float)i / (float)ringDensity).setZ(this.edgeLength * (float)i / (float)ringDensity);
                            this.v.setY((double)height * y2 * y2);
                            VectorUtils.rotateAroundAxisY(this.v, this.yRotation);
                            ParticleEffect.flame.display(0.0f, 0.0f, 0.0f, 0.0f, 1, this.location.add(this.v), 50.0);
                            this.location.subtract(this.v);
                            ++i;
                        }
                        this.location.subtract(0.0, this.y, 0.0);
                        if (scan) {
                            if (this.heightCounter > (double)height) {
                                this.up = false;
                            } else if (this.heightCounter < 0.0) {
                                this.up = true;
                            }
                            if (this.radiusCounter > (double)radius) {
                                this.out = false;
                            } else if (this.heightCounter < 0.0) {
                                this.out = true;
                            }
                        } else {
                            if (this.heightCounter > (double)height) {
                                this.heightCounter = 0.0;
                            }
                            if (this.heightCounter < 0.0) {
                                this.heightCounter = height;
                            }
                            if (this.radiusCounter > (double)radius) {
                                this.radiusCounter = 0.0;
                            }
                            if (this.radiusCounter < 0.0) {
                                this.radiusCounter = radius;
                            }
                        }
                        if (this.up) {
                            this.heightCounter += this.stepHeight;
                        }
                        if (!this.up) {
                            this.heightCounter -= this.stepHeight;
                        }
                        if (this.out) {
                            this.radiusCounter += this.stepRadius;
                        }
                        if (!this.out) {
                            this.radiusCounter -= this.stepRadius;
                        }
                    }
                    catch (NullPointerException ex) {
                        EffectsLib.foundNull(this.location, idName, ex);
                    }
                }
            }, 0L, delayTicks).getTaskId();
            arraylist.put(idName, rings);
        }
    }

    public static void drawStatCircle(Location loc, String idName) {
        if (!arraylist.containsKey(idName)) {
            int betatest8 = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)skDragonCore.skdragoncore, new Runnable(loc){
                Location l;
                {
                    this.l = location;
                }

                @Override
                public void run() {
                    for (Location loc : EffectsLib.getCircle(this.l, 0.6, 15)) {
                        ParticleEffect.flame.display(0.0f, 0.0f, 0.0f, 0.0f, 1, loc, 100.0);
                    }
                    for (Location loc : EffectsLib.getCircle(this.l, 1.0, 20)) {
                        ParticleEffect.flame.display(0.0f, 0.0f, 0.0f, 0.0f, 1, loc, 100.0);
                    }
                }
            }, 0L, 5L).getTaskId();
            arraylist.put(idName, betatest8);
        }
    }

    private static ArrayList<Location> getCircle(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = (float)Math.PI * 2 / (float)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    private static ArrayList<Location> getCircleReverse(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = (float)Math.PI * 2 / (float)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() - radius * Math.cos(angle);
            double z = center.getZ() - radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    public static enum Plane {
        X,
        Y,
        Z,
        XY,
        XZ,
        XYZ,
        YZ;

    }
}

