/*
 * Decompiled with CFR 0.152.
 */
package me.keeland.keelansk.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    private static Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MINUTE = 60L;

    public static String removeTimePattern(String input) {
        return timePattern.matcher(input).replaceFirst("").trim();
    }

    public static String ticksToString(long ticks) {
        int hours = (int)Math.floor((double)ticks / 3600.0);
        int minutes = (int)Math.floor((double)(ticks -= (long)hours * 3600L) / 60.0);
        int seconds = (int)(ticks -= (long)minutes * 60L);
        StringBuilder output = new StringBuilder();
        if (hours > 0) {
            output.append(hours).append('h');
            if (minutes == 0) {
                output.append(0).append('m');
            }
        }
        if (minutes > 0) {
            output.append(minutes).append('m');
        }
        output.append(seconds).append('s');
        return output.toString();
    }

    public static long parseDateDiff(String time, boolean future) throws Exception {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            int i = 0;
            while (i < m.groupCount()) {
                if (m.group(i) != null && !m.group(i).isEmpty()) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            return 0L;
        }
        GregorianCalendar c = new GregorianCalendar();
        if (years > 0) {
            ((Calendar)c).add(1, years * (future ? 1 : -1));
        }
        if (months > 0) {
            ((Calendar)c).add(2, months * (future ? 1 : -1));
        }
        if (weeks > 0) {
            ((Calendar)c).add(3, weeks * (future ? 1 : -1));
        }
        if (days > 0) {
            ((Calendar)c).add(5, days * (future ? 1 : -1));
        }
        if (hours > 0) {
            ((Calendar)c).add(11, hours * (future ? 1 : -1));
        }
        if (minutes > 0) {
            ((Calendar)c).add(12, minutes * (future ? 1 : -1));
        }
        if (seconds > 0) {
            ((Calendar)c).add(13, seconds * (future ? 1 : -1));
        }
        GregorianCalendar max = new GregorianCalendar();
        ((Calendar)max).add(1, 10);
        if (c.after(max)) {
            return max.getTimeInMillis();
        }
        return c.getTimeInMillis();
    }

    static int dateDiff(int type, Calendar fromDate, Calendar toDate, boolean future) {
        int diff = 0;
        long savedDate = fromDate.getTimeInMillis();
        while (future && !fromDate.after(toDate) || !future && !fromDate.before(toDate)) {
            savedDate = fromDate.getTimeInMillis();
            fromDate.add(type, future ? 1 : -1);
            ++diff;
        }
        fromDate.setTimeInMillis(savedDate);
        return --diff;
    }

    public static String formatDateDiff(long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        GregorianCalendar now = new GregorianCalendar();
        return DateUtils.formatDateDiff(now, c);
    }

    public static String formatDateDiff(Calendar fromDate, Calendar toDate) {
        boolean future = false;
        if (toDate.equals(fromDate)) {
            return "now";
        }
        if (toDate.after(fromDate)) {
            future = true;
        }
        StringBuilder sb = new StringBuilder();
        int[] types = new int[]{1, 2, 5, 11, 12, 13};
        String[] names = new String[]{"year", "years", "month", "months", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds"};
        int accuracy = 0;
        int i = 0;
        while (i < types.length) {
            if (accuracy > 2) break;
            int diff = DateUtils.dateDiff(types[i], fromDate, toDate, future);
            if (diff > 0) {
                ++accuracy;
                sb.append(" ").append(diff).append(" ").append(names[i * 2 + (diff > 1 ? 1 : 0)]);
            }
            ++i;
        }
        if (sb.length() == 0) {
            return "now";
        }
        return sb.toString().trim();
    }
}

