/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.reqn.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExprJSONEncode
extends SimpleExpression<String> {
    private Expression<String> str;

    private static String encode(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u");
                        sb.append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected String[] get(Event e) {
        return (String[])Arrays.stream(this.str.getAll(e)).map(ExprJSONEncode::encode).toArray(String[]::new);
    }

    public boolean isSingle() {
        return this.str.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "url encoded text";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.str = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprJSONEncode.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"json (safe|encoded|escaped) %strings%"});
    }
}

