/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.reqn.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.btk5h.reqn.HttpResponse;
import com.btk5h.reqn.Reqn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EffRequest
extends Effect {
    static HttpResponse lastResponse;
    private static final Pattern HEADER;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final ReentrantLock SKRIPT_EXECUTION;
    private static final Field DELAYED;
    private static final ExecutorService threadPool;
    private Expression<String> method;
    private Expression<String> url;
    private Expression<String> headers;
    private Expression<String> body;

    protected void execute(Event e) {
        CompletableFuture.supplyAsync(() -> this.sendRequest(e), threadPool).whenComplete((resp, err) -> {
            if (err != null) {
                err.printStackTrace();
                lastResponse = null;
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)Reqn.getInstance(), () -> {
                lastResponse = resp;
                if (this.getNext() != null) {
                    TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
                }
            });
        });
    }

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        this.delay(e);
        this.execute(e);
        return null;
    }

    private void delay(Event e) {
        if (DELAYED != null) {
            try {
                ((Set)DELAYED.get(null)).add(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse sendRequest(Event e) {
        String method = null;
        if (this.method != null) {
            method = ((String)this.method.getSingle(e)).toUpperCase();
        }
        String url = (String)this.url.getSingle(e);
        String[] headers = EMPTY_STRING_ARRAY;
        if (this.headers != null) {
            headers = (String[])this.headers.getAll(e);
        }
        String body = "";
        if (this.body != null) {
            body = String.join((CharSequence)"\n", (CharSequence[])this.body.getAll(e));
        }
        if (url == null) {
            return null;
        }
        HttpURLConnection conn = null;
        try {
            String encoding;
            URL target = new URL(url);
            conn = (HttpURLConnection)target.openConnection();
            for (String header : headers) {
                Matcher headerMatcher = HEADER.matcher(header);
                if (headerMatcher.matches()) {
                    conn.setRequestProperty(headerMatcher.group(1).trim(), headerMatcher.group(2).trim());
                    continue;
                }
                Skript.warning((String)String.format("Malformed header during request to %s: %s", url, header));
            }
            conn.setUseCaches(false);
            if (method != null && !method.equals("GET")) {
                conn.setRequestProperty("Content-Length", Integer.toString(body.getBytes().length));
                conn.setRequestMethod(method);
                conn.setDoOutput(true);
                try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                    out.write(body);
                }
            } else if (!body.equals("")) {
                Skript.warning((String)"Get requests should not have a body");
            }
            String statusLine = conn.getHeaderField(0);
            Map<String, String> responseHeaders = conn.getHeaderFields().entrySet().stream().filter(h -> h.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
            InputStream response = conn.getErrorStream();
            if (response == null) {
                response = conn.getInputStream();
            }
            if ((encoding = conn.getContentEncoding()) != null) {
                if (encoding.equalsIgnoreCase("gzip")) {
                    response = new GZIPInputStream(response);
                } else if (encoding.equalsIgnoreCase("deflate")) {
                    response = new InflaterInputStream(response, new Inflater(true));
                }
            }
            StringBuilder responseBody = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(response));){
                String line;
                while ((line = br.readLine()) != null) {
                    responseBody.append(line);
                    responseBody.append("\n");
                }
            }
            HttpResponse httpResponse = new HttpResponse(conn.getResponseCode(), conn.getResponseMessage(), statusLine, responseHeaders, responseBody.toString());
            return httpResponse;
        }
        catch (MalformedURLException err) {
            Skript.warning((String)("Tried to send a request to a malformed URL: " + url));
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "send http request";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.method = exprs[0];
        this.url = exprs[1];
        switch (parseResult.mark) {
            case 0: {
                this.headers = exprs[2];
                this.body = exprs[3];
                break;
            }
            case 1: {
                this.body = exprs[4];
                this.headers = exprs[5];
            }
        }
        return true;
    }

    static {
        Skript.registerEffect(EffRequest.class, (String[])new String[]{"send [a[n]] [http] [%-string%] [web] request to [the] [url] %string% [with (0\u00a6[the] header[s] %-strings% [and [the] body %-strings%]|1\u00a6[the] body %-strings% [and [the] header[s] %-strings%])]"});
        HEADER = Pattern.compile("(.*?):(.+)");
        EMPTY_STRING_ARRAY = new String[0];
        SKRIPT_EXECUTION = new ReentrantLock(true);
        Field _DELAYED = null;
        try {
            _DELAYED = Delay.class.getDeclaredField("delayed");
            _DELAYED.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            Skript.warning((String)"Skript's 'delayed' method could not be resolved. Some Skript warnings may not be available.");
        }
        DELAYED = _DELAYED;
        threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}

